/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.committable.hbase;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import org.apache.omid.committable.hbase.KeyGenerator;

public class KeyGeneratorImplementations {
    public static KeyGenerator defaultKeyGenerator() {
        return new BucketKeyGenerator();
    }

    public static class SeqKeyGenerator
    implements KeyGenerator {
        @Override
        public byte[] startTimestampToKey(long startTimestamp) throws IOException {
            byte[] bytes = new byte[]{(byte)(startTimestamp >> 56 & 0xFFL), (byte)(startTimestamp >> 48 & 0xFFL), (byte)(startTimestamp >> 40 & 0xFFL), (byte)(startTimestamp >> 32 & 0xFFL), (byte)(startTimestamp >> 24 & 0xFFL), (byte)(startTimestamp >> 16 & 0xFFL), (byte)(startTimestamp >> 8 & 0xFFL), (byte)(startTimestamp & 0xFFL)};
            return bytes;
        }

        @Override
        public long keyToStartTimestamp(byte[] key) {
            assert (key.length == 8);
            return ((long)key[0] & 0xFFL) << 56 | ((long)key[1] & 0xFFL) << 48 | ((long)key[2] & 0xFFL) << 40 | ((long)key[3] & 0xFFL) << 32 | ((long)key[4] & 0xFFL) << 24 | ((long)key[5] & 0xFFL) << 16 | ((long)key[6] & 0xFFL) << 8 | (long)key[7] & 0xFFL;
        }
    }

    public static class BadRandomKeyGenerator
    implements KeyGenerator {
        @Override
        public byte[] startTimestampToKey(long startTimestamp) throws IOException {
            long reversedStartTimestamp = Long.reverse(startTimestamp);
            byte[] bytes = new byte[CodedOutputStream.computeSFixed64SizeNoTag((long)reversedStartTimestamp)];
            CodedOutputStream cos = CodedOutputStream.newInstance((byte[])bytes);
            cos.writeSFixed64NoTag(reversedStartTimestamp);
            cos.flush();
            return bytes;
        }

        @Override
        public long keyToStartTimestamp(byte[] key) throws IOException {
            CodedInputStream cis = CodedInputStream.newInstance((byte[])key);
            return Long.reverse(cis.readSFixed64());
        }
    }

    public static class FullRandomKeyGenerator
    implements KeyGenerator {
        @Override
        public byte[] startTimestampToKey(long startTimestamp) {
            assert (startTimestamp >= 0L);
            long reversedStartTimestamp = Long.reverse(startTimestamp | Long.MIN_VALUE);
            byte[] bytes = new byte[]{(byte)(reversedStartTimestamp >> 56 & 0xFFL), (byte)(reversedStartTimestamp >> 48 & 0xFFL), (byte)(reversedStartTimestamp >> 40 & 0xFFL), (byte)(reversedStartTimestamp >> 32 & 0xFFL), (byte)(reversedStartTimestamp >> 24 & 0xFFL), (byte)(reversedStartTimestamp >> 16 & 0xFFL), (byte)(reversedStartTimestamp >> 8 & 0xFFL), (byte)(reversedStartTimestamp & 0xFEL)};
            return bytes;
        }

        @Override
        public long keyToStartTimestamp(byte[] key) {
            assert (key.length == 8);
            long startTimestamp = ((long)key[0] & 0xFFL) << 56 | ((long)key[1] & 0xFFL) << 48 | ((long)key[2] & 0xFFL) << 40 | ((long)key[3] & 0xFFL) << 32 | ((long)key[4] & 0xFFL) << 24 | ((long)key[5] & 0xFFL) << 16 | ((long)key[6] & 0xFFL) << 8 | (long)key[7] & 0xFFL;
            return Long.reverse(startTimestamp);
        }
    }

    public static class BucketKeyGenerator
    implements KeyGenerator {
        @Override
        public byte[] startTimestampToKey(long startTimestamp) throws IOException {
            byte[] bytes = new byte[]{(byte)(startTimestamp & 0xFL), (byte)(startTimestamp >> 56 & 0xFFL), (byte)(startTimestamp >> 48 & 0xFFL), (byte)(startTimestamp >> 40 & 0xFFL), (byte)(startTimestamp >> 32 & 0xFFL), (byte)(startTimestamp >> 24 & 0xFFL), (byte)(startTimestamp >> 16 & 0xFFL), (byte)(startTimestamp >> 8 & 0xFFL), (byte)(startTimestamp & 0xFFL)};
            return bytes;
        }

        @Override
        public long keyToStartTimestamp(byte[] key) {
            assert (key.length == 9);
            return ((long)key[1] & 0xFFL) << 56 | ((long)key[2] & 0xFFL) << 48 | ((long)key[3] & 0xFFL) << 40 | ((long)key[4] & 0xFFL) << 32 | ((long)key[5] & 0xFFL) << 24 | ((long)key[6] & 0xFFL) << 16 | ((long)key[7] & 0xFFL) << 8 | (long)key[8] & 0xFFL;
        }
    }
}

