/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.statistics;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.metastore.statistics.StatisticsHolder;
import org.apache.drill.metastore.statistics.StatisticsKind;
import org.apache.drill.metastore.util.TableMetadataUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"statistics", "comparator"})
public class ColumnStatistics<T> {
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)JacksonUtils.createJsonMapperBuilder().addModule((Module)new JodaModule())).build();
    private static final ObjectWriter OBJECT_WRITER = MAPPER.writerFor(ColumnStatistics.class);
    private static final ObjectReader OBJECT_READER = MAPPER.readerFor(ColumnStatistics.class);
    private final Map<String, StatisticsHolder<?>> statistics;
    private final Comparator<T> valueComparator;
    private final TypeProtos.MinorType type;

    @JsonCreator
    public ColumnStatistics(@JsonProperty(value="statistics") Collection<StatisticsHolder<?>> statistics, @JsonProperty(value="type") TypeProtos.MinorType type) {
        this.type = type;
        this.valueComparator = type != null ? TableMetadataUtils.getComparator(type) : TableMetadataUtils.getNaturalNullsFirstComparator();
        this.statistics = statistics.stream().collect(Collectors.toMap(statistic -> statistic.getStatisticsKind().getName(), Function.identity(), (a, b) -> a.getStatisticsKind().isExact() ? a : b));
    }

    public ColumnStatistics(Collection<StatisticsHolder<?>> statistics) {
        this(statistics, TypeProtos.MinorType.INT);
    }

    public <V> V get(StatisticsKind<V> statisticsKind) {
        StatisticsHolder<?> statisticsHolder = this.statistics.get(statisticsKind.getName());
        if (statisticsHolder != null) {
            return (V)statisticsHolder.getStatisticsValue();
        }
        return null;
    }

    public boolean contains(StatisticsKind<?> statisticsKind) {
        return this.statistics.containsKey(statisticsKind.getName());
    }

    public boolean containsExact(StatisticsKind<?> statisticsKind) {
        StatisticsHolder<?> statisticsHolder = this.statistics.get(statisticsKind.getName());
        if (statisticsHolder != null) {
            return statisticsHolder.getStatisticsKind().isExact();
        }
        return false;
    }

    public Comparator<T> getValueComparator() {
        return this.valueComparator;
    }

    public ColumnStatistics<T> cloneWith(ColumnStatistics<T> sourceStatistics) {
        HashMap newStats = new HashMap(this.statistics);
        sourceStatistics.statistics.values().forEach(statisticsHolder -> {
            StatisticsKind<?> statisticsKindToMerge = statisticsHolder.getStatisticsKind();
            StatisticsHolder<?> oldStatistics = this.statistics.get(statisticsKindToMerge.getName());
            if (oldStatistics == null || !oldStatistics.getStatisticsKind().isExact() || statisticsKindToMerge.isExact()) {
                newStats.put(statisticsKindToMerge.getName(), (StatisticsHolder<?>)statisticsHolder);
            }
        });
        return new ColumnStatistics<T>(newStats.values(), this.type);
    }

    public ColumnStatistics<T> genericClone(ColumnStatistics<?> sourceStatistics) {
        return this.cloneWith(sourceStatistics);
    }

    @JsonProperty(value="statistics")
    private Collection<StatisticsHolder<?>> getAll() {
        return this.statistics.values();
    }

    @JsonProperty(value="type")
    public TypeProtos.MinorType getComparatorType() {
        return this.type;
    }

    public String jsonString() {
        try {
            return OBJECT_WRITER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to convert column statistics to json string", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStatistics that = (ColumnStatistics)o;
        return Objects.equals(this.statistics, that.statistics) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.statistics, this.type);
    }

    public String toString() {
        return new StringJoiner(", ", ColumnStatistics.class.getSimpleName() + "[", "]").add("statistics=" + String.valueOf(this.statistics)).add("type=" + String.valueOf(this.type)).toString();
    }

    public static ColumnStatistics<?> of(String columnStatistics) {
        try {
            return (ColumnStatistics)OBJECT_READER.readValue(columnStatistics);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert column statistics from json string: " + columnStatistics, e);
        }
    }
}

