/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.operate;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.drill.metastore.exceptions.MetastoreException;
import org.apache.drill.metastore.metadata.MetadataType;

public interface MetadataTypeValidator {
    public Set<MetadataType> supportedMetadataTypes();

    default public void validate(Set<MetadataType> metadataTypes) {
        if (metadataTypes == null || metadataTypes.isEmpty()) {
            throw new MetastoreException("Metadata type(s) must be indicated");
        }
        Set<MetadataType> supportedMetadataTypes = this.supportedMetadataTypes();
        Set unsupportedMetadataTypes = metadataTypes.stream().filter(metadataType -> !supportedMetadataTypes.contains(metadataType)).collect(Collectors.toSet());
        if (!unsupportedMetadataTypes.isEmpty()) {
            throw new MetastoreException("Unsupported metadata types are detected: " + String.valueOf(unsupportedMetadataTypes));
        }
    }
}

