/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.expressions;

import java.util.StringJoiner;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.expressions.FilterExpression;

public abstract class SimplePredicate<T>
implements FilterExpression {
    private final MetastoreColumn column;
    private final FilterExpression.Operator operator;
    private final T value;

    protected SimplePredicate(MetastoreColumn column, FilterExpression.Operator operator, T value) {
        this.column = column;
        this.operator = operator;
        this.value = value;
    }

    public MetastoreColumn column() {
        return this.column;
    }

    public T value() {
        return this.value;
    }

    @Override
    public FilterExpression.Operator operator() {
        return this.operator;
    }

    public String toString() {
        return new StringJoiner(", ", SimplePredicate.class.getSimpleName() + "[", "]").add("column=" + String.valueOf((Object)this.column)).add("operator=" + String.valueOf((Object)this.operator)).add("value=" + String.valueOf(this.value)).toString();
    }

    public static class GreaterThanOrEqual<T>
    extends SimplePredicate<T> {
        public GreaterThanOrEqual(MetastoreColumn column, T value) {
            super(column, FilterExpression.Operator.GREATER_THAN_OR_EQUAL, value);
        }

        public <V> V accept(FilterExpression.Visitor<V> visitor) {
            return visitor.visit(this);
        }
    }

    public static class GreaterThan<T>
    extends SimplePredicate<T> {
        public GreaterThan(MetastoreColumn column, T value) {
            super(column, FilterExpression.Operator.GREATER_THAN, value);
        }

        public <V> V accept(FilterExpression.Visitor<V> visitor) {
            return visitor.visit(this);
        }
    }

    public static class LessThanOrEqual<T>
    extends SimplePredicate<T> {
        public LessThanOrEqual(MetastoreColumn column, T value) {
            super(column, FilterExpression.Operator.LESS_THAN_OR_EQUAL, value);
        }

        public <V> V accept(FilterExpression.Visitor<V> visitor) {
            return visitor.visit(this);
        }
    }

    public static class LessThan<T>
    extends SimplePredicate<T> {
        public LessThan(MetastoreColumn column, T value) {
            super(column, FilterExpression.Operator.LESS_THAN, value);
        }

        public <V> V accept(FilterExpression.Visitor<V> visitor) {
            return visitor.visit(this);
        }
    }

    public static class NotEqual<T>
    extends SimplePredicate<T> {
        public NotEqual(MetastoreColumn column, T value) {
            super(column, FilterExpression.Operator.NOT_EQUAL, value);
        }

        public <V> V accept(FilterExpression.Visitor<V> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Equal<T>
    extends SimplePredicate<T> {
        public Equal(MetastoreColumn column, T value) {
            super(column, FilterExpression.Operator.EQUAL, value);
        }

        public <V> V accept(FilterExpression.Visitor<V> visitor) {
            return visitor.visit(this);
        }
    }
}

