/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.rdbms.components.tables;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.rdbms.components.tables.TablesMetadataMapper;
import org.apache.drill.metastore.rdbms.exception.RdbmsMetastoreException;
import org.apache.drill.metastore.rdbms.operate.RdbmsOperation;
import org.apache.drill.metastore.rdbms.transform.AbstractTransformer;
import org.apache.drill.metastore.rdbms.transform.MetadataMapper;
import org.jooq.Record;

public class TablesTransformer
extends AbstractTransformer<TableMetadataUnit> {
    private static final TablesTransformer INSTANCE = new TablesTransformer();
    private final Map<MetadataType, MetadataMapper<TableMetadataUnit, ? extends Record>> MAPPERS = ImmutableMap.of((Object)MetadataType.TABLE, (Object)TablesMetadataMapper.TableMapper.get(), (Object)MetadataType.SEGMENT, (Object)TablesMetadataMapper.SegmentMapper.get(), (Object)MetadataType.FILE, (Object)TablesMetadataMapper.FileMapper.get(), (Object)MetadataType.ROW_GROUP, (Object)TablesMetadataMapper.RowGroupMapper.get(), (Object)MetadataType.PARTITION, (Object)TablesMetadataMapper.PartitionMapper.get());

    public static TablesTransformer get() {
        return INSTANCE;
    }

    @Override
    public Set<MetadataMapper<TableMetadataUnit, ? extends Record>> toMappers(Set<MetadataType> metadataTypes) {
        if (metadataTypes.contains(MetadataType.ALL)) {
            return Sets.newHashSet(this.MAPPERS.values());
        }
        return metadataTypes.stream().map(this::toMapper).collect(Collectors.toSet());
    }

    @Override
    public MetadataMapper<TableMetadataUnit, ? extends Record> toMapper(MetadataType metadataType) {
        MetadataMapper<TableMetadataUnit, ? extends Record> mapper = this.MAPPERS.get(metadataType);
        if (mapper == null) {
            throw new RdbmsMetastoreException("Metadata mapper is absent for type: " + String.valueOf(metadataType));
        }
        return mapper;
    }

    @Override
    public List<RdbmsOperation.Overwrite> toOverwrite(List<TableMetadataUnit> units) {
        Map<String, List<TableMetadataUnit>> unitsByTables = units.stream().collect(Collectors.groupingBy(TableMetadataUnit::metadataType));
        return unitsByTables.entrySet().stream().map(entry -> this.toOverwrite((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }
}

