/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import java.util.Collections;
import java.util.Iterator;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.LogicalExpressionBase;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertExpression
extends LogicalExpressionBase
implements Iterable<LogicalExpression> {
    static final Logger logger = LoggerFactory.getLogger(ConvertExpression.class);
    public static final String CONVERT_FROM = "convert_from";
    public static final String CONVERT_TO = "convert_to";
    private final LogicalExpression input;
    private final TypeProtos.MajorType type;
    private final String convertFunction;
    private final String encodingType;

    public ConvertExpression(String convertFunction, String encodingType, LogicalExpression input, ExpressionPosition pos) {
        super(pos);
        this.input = input;
        this.convertFunction = CONVERT_FROM.equals(convertFunction.toLowerCase()) ? CONVERT_FROM : CONVERT_TO;
        this.encodingType = encodingType.toUpperCase();
        this.type = Types.getMajorTypeFromName((String)encodingType.split("_", 2)[0].toLowerCase());
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitConvertExpression(this, value);
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return Collections.singleton(this.input).iterator();
    }

    public String getConvertFunction() {
        return this.convertFunction;
    }

    public LogicalExpression getInput() {
        return this.input;
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        return this.type;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String toString() {
        return "ConvertExpression [input=" + String.valueOf(this.input) + ", type=" + Types.toString((TypeProtos.MajorType)this.type) + ", convertFunction=" + this.convertFunction + ", conversionType=" + this.encodingType + "]";
    }
}

