/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.hive.client.DrillHiveMetaStoreClient;
import org.apache.drill.exec.store.hive.schema.HiveSchemaFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveDatabaseSchema
extends AbstractSchema {
    private static final Logger logger = LoggerFactory.getLogger(HiveDatabaseSchema.class);
    private final HiveSchemaFactory.HiveSchema hiveSchema;
    private Map<String, Schema.TableType> tables;
    private final DrillHiveMetaStoreClient mClient;
    private final SchemaConfig schemaConfig;

    public HiveDatabaseSchema(HiveSchemaFactory.HiveSchema hiveSchema, String name, DrillHiveMetaStoreClient mClient, SchemaConfig schemaConfig) {
        super(hiveSchema.getSchemaPath(), name);
        this.hiveSchema = hiveSchema;
        this.mClient = mClient;
        this.schemaConfig = schemaConfig;
    }

    public Table getTable(String tableName) {
        return this.hiveSchema.getDrillTable(this.name, tableName);
    }

    public Collection<Map.Entry<String, Schema.TableType>> getTableNamesAndTypes() {
        this.ensureInitTables();
        return this.tables.entrySet();
    }

    public Set<String> getTableNames() {
        this.ensureInitTables();
        return this.tables.keySet();
    }

    private void ensureInitTables() {
        if (this.tables == null) {
            try {
                this.tables = this.mClient.getTableNamesAndTypes(this.name, this.schemaConfig.getIgnoreAuthErrors());
            }
            catch (TException e) {
                logger.warn(String.format("Exception was thrown while getting table names and type for db '%s'.", this.name), (Throwable)e);
                this.tables = Collections.emptyMap();
            }
        }
    }

    public String getTypeName() {
        return "hive";
    }

    public boolean areTableNamesCaseSensitive() {
        return false;
    }
}

