/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.BaseParquetReaders;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class GenericParquetReaders
extends BaseParquetReaders<Record> {
    private static final GenericParquetReaders INSTANCE = new GenericParquetReaders();

    private GenericParquetReaders() {
    }

    public static ParquetValueReader<Record> buildReader(Schema expectedSchema, MessageType fileSchema) {
        return INSTANCE.createReader(expectedSchema, fileSchema);
    }

    public static ParquetValueReader<Record> buildReader(Schema expectedSchema, MessageType fileSchema, Map<Integer, ?> idToConstant) {
        return INSTANCE.createReader(expectedSchema, fileSchema, idToConstant);
    }

    @Override
    protected ParquetValueReader<Record> createStructReader(List<Type> types, List<ParquetValueReader<?>> fieldReaders, Types.StructType structType) {
        return new RecordReader(types, fieldReaders, structType);
    }

    private static class RecordReader
    extends ParquetValueReaders.StructReader<Record, Record> {
        private final Types.StructType structType;

        RecordReader(List<Type> types, List<ParquetValueReader<?>> readers, Types.StructType struct) {
            super(types, readers);
            this.structType = struct;
        }

        @Override
        protected Record newStructData(Record reuse) {
            if (reuse != null) {
                return reuse;
            }
            return GenericRecord.create((Types.StructType)this.structType);
        }

        @Override
        protected Object getField(Record intermediate, int pos) {
            return intermediate.get(pos);
        }

        @Override
        protected Record buildStruct(Record struct) {
            return struct;
        }

        @Override
        protected void set(Record struct, int pos, Object value) {
            struct.set(pos, value);
        }
    }
}

