/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg.snapshot;

import com.google.common.base.Preconditions;
import org.apache.drill.exec.store.iceberg.snapshot.Snapshot;
import org.apache.drill.exec.store.iceberg.snapshot.SnapshotAfter;
import org.apache.drill.exec.store.iceberg.snapshot.SnapshotById;
import org.apache.drill.exec.store.iceberg.snapshot.SnapshotByTime;
import org.apache.drill.exec.store.iceberg.snapshot.SnapshotsBetween;

public class SnapshotFactory {
    public static final SnapshotFactory INSTANCE = new SnapshotFactory();

    public Snapshot createSnapshot(SnapshotContext snapshotContext) {
        if (snapshotContext.getSnapshotId() != null) {
            Preconditions.checkArgument((snapshotContext.getSnapshotAsOfTime() == null ? 1 : 0) != 0, (Object)"Both 'snapshotId' and 'snapshotAsOfTime' cannot be specified");
            Preconditions.checkArgument((snapshotContext.getFromSnapshotId() == null ? 1 : 0) != 0, (Object)"Both 'snapshotId' and 'fromSnapshotId' cannot be specified");
            Preconditions.checkArgument((snapshotContext.getToSnapshotId() == null ? 1 : 0) != 0, (Object)"Both 'snapshotId' and 'toSnapshotId' cannot be specified");
            return new SnapshotById(snapshotContext.getSnapshotId());
        }
        if (snapshotContext.getSnapshotAsOfTime() != null) {
            Preconditions.checkArgument((snapshotContext.getSnapshotId() == null ? 1 : 0) != 0, (Object)"Both 'snapshotId' and 'snapshotAsOfTime' cannot be specified");
            Preconditions.checkArgument((snapshotContext.getFromSnapshotId() == null ? 1 : 0) != 0, (Object)"Both 'snapshotAsOfTime' and 'fromSnapshotId' cannot be specified");
            Preconditions.checkArgument((snapshotContext.getToSnapshotId() == null ? 1 : 0) != 0, (Object)"Both 'snapshotAsOfTime' and 'toSnapshotId' cannot be specified");
            return new SnapshotByTime(snapshotContext.getSnapshotAsOfTime());
        }
        if (snapshotContext.getFromSnapshotId() != null) {
            Preconditions.checkArgument((snapshotContext.getSnapshotId() == null ? 1 : 0) != 0, (Object)"Both 'snapshotId' and 'fromSnapshotId' cannot be specified");
            Preconditions.checkArgument((snapshotContext.getSnapshotAsOfTime() == null ? 1 : 0) != 0, (Object)"Both 'snapshotAsOfTime' and 'fromSnapshotId' cannot be specified");
            return snapshotContext.getToSnapshotId() == null ? new SnapshotAfter(snapshotContext.getFromSnapshotId()) : new SnapshotsBetween(snapshotContext.getFromSnapshotId(), snapshotContext.getToSnapshotId());
        }
        return null;
    }

    public static class SnapshotContext {
        private final Long snapshotId;
        private final Long snapshotAsOfTime;
        private final Long fromSnapshotId;
        private final Long toSnapshotId;

        SnapshotContext(SnapshotContextBuilder builder) {
            this.snapshotId = builder.snapshotId;
            this.snapshotAsOfTime = builder.snapshotAsOfTime;
            this.fromSnapshotId = builder.fromSnapshotId;
            this.toSnapshotId = builder.toSnapshotId;
        }

        public static SnapshotContextBuilder builder() {
            return new SnapshotContextBuilder();
        }

        public Long getSnapshotId() {
            return this.snapshotId;
        }

        public Long getSnapshotAsOfTime() {
            return this.snapshotAsOfTime;
        }

        public Long getFromSnapshotId() {
            return this.fromSnapshotId;
        }

        public Long getToSnapshotId() {
            return this.toSnapshotId;
        }

        public static class SnapshotContextBuilder {
            private Long snapshotId;
            private Long snapshotAsOfTime;
            private Long fromSnapshotId;
            private Long toSnapshotId;

            public SnapshotContextBuilder snapshotId(Long snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public SnapshotContextBuilder snapshotAsOfTime(Long snapshotAsOfTime) {
                this.snapshotAsOfTime = snapshotAsOfTime;
                return this;
            }

            public SnapshotContextBuilder fromSnapshotId(Long fromSnapshotId) {
                this.fromSnapshotId = fromSnapshotId;
                return this;
            }

            public SnapshotContextBuilder toSnapshotId(Long toSnapshotId) {
                this.toSnapshotId = toSnapshotId;
                return this;
            }

            public SnapshotContext build() {
                return new SnapshotContext(this);
            }
        }
    }
}

