/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import au.com.bytecode.opencsv.CSVReader;
import com.splunk.Event;
import com.splunk.ResultsReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ResultsReaderCsv
extends ResultsReader {
    private CSVReader csvReader = null;
    private List<String> keys;

    public ResultsReaderCsv(InputStream inputStream) throws IOException {
        super(inputStream, false);
        if (this.isExportStream) {
            throw new UnsupportedOperationException("A stream from an export endpoint is not supported by a CSV result reader. Use XML or JSON search output format and matching reader instead.");
        }
        this.csvReader = new CSVReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
        String[] keyArray = this.csvReader.readNext();
        if (keyArray.length == 1 && keyArray[0].trim().equals("")) {
            keyArray = this.csvReader.readNext();
        }
        this.keys = Arrays.asList(keyArray);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.csvReader != null) {
            this.csvReader.close();
        }
        this.csvReader = null;
    }

    @Override
    public boolean isPreview() {
        throw new UnsupportedOperationException("isPreview() is not supported by this subclass.");
    }

    @Override
    public Collection<String> getFields() {
        return this.keys;
    }

    @Override
    Event getNextEventInCurrentSet() throws IOException {
        Event returnData = null;
        String[] line = this.csvReader.readNext();
        if (line != null) {
            if (line.length == 1 && line[0].equals("") && (line = this.csvReader.readNext()) == null) {
                return returnData;
            }
            returnData = new Event();
            int count = 0;
            for (String key : this.keys) {
                String delimitedValues = line[count++];
                returnData.putSingleOrDelimited(key, delimitedValues);
            }
        }
        return returnData;
    }
}

