/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.Entity;
import com.splunk.EntityCollection;
import com.splunk.Receiver;
import com.splunk.ReceiverBehavior;
import com.splunk.ResponseMessage;
import com.splunk.Service;
import com.splunk.SplunkException;
import com.splunk.Upload;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;

public class Index
extends Entity {
    Index(Service service, String path) {
        super(service, path);
    }

    public Socket attach() throws IOException {
        Receiver receiver = this.service.getReceiver();
        return receiver.attach(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachWith(ReceiverBehavior behavior) throws IOException {
        Socket socket = null;
        OutputStream output = null;
        try {
            socket = this.attach();
            output = socket.getOutputStream();
            behavior.run(output);
            output.flush();
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }

    public Socket attach(Args args) throws IOException {
        Receiver receiver = this.service.getReceiver();
        return receiver.attach(this.getName(), args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Index clean(int maxSeconds) {
        Args saved = new Args();
        saved.put("maxTotalDataSizeMB", this.getMaxTotalDataSizeMB());
        saved.put("frozenTimePeriodInSecs", this.getFrozenTimePeriodInSecs());
        try {
            Args reset = new Args();
            reset.put("maxTotalDataSizeMB", "1");
            reset.put("frozenTimePeriodInSecs", "1");
            this.update(reset);
            this.rollHotBuckets();
            long startTime = System.currentTimeMillis();
            long endTime = startTime + (long)(maxSeconds * 1000);
            while (true) {
                long timeLeft;
                if ((timeLeft = endTime - System.currentTimeMillis()) <= 0L) {
                    throw new SplunkException(2, "Index cleaning timed out");
                }
                Thread.sleep(Math.min(1000L, timeLeft));
                if (this.getTotalEventCount() == 0) {
                    Index index = this;
                    return index;
                }
                this.refresh();
                continue;
                break;
            }
        }
        catch (InterruptedException e) {
            SplunkException f = new SplunkException(4, "Index cleaning interrupted.");
            f.initCause(e);
            throw f;
        }
        finally {
            this.update(saved);
        }
    }

    public boolean getAssureUTF8() {
        return this.getBoolean("assureUTF8");
    }

    public int getBloomfilterTotalSizeKB() {
        return this.getInteger("bloomfilterTotalSizeKB", 0);
    }

    public String getBucketRebuildMemoryHint() {
        return this.getString("bucketRebuildMemoryHint");
    }

    public String getColdPath() {
        return this.getString("coldPath", null);
    }

    public String getColdPathExpanded() {
        return this.getString("coldPath_expanded", null);
    }

    public String getColdToFrozenDir() {
        return this.getString("coldToFrozenDir", null);
    }

    public String getColdToFrozenScript() {
        return this.getString("coldToFrozenScript", null);
    }

    public boolean getCompressRawdata() {
        return this.getBoolean("compressRawdata");
    }

    public int getCurrentDBSizeMB() {
        return this.getInteger("currentDBSizeMB");
    }

    public String getDefaultDatabase() {
        return this.getString("defaultDatabase");
    }

    public boolean getEnableOnlineBucketRepair() {
        return this.getBoolean("enableOnlineBucketRepair");
    }

    public boolean getEnableRealtimeSearch() {
        return this.getBoolean("enableRealtimeSearch");
    }

    public int getFrozenTimePeriodInSecs() {
        return this.getInteger("frozenTimePeriodInSecs");
    }

    public String getHomePath() {
        return this.getString("homePath", null);
    }

    public String getHomePathExpanded() {
        return this.getString("homePath_expanded", null);
    }

    public String getIndexThreads() {
        return this.getString("indexThreads");
    }

    public String getLastInitTime() {
        return this.getString("lastInitTime", null);
    }

    public String getMaxBloomBackfillBucketAge() {
        return this.getString("maxBloomBackfillBucketAge", null);
    }

    public int getMaxConcurrentOptimizes() {
        return this.getInteger("maxConcurrentOptimizes");
    }

    public String getMaxDataSize() {
        return this.getString("maxDataSize");
    }

    public String getMaxHotBuckets() {
        return this.getString("maxHotBuckets");
    }

    public int getMaxHotIdleSecs() {
        return this.getInteger("maxHotIdleSecs");
    }

    public int getMaxHotSpanSecs() {
        return this.getInteger("maxHotSpanSecs");
    }

    public int getMaxMemMB() {
        return this.getInteger("maxMemMB");
    }

    public int getMaxMetaEntries() {
        return this.getInteger("maxMetaEntries");
    }

    public int getMaxRunningProcessGroups() {
        return this.getInteger("maxRunningProcessGroups", 0);
    }

    public Date getMaxTime() {
        return this.getDate("maxTime", null);
    }

    public int getMaxTotalDataSizeMB() {
        return this.getInteger("maxTotalDataSizeMB");
    }

    public int getMaxTimeUnreplicatedNoAcks() {
        return this.getInteger("maxTimeUnreplicatedNoAcks");
    }

    public int getMaxTimeUnreplicatedWithAcks() {
        return this.getInteger("maxTimeUnreplicatedWithAcks");
    }

    public int getMaxWarmDBCount() {
        return this.getInteger("maxWarmDBCount");
    }

    public String getMemPoolMB() {
        return this.getString("memPoolMB");
    }

    public String getMinRawFileSyncSecs() {
        return this.getString("minRawFileSyncSecs");
    }

    public Date getMinTime() {
        return this.getDate("minTime", null);
    }

    public int getNumHotBuckets() {
        return this.getInteger("numHotBuckets", 0);
    }

    public int getNumWarmBuckets() {
        return this.getInteger("numWarmBuckets", 0);
    }

    public int getNumBloomfilters() {
        return this.getInteger("numBloomfilters", 0);
    }

    public int getPartialServiceMetaPeriod() {
        return this.getInteger("partialServiceMetaPeriod");
    }

    public int getQuarantineFutureSecs() {
        return this.getInteger("quarantineFutureSecs");
    }

    public int getQuarantinePastSecs() {
        return this.getInteger("quarantinePastSecs");
    }

    public int getRawChunkSizeBytes() {
        return this.getInteger("rawChunkSizeBytes");
    }

    public int getRotatePeriodInSecs() {
        return this.getInteger("rotatePeriodInSecs");
    }

    public int getServiceMetaPeriod() {
        return this.getInteger("serviceMetaPeriod");
    }

    public String getSuppressBannerList() {
        return this.getString("suppressBannerList", null);
    }

    public int getSync() {
        return this.getInteger("sync");
    }

    public boolean getSyncMeta() {
        return this.getBoolean("syncMeta");
    }

    public String getThawedPath() {
        return this.getString("thawedPath", null);
    }

    public String getThawedPathExpanded() {
        return this.getString("thawedPath_expanded", null);
    }

    public int getThrottleCheckPeriod() {
        return this.getInteger("throttleCheckPeriod");
    }

    public int getTotalEventCount() {
        return this.getInteger("totalEventCount");
    }

    public boolean isInternal() {
        return this.getBoolean("isInternal");
    }

    public void rollHotBuckets() {
        ResponseMessage response = this.service.post(this.path + "/roll-hot-buckets");
        assert (response.getStatus() == 200);
    }

    public void setAssureUTF8(boolean assure) {
        this.setCacheValue("assureUTF8", assure);
    }

    public void setBlockSignSize(int value) {
        this.setCacheValue("blockSignSize", value);
    }

    public void setBucketRebuildMemoryHint(String value) {
        this.setCacheValue("bucketRebuildMemoryHint", value);
    }

    public void setColdToFrozenDir(String destination) {
        this.setCacheValue("coldToFrozenDir", destination);
    }

    public void setColdToFrozenScript(String script) {
        this.setCacheValue("coldToFrozenScript", script);
    }

    public void setEnableOnlineBucketRepair(boolean value) {
        this.setCacheValue("enableOnlineBucketRepair", value);
    }

    public void setFrozenTimePeriodInSecs(int seconds) {
        this.setCacheValue("frozenTimePeriodInSecs", seconds);
    }

    public void setMaxBloomBackfillBucketAge(String time) {
        this.setCacheValue("maxBloomBackfillBucketAge", time);
    }

    public void setMaxConcurrentOptimizes(int processes) {
        this.setCacheValue("maxConcurrentOptimizes", processes);
    }

    public void setMaxDataSize(String size) {
        this.setCacheValue("maxDataSize", size);
    }

    public void setMaxHotBuckets(String size) {
        this.setCacheValue("maxHotBuckets", size);
    }

    public void setMaxHotIdleSecs(int seconds) {
        this.setCacheValue("maxHotIdleSecs", seconds);
    }

    public void setMaxHotSpanSecs(int seconds) {
        this.setCacheValue("maxHotSpanSecs", seconds);
    }

    public void setMaxMemMB(int memory) {
        this.setCacheValue("maxMemMB", memory);
    }

    public void setMaxMetaEntries(int entries) {
        this.setCacheValue("maxMetaEntries", entries);
    }

    public void setMaxTimeUnreplicatedNoAcks(int value) {
        this.setCacheValue("maxTimeUnreplicatedNoAcks", value);
    }

    public void setMaxTimeUnreplicatedWithAcks(int value) {
        this.setCacheValue("maxTimeUnreplicatedWithAcks", value);
    }

    public void setMaxTotalDataSizeMB(int size) {
        this.setCacheValue("maxTotalDataSizeMB", size);
    }

    public void setMaxWarmDBCount(int buckets) {
        this.setCacheValue("maxWarmDBCount", buckets);
    }

    public void setMinRawFileSyncSecs(String frequency) {
        this.setCacheValue("minRawFileSyncSecs", frequency);
    }

    public void setPartialServiceMetaPeriod(int frequency) {
        this.setCacheValue("partialServiceMetaPeriod", frequency);
    }

    public void setQuarantineFutureSecs(int window) {
        this.setCacheValue("quarantineFutureSecs", window);
    }

    public void setQuarantinePastSecs(int window) {
        this.setCacheValue("quarantinePastSecs", window);
    }

    public void setRawChunkSizeBytes(int size) {
        this.setCacheValue("rawChunkSizeBytes", size);
    }

    public void setRotatePeriodInSecs(int frequency) {
        this.setCacheValue("rotatePeriodInSecs", frequency);
    }

    public void setServiceMetaPeriod(int frequency) {
        this.setCacheValue("serviceMetaPeriod", frequency);
    }

    public void setSyncMeta(boolean sync) {
        this.setCacheValue("syncMeta", sync);
    }

    public void setThrottleCheckPeriod(int frequency) {
        this.setCacheValue("throttleCheckPeriod", frequency);
    }

    public void submit(String data) {
        Receiver receiver = this.service.getReceiver();
        receiver.submit(this.getName(), data);
    }

    public void submit(Args args, String data) {
        Receiver receiver = this.service.getReceiver();
        receiver.submit(this.getName(), args, data);
    }

    public void upload(String filename) {
        EntityCollection<Upload> uploads = this.service.getUploads();
        Args args = new Args("index", this.getName());
        uploads.create(filename, args);
    }

    public void upload(String filename, Args args) {
        EntityCollection<Upload> uploads = this.service.getUploads();
        if (args.containsKey("index")) {
            throw new IllegalArgumentException("The 'index' parameter cannot be passed to an index's oneshot upload.");
        }
        args.add("index", this.getName());
        uploads.create(filename, args);
    }
}

