/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.ShuffleClientImpl;
import org.apache.celeborn.client.read.CelebornInputStream;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.exception.PartitionUnRetryAbleException;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PbOpenStreamList;
import org.apache.celeborn.common.protocol.PbOpenStreamListResponse;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.PbStreamHandlerOpt;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.spark.Aggregator;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.TaskContext;
import org.apache.spark.celeborn.ExceptionMakerHelper$;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.celeborn.CelebornShuffleHandle;
import org.apache.spark.shuffle.celeborn.CelebornShuffleReader$;
import org.apache.spark.shuffle.celeborn.ExecutorShuffleIdTracker;
import org.apache.spark.shuffle.celeborn.SparkCommonUtils;
import org.apache.spark.shuffle.celeborn.SparkUtils;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.collection.ExternalSorter;
import org.apache.spark.util.collection.ExternalSorter$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t%c\u0001B\u0011#\u00015B\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005/\"A!\f\u0001B\u0001B\u0003%q\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003X\u0011!a\u0006A!A!\u0002\u00139\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\t]\u0002\u0011\t\u0011)A\u0005_\")!\u000f\u0001C\u0001g\"I\u0011Q\u0001\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\n!I\u0011q\u0003\u0001C\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u001c!I\u0011\u0011\t\u0001C\u0002\u0013%\u00111\t\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002F!I\u00111\u000e\u0001C\u0002\u0013%\u0011Q\u000e\u0005\t\u0003k\u0002\u0001\u0015!\u0003\u0002p!I\u0011q\u000f\u0001C\u0002\u0013%\u0011\u0011\u0010\u0005\b\u0003w\u0002\u0001\u0015!\u0003X\u0011\u001d\ti\b\u0001C!\u0003\u007fBq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002:\u0002!\t!a/\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\u001e9\u0011\u0011\u001e\u0012\t\u0002\u0005-hAB\u0011#\u0011\u0003\ti\u000f\u0003\u0004s5\u0011\u0005\u0011q\u001e\u0005\n\u0003cT\u0002\u0019!C\u0001\u0003gD\u0011\"!@\u001b\u0001\u0004%\t!a@\t\u0011\t\u0015!\u0004)Q\u0005\u0003kD\u0011Ba\u0002\u001b#\u0003%\tA!\u0003\t\u0013\t\u0015\"$%A\u0005\u0002\t\u001d\"!F\"fY\u0016\u0014wN\u001d8TQV4g\r\\3SK\u0006$WM\u001d\u0006\u0003G\u0011\n\u0001bY3mK\n|'O\u001c\u0006\u0003K\u0019\nqa\u001d5vM\u001adWM\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001)2AL\u001eF'\u0011\u0001q&N$\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g!\u00111t'\u000f#\u000e\u0003\u0011J!\u0001\u000f\u0013\u0003\u001bMCWO\u001a4mKJ+\u0017\rZ3s!\tQ4\b\u0004\u0001\u0005\u000bq\u0002!\u0019A\u001f\u0003\u0003-\u000b\"AP!\u0011\u0005Az\u0014B\u0001!2\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\r\"\n\u0005\r\u000b$aA!osB\u0011!(\u0012\u0003\u0006\r\u0002\u0011\r!\u0010\u0002\u0002\u0007B\u0011\u0001jS\u0007\u0002\u0013*\u0011!JJ\u0001\tS:$XM\u001d8bY&\u0011A*\u0013\u0002\b\u0019><w-\u001b8h\u0003\u0019A\u0017M\u001c3mKB\u0012q\n\u0016\t\u0006!FK4\u000bR\u0007\u0002E%\u0011!K\t\u0002\u0016\u0007\u0016dWMY8s]NCWO\u001a4mK\"\u000bg\u000e\u001a7f!\tQD\u000bB\u0005V\u0003\u0005\u0005\t\u0011!B\u0001{\t\u0019q\fJ\u0019\u0002\u001dM$\u0018M\u001d;QCJ$\u0018\u000e^5p]B\u0011\u0001\u0007W\u0005\u00033F\u00121!\u00138u\u00031)g\u000e\u001a)beRLG/[8o\u00035\u0019H/\u0019:u\u001b\u0006\u0004\u0018J\u001c3fq\u0006YQM\u001c3NCBLe\u000eZ3y\u0003\u001d\u0019wN\u001c;fqR\u0004\"a\u00181\u000e\u0003\u0019J!!\u0019\u0014\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010^\u0001\u0005G>tg\r\u0005\u0002eQ6\tQM\u0003\u0002gO\u000611m\\7n_:T!a\t\u0015\n\u0005%,'\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0017aB7fiJL7m\u001d\t\u0003m1L!!\u001c\u0013\u00035MCWO\u001a4mKJ+\u0017\rZ'fiJL7m\u001d*fa>\u0014H/\u001a:\u0002!MDWO\u001a4mK&#GK]1dW\u0016\u0014\bC\u0001)q\u0013\t\t(E\u0001\rFq\u0016\u001cW\u000f^8s'\",hM\u001a7f\u0013\u0012$&/Y2lKJ\fa\u0001P5oSRtD\u0003\u0004;vundXP`@\u0002\u0002\u0005\r\u0001\u0003\u0002)\u0001s\u0011CQ!\u0014\u0006A\u0002Y\u0004$a^=\u0011\u000bA\u000b\u0016\b\u001f#\u0011\u0005iJH!C+v\u0003\u0003\u0005\tQ!\u0001>\u0011\u00151&\u00021\u0001X\u0011\u0015Q&\u00021\u0001X\u0011\u001dY&\u0002%AA\u0002]Cq\u0001\u0018\u0006\u0011\u0002\u0003\u0007q\u000bC\u0003^\u0015\u0001\u0007a\fC\u0003c\u0015\u0001\u00071\rC\u0003k\u0015\u0001\u00071\u000eC\u0003o\u0015\u0001\u0007q.A\u0002eKB,\"!!\u00031\t\u0005-\u00111\u0003\t\b?\u00065\u0011(!\u0005E\u0013\r\tyA\n\u0002\u0012'\",hM\u001a7f\t\u0016\u0004XM\u001c3f]\u000eL\bc\u0001\u001e\u0002\u0014\u0011IQ+AA\u0001\u0002\u0003\u0015\t!P\u0001\u0005I\u0016\u0004\b%A\u0007tQV4g\r\\3DY&,g\u000e^\u000b\u0003\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C9\u0017AB2mS\u0016tG/\u0003\u0003\u0002&\u0005}!!D*ik\u001a4G.Z\"mS\u0016tG/\u0001\btQV4g\r\\3DY&,g\u000e\u001e\u0011)\u00079\tY\u0003\u0005\u0003\u0002.\u0005uRBAA\u0018\u0015\u0011\t\tDa\u000f\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0004M\n\u001d#\u0002BA\u001c\u0003s\taaZ8pO2,'BAA\u001e\u0003\r\u0019w.\\\u0005\u0005\u0003\u007f\tyCA\tWSNL'\r\\3G_J$Vm\u001d;j]\u001e\fA\"\u001a=dKB$\u0018n\u001c8SK\u001a,\"!!\u0012\u0011\r\u0005\u001d\u0013\u0011LA/\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013AB1u_6L7M\u0003\u0003\u0002P\u0005E\u0013AC2p]\u000e,(O]3oi*!\u00111KA+\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006LA!a\u0017\u0002J\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\u0011\t\u0019'!\u0016\u0002\u0005%|\u0017\u0002BA4\u0003C\u00121\"S(Fq\u000e,\u0007\u000f^5p]\u0006iQ\r_2faRLwN\u001c*fM\u0002\n!\u0003\u001e5s_^\u001ch)\u001a;dQ\u001a\u000b\u0017\u000e\\;sKV\u0011\u0011q\u000e\t\u0004a\u0005E\u0014bAA:c\t9!i\\8mK\u0006t\u0017a\u0005;ie><8OR3uG\"4\u0015-\u001b7ve\u0016\u0004\u0013\u0001E3oG>$W\rZ!ui\u0016l\u0007\u000f^%e+\u00059\u0016!E3oG>$W\rZ!ui\u0016l\u0007\u000f^%eA\u0005!!/Z1e)\t\t\t\t\u0005\u0004\u0002\u0004\u0006M\u0015\u0011\u0014\b\u0005\u0003\u000b\u000byI\u0004\u0003\u0002\b\u00065UBAAE\u0015\r\tY\tL\u0001\u0007yI|w\u000e\u001e \n\u0003IJ1!!%2\u0003\u001d\u0001\u0018mY6bO\u0016LA!!&\u0002\u0018\nA\u0011\n^3sCR|'OC\u0002\u0002\u0012F\u0002R\u0001MANs\u0011K1!!(2\u0005!\u0001&o\u001c3vGR\u0014\u0014aM2iK\u000e\\\u0017I\u001c3SKB|'\u000f\u001e$fi\u000eDg)Y5mkJ,gi\u001c:Va\u0012\fG/\u001a$jY\u0016<%o\\;q\r\u0006LG.\u001e:f)\u0019\t\u0019+!+\u0002.B\u0019\u0001'!*\n\u0007\u0005\u001d\u0016G\u0001\u0003V]&$\bBBAV-\u0001\u0007q+A\tdK2,'m\u001c:o'\",hM\u001a7f\u0013\u0012Dq!a,\u0017\u0001\u0004\t\t,\u0001\u0002dKB!\u00111QAZ\u0013\u0011\t),a&\u0003\u0013QC'o\\<bE2,\u0007f\u0001\f\u0002,\u0005)\u0002.\u00198eY\u00164U\r^2i\u000bb\u001cW\r\u001d;j_:\u001cH#\u0003 \u0002>\u0006\u0005\u0017QYAe\u0011\u0019\tyl\u0006a\u0001/\u0006a\u0011\r\u001d9TQV4g\r\\3JI\"1\u00111Y\fA\u0002]\u000b\u0011b\u001d5vM\u001adW-\u00133\t\r\u0005\u001dw\u00031\u0001X\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\t\u000f\u0005=v\u00031\u0001\u00022\"\u001aq#a\u000b\u0002+9,woU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dKR!\u0011\u0011[Ao!\u0011\t\u0019.!7\u000e\u0005\u0005U'bAAlM\u0005Q1/\u001a:jC2L'0\u001a:\n\t\u0005m\u0017Q\u001b\u0002\u0013'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\rC\u0004\u0002\u0006a\u0001\r!a81\t\u0005\u0005\u0018Q\u001d\t\b?\u00065\u0011(a9E!\rQ\u0014Q\u001d\u0003\f\u0003O\fi.!A\u0001\u0002\u000b\u0005QHA\u0002`IM\nQcQ3mK\n|'O\\*ik\u001a4G.\u001a*fC\u0012,'\u000f\u0005\u0002Q5M\u0011!d\f\u000b\u0003\u0003W\f\u0011c\u001d;sK\u0006l7I]3bi>\u0014\bk\\8m+\t\t)\u0010\u0005\u0003\u0002x\u0006eXBAA'\u0013\u0011\tY0!\u0014\u0003%QC'/Z1e!>|G.\u0012=fGV$xN]\u0001\u0016gR\u0014X-Y7De\u0016\fGo\u001c:Q_>dw\fJ3r)\u0011\t\u0019K!\u0001\t\u0013\t\rQ$!AA\u0002\u0005U\u0018a\u0001=%c\u0005\u00112\u000f\u001e:fC6\u001c%/Z1u_J\u0004vn\u001c7!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU1!1\u0002B\u0011\u0005G)\"A!\u0004+\u0007]\u0013ya\u000b\u0002\u0003\u0012A!!1\u0003B\u000f\u001b\t\u0011)B\u0003\u0003\u0003\u0018\te\u0011!C;oG\",7m[3e\u0015\r\u0011Y\"M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0010\u0005+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015atD1\u0001>\t\u00151uD1\u0001>\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU1!1\u0002B\u0015\u0005W!Q\u0001\u0010\u0011C\u0002u\"QA\u0012\u0011C\u0002uR\u0011a\u000b\u0006\u0004S\t5\"bA\u0012\u00030\u000511\u000f[1eK\u0012TAAa\r\u00032)!\u00111\bB\u001b\u0015\u0011\t9Da\u000e\u000b\u0007\u0019\u0014IDC\u0001,\u0015\rI#Q\b\u0006\u0004G\t}\"\u0002\u0002B\u001a\u0005\u0003RA!a\u000f\u0003D)!\u0011q\u0007B#\u0001")
public class CelebornShuffleReader<K, C>
implements ShuffleReader<K, C>,
Logging {
    private final CelebornShuffleHandle<K, ?, C> handle;
    private final int startPartition;
    private final int endPartition;
    private final int startMapIndex;
    private final int endMapIndex;
    private final TaskContext context;
    private final CelebornConf conf;
    public final ShuffleReadMetricsReporter org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics;
    private final ExecutorShuffleIdTracker shuffleIdTracker;
    private final ShuffleDependency<K, ?, C> dep;
    @VisibleForTesting
    private final ShuffleClient shuffleClient;
    private final AtomicReference<IOException> exceptionRef;
    private final boolean throwsFetchFailure;
    private final int encodedAttemptId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <K, C> int $lessinit$greater$default$5() {
        return CelebornShuffleReader$.MODULE$.$lessinit$greater$default$5();
    }

    public static <K, C> int $lessinit$greater$default$4() {
        return CelebornShuffleReader$.MODULE$.$lessinit$greater$default$4();
    }

    public static void streamCreatorPool_$eq(ThreadPoolExecutor threadPoolExecutor) {
        CelebornShuffleReader$.MODULE$.streamCreatorPool_$eq(threadPoolExecutor);
    }

    public static ThreadPoolExecutor streamCreatorPool() {
        return CelebornShuffleReader$.MODULE$.streamCreatorPool();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ShuffleDependency<K, ?, C> dep() {
        return this.dep;
    }

    public ShuffleClient shuffleClient() {
        return this.shuffleClient;
    }

    private AtomicReference<IOException> exceptionRef() {
        return this.exceptionRef;
    }

    private boolean throwsFetchFailure() {
        return this.throwsFetchFailure;
    }

    private int encodedAttemptId() {
        return this.encodedAttemptId;
    }

    public Iterator<Product2<K, C>> read() {
        InterruptibleIterator resultIter;
        InterruptibleIterator interruptibleIterator;
        SerializerInstance serializerInstance = this.newSerializerInstance(this.dep());
        int shuffleId = SparkUtils.celebornShuffleId(this.shuffleClient(), this.handle, this.context, Predef$.MODULE$.boolean2Boolean(false));
        this.shuffleIdTracker.track(this.handle.shuffleId(), shuffleId);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("get shuffleId ").append(shuffleId).append(" for appShuffleId ").append($this.handle.shuffleId()).append(" attemptNum ").append($this.context.stageAttemptNumber()).toString());
        MetricsCallback metricsCallback = new MetricsCallback(this){
            private final /* synthetic */ CelebornShuffleReader $outer;

            public void incBytesRead(long bytesWritten) {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRemoteBytesRead(bytesWritten);
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRemoteBlocksFetched(1L);
            }

            public void incReadTime(long time) {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incFetchWaitTime(time);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        if (CelebornShuffleReader$.MODULE$.streamCreatorPool() == null) {
            CelebornShuffleReader$ celebornShuffleReader$ = CelebornShuffleReader$.MODULE$;
            synchronized (celebornShuffleReader$) {
                if (CelebornShuffleReader$.MODULE$.streamCreatorPool() == null) {
                    CelebornShuffleReader$.MODULE$.streamCreatorPool_$eq(ThreadUtils$.MODULE$.newDaemonCachedThreadPool("celeborn-create-stream-thread", this.conf.readStreamCreatorPoolThreads(), 60));
                }
            }
        }
        long startTime = System.currentTimeMillis();
        long fetchTimeoutMs = this.conf.clientFetchTimeoutMs();
        boolean localFetchEnabled = this.conf.enableReadLocalShuffleFile();
        String localHostAddress = Utils$.MODULE$.localHostName(this.conf);
        String shuffleKey = Utils$.MODULE$.makeShuffleKey(this.handle.appUniqueId(), shuffleId);
        ObjectRef fileGroups = ObjectRef.create(null);
        try {
            fileGroups.elem = this.shuffleClient().updateFileGroup(shuffleId, this.startPartition);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof CelebornIOException ? true : throwable2 instanceof PartitionUnRetryAbleException) {
                this.checkAndReportFetchFailureForUpdateFileGroupFailure(shuffleId, throwable2);
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw throwable3;
            }
            throw throwable;
        }
        HashMap workerRequestMap = new HashMap();
        IntRef partCnt = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startPartition), this.endPartition).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            if (((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.containsKey(BoxesRunTime.boxToInteger((int)partitionId))) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.get(BoxesRunTime.boxToInteger((int)partitionId))).asScala()).foreach((Function1 & Serializable & scala.Serializable)location -> {
                    Tuple3 tuple3;
                    BoxedUnit boxedUnit;
                    ++partCnt$1.elem;
                    String hostPort = location.hostAndFetchPort();
                    if (!workerRequestMap.containsKey(hostPort)) {
                        try {
                            TransportClient client = this.shuffleClient().getDataClientFactory().createClient(location.getHost(), location.getFetchPort());
                            PbOpenStreamList.Builder pbOpenStreamList = PbOpenStreamList.newBuilder();
                            pbOpenStreamList.setShuffleKey(shuffleKey);
                            boxedUnit = workerRequestMap.put(hostPort, new Tuple3((Object)client, new ArrayList(), (Object)pbOpenStreamList));
                        }
                        catch (Exception ex) {
                            this.shuffleClient().excludeFailedFetchLocation(location.hostAndFetchPort(), ex);
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to create client for ").append(shuffleKey).append("-").append(partitionId).append(" from host: ").append(location.hostAndFetchPort()).append(". ").append("Shuffle reader will try its replica if exists.").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    if ((tuple3 = (Tuple3)workerRequestMap.get(hostPort)) != null) {
                        ArrayList locArr = (ArrayList)tuple3._2();
                        PbOpenStreamList.Builder pbOpenStreamListBuilder = (PbOpenStreamList.Builder)tuple3._3();
                        locArr.add(location);
                        pbOpenStreamListBuilder.addFileName(location.getFileName()).addStartIndex($this.startMapIndex).addEndIndex($this.endMapIndex);
                        return pbOpenStreamListBuilder.addReadLocalShuffle(localFetchEnabled && location.getHost().equals(localHostAddress));
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Empty client for host ").append(hostPort).toString());
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
        ConcurrentHashMap locationStreamHandlerMap = JavaUtils.newConcurrentHashMap();
        List futures = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(workerRequestMap.values()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable(null, (Tuple3)entry, fetchTimeoutMs, locationStreamHandlerMap){
            private final Tuple3 entry$1;
            private final long fetchTimeoutMs$1;
            private final ConcurrentHashMap locationStreamHandlerMap$1;

            public void run() {
                PbOpenStreamListResponse pbOpenStreamListResponse;
                PbOpenStreamListResponse pbOpenStreamListResponse2;
                Tuple3 tuple3 = this.entry$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                TransportClient client = (TransportClient)tuple3._1();
                ArrayList locArr = (ArrayList)tuple3._2();
                PbOpenStreamList.Builder pbOpenStreamListBuilder = (PbOpenStreamList.Builder)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)client, (Object)locArr, (Object)pbOpenStreamListBuilder);
                TransportClient client2 = (TransportClient)tuple32._1();
                ArrayList locArr2 = (ArrayList)tuple32._2();
                PbOpenStreamList.Builder pbOpenStreamListBuilder2 = (PbOpenStreamList.Builder)tuple32._3();
                TransportMessage msg = new TransportMessage(MessageType.BATCH_OPEN_STREAM, pbOpenStreamListBuilder2.build().toByteArray());
                try {
                    ByteBuffer response = client2.sendRpcSync(msg.toByteBuffer(), this.fetchTimeoutMs$1);
                    pbOpenStreamListResponse2 = (PbOpenStreamListResponse)TransportMessage.fromByteBuffer(response).getParsedPayload();
                }
                catch (Exception exception) {
                    pbOpenStreamListResponse2 = pbOpenStreamListResponse = null;
                }
                if (pbOpenStreamListResponse != null) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), locArr2.size()).foreach((Function1 & Serializable & scala.Serializable)idx -> $anon$2.$anonfun$run$1(this, pbOpenStreamListResponse, locArr2, BoxesRunTime.unboxToInt((Object)idx)));
                    return;
                }
            }

            public static final /* synthetic */ Object $anonfun$run$1($anon$2 $this, PbOpenStreamListResponse pbOpenStreamListResponse$1, ArrayList locArr$1, int idx) {
                PbStreamHandlerOpt streamHandlerOpt = pbOpenStreamListResponse$1.getStreamHandlerOptList().get(idx);
                if (streamHandlerOpt.getStatus() == StatusCode.SUCCESS.getValue()) {
                    return $this.locationStreamHandlerMap$1.put(locArr$1.get(idx), streamHandlerOpt.getStreamHandler());
                }
                return BoxedUnit.UNIT;
            }
            {
                this.entry$1 = entry$1;
                this.fetchTimeoutMs$1 = fetchTimeoutMs$1;
                this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.spark.shuffle.celeborn.CelebornShuffleReader$$anon$2 org.apache.celeborn.common.protocol.PbOpenStreamListResponse java.util.ArrayList java.lang.Object )}, serializedLambda);
            }
        }), Iterable$.MODULE$.canBuildFrom())).toList();
        futures.foreach((Function1 & Serializable & scala.Serializable)f -> f.get());
        long end = System.currentTimeMillis();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("BatchOpenStream for ").append(partCnt$1.elem).append(" cost ").append(end - startTime).append("ms").toString());
        ConcurrentHashMap streams = new ConcurrentHashMap();
        int inputStreamCreationWindow = this.conf.clientInputStreamCreationWindow();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startPartition), Math.min(this.startPartition + inputStreamCreationWindow, this.endPartition)).foreach((Function1 & Serializable & scala.Serializable)partitionId -> CelebornShuffleReader.$anonfun$read$12(this, fileGroups, locationStreamHandlerMap, shuffleId, metricsCallback, streams, BoxesRunTime.unboxToInt((Object)partitionId)));
        Iterator recordIter = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startPartition), this.endPartition).iterator().map((Function1 & Serializable & scala.Serializable)partitionId -> CelebornShuffleReader.$anonfun$read$13(this, streams, shuffleId, metricsCallback, inputStreamCreationWindow, fileGroups, locationStreamHandlerMap, BoxesRunTime.unboxToInt((Object)partitionId))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CelebornShuffleReader.$anonfun$read$16(x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int partitionId = tuple2._1$mcI$sp();
                CelebornInputStream inputStream = (CelebornInputStream)tuple2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)serializerInstance.deserializeStream((InputStream)inputStream).asKeyValueIterator());
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Iterator iterator;
                int partitionId = tuple2._1$mcI$sp();
                Iterator iter = (Iterator)tuple2._2();
                try {
                    iterator = iter;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof CelebornIOException ? true : throwable2 instanceof PartitionUnRetryAbleException) {
                        throw this.handleFetchExceptions($this.handle.shuffleId(), shuffleId, partitionId, throwable2);
                    }
                    throw throwable;
                }
                return iterator;
            }
            throw new MatchError((Object)tuple2);
        });
        Iterator iterWithUpdatedRecordsRead = recordIter.map((Function1 & Serializable & scala.Serializable)record -> {
            $this.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics.incRecordsRead(1L);
            return record;
        });
        CompletionIterator metricIter = CompletionIterator$.MODULE$.apply(iterWithUpdatedRecordsRead, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.context.taskMetrics().mergeShuffleReadMetrics());
        InterruptibleIterator interruptibleIter = new InterruptibleIterator(this.context, (Iterator)metricIter);
        if (this.dep().keyOrdering().isDefined()) {
            ExternalSorter externalSorter;
            if (this.dep().aggregator().isDefined()) {
                if (this.dep().mapSideCombine()) {
                    TaskContext x$1 = this.context;
                    Option x$2 = Option$.MODULE$.apply((Object)new Aggregator((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x), ((Aggregator)this.dep().aggregator().get()).mergeCombiners(), ((Aggregator)this.dep().aggregator().get()).mergeCombiners()));
                    Some x$32 = new Some(this.dep().keyOrdering().get());
                    Serializer x$4 = this.dep().serializer();
                    Option x$5 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                    externalSorter = new ExternalSorter(x$1, x$2, x$5, (Option)x$32, x$4);
                } else {
                    TaskContext x$6 = this.context;
                    Option x$7 = this.dep().aggregator();
                    Some x$8 = new Some(this.dep().keyOrdering().get());
                    Serializer x$9 = this.dep().serializer();
                    Option x$10 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                    externalSorter = new ExternalSorter(x$6, x$7, x$10, (Option)x$8, x$9);
                }
            } else {
                TaskContext x$11 = this.context;
                Some x$12 = new Some(this.dep().keyOrdering().get());
                Serializer x$13 = this.dep().serializer();
                None$ x$14 = ExternalSorter$.MODULE$.$lessinit$greater$default$2();
                Option x$15 = ExternalSorter$.MODULE$.$lessinit$greater$default$3();
                externalSorter = new ExternalSorter(x$11, (Option)x$14, x$15, (Option)x$12, x$13);
            }
            ExternalSorter sorter = externalSorter;
            sorter.insertAll((Iterator)interruptibleIter);
            this.context.taskMetrics().incMemoryBytesSpilled(sorter.memoryBytesSpilled());
            this.context.taskMetrics().incDiskBytesSpilled(sorter.diskBytesSpilled());
            this.context.taskMetrics().incPeakExecutionMemory(sorter.peakMemoryUsedBytes());
            this.context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                sorter.stop();
                return BoxedUnit.UNIT;
            });
            interruptibleIterator = CompletionIterator$.MODULE$.apply(sorter.iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sorter.stop());
        } else if (this.dep().aggregator().isDefined()) {
            if (this.dep().mapSideCombine()) {
                InterruptibleIterator combinedKeyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineCombinersByKey((Iterator)combinedKeyValuesIterator, this.context);
            } else {
                InterruptibleIterator keyValuesIterator = interruptibleIter;
                interruptibleIterator = ((Aggregator)this.dep().aggregator().get()).combineValuesByKey((Iterator)keyValuesIterator, this.context);
            }
        } else {
            interruptibleIterator = interruptibleIter;
        }
        InterruptibleIterator interruptibleIterator2 = resultIter = interruptibleIterator;
        if (interruptibleIterator2 instanceof InterruptibleIterator) {
            return resultIter;
        }
        return new InterruptibleIterator(this.context, (Iterator)resultIter);
    }

    @VisibleForTesting
    public void checkAndReportFetchFailureForUpdateFileGroupFailure(int celebornShuffleId, Throwable ce) {
        if (ce.getCause() != null && (ce.getCause() instanceof InterruptedException || ce.getCause() instanceof TimeoutException)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("fetch shuffle ").append(celebornShuffleId).append(" timeout or interrupt").toString(), ce);
            throw ce;
        }
        throw this.handleFetchExceptions(this.handle.shuffleId(), celebornShuffleId, 0, ce);
    }

    @VisibleForTesting
    public Nothing$ handleFetchExceptions(int appShuffleId, int shuffleId, int partitionId, Throwable ce) {
        if (this.throwsFetchFailure() && this.shuffleClient().reportShuffleFetchFailure(appShuffleId, shuffleId)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Handle fetch exceptions for ").append(shuffleId).append("-").append(partitionId).toString(), ce);
            throw new FetchFailedException(null, appShuffleId, -1L, -1, partitionId, new StringBuilder(47).append("Celeborn FetchFailure appShuffleId/shuffleId: ").append(appShuffleId).append("/").append(shuffleId).toString(), ce);
        }
        throw ce;
    }

    public SerializerInstance newSerializerInstance(ShuffleDependency<K, ?, C> dep) {
        return dep.serializer().newInstance();
    }

    public final void org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(int partitionId, ObjectRef fileGroups$1, ConcurrentHashMap locationStreamHandlerMap$1, int shuffleId$1, MetricsCallback metricsCallback$1, ConcurrentHashMap streams$1) {
        ArrayList<PbStreamHandler> streamHandlers;
        ArrayList<PbStreamHandler> arrayList;
        ArrayList<PartitionLocation> locations;
        ArrayList<PartitionLocation> arrayList2 = locations = ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.containsKey(BoxesRunTime.boxToInteger((int)partitionId)) ? new ArrayList<PartitionLocation>((Collection)((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).partitionGroups.get(BoxesRunTime.boxToInteger((int)partitionId))) : new ArrayList();
        if (locations != null) {
            ArrayList<PbStreamHandler> streamHandlerArr = new ArrayList<PbStreamHandler>(locations.size());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(locations).asScala()).foreach((Function1 & Serializable & scala.Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)streamHandlerArr.add(locationStreamHandlerMap$1.get(loc))));
            arrayList = streamHandlerArr;
        } else {
            arrayList = streamHandlers = null;
        }
        if (this.exceptionRef().get() == null) {
            try {
                CelebornInputStream inputStream = this.shuffleClient().readPartition(shuffleId$1, this.handle.shuffleId(), partitionId, this.encodedAttemptId(), this.startMapIndex, this.endMapIndex, this.throwsFetchFailure() ? ExceptionMakerHelper$.MODULE$.SHUFFLE_FETCH_FAILURE_EXCEPTION_MAKER() : null, locations, streamHandlers, ((ShuffleClientImpl.ReduceFileGroups)fileGroups$1.elem).mapAttempts, metricsCallback$1);
                streams$1.put(Predef$.MODULE$.int2Integer(partitionId), inputStream);
            }
            catch (IOException e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Exception caught when readPartition ").append(partitionId).append("!").toString(), e);
                this.exceptionRef().compareAndSet(null, e);
            }
            catch (Throwable e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Non IOException caught when readPartition ").append(partitionId).append("!").toString(), e);
                this.exceptionRef().compareAndSet(null, new CelebornIOException(e));
            }
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$read$12(CelebornShuffleReader $this, ObjectRef fileGroups$1, ConcurrentHashMap locationStreamHandlerMap$1, int shuffleId$1, MetricsCallback metricsCallback$1, ConcurrentHashMap streams$1, int partitionId) {
        return CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable($this, partitionId, fileGroups$1, locationStreamHandlerMap$1, shuffleId$1, metricsCallback$1, streams$1){
            private final /* synthetic */ CelebornShuffleReader $outer;
            private final int partitionId$3;
            private final ObjectRef fileGroups$1;
            private final ConcurrentHashMap locationStreamHandlerMap$1;
            private final int shuffleId$1;
            private final MetricsCallback metricsCallback$1;
            private final ConcurrentHashMap streams$1;

            public void run() {
                this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(this.partitionId$3, this.fileGroups$1, this.locationStreamHandlerMap$1, this.shuffleId$1, this.metricsCallback$1, this.streams$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionId$3 = partitionId$3;
                this.fileGroups$1 = fileGroups$1;
                this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
                this.shuffleId$1 = shuffleId$1;
                this.metricsCallback$1 = metricsCallback$1;
                this.streams$1 = streams$1;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$read$15(ObjectRef inputStream$1, TaskContext x$2) {
        ((CelebornInputStream)inputStream$1.elem).close();
    }

    public static final /* synthetic */ Tuple2 $anonfun$read$13(CelebornShuffleReader $this, ConcurrentHashMap streams$1, int shuffleId$1, MetricsCallback metricsCallback$1, int inputStreamCreationWindow$1, ObjectRef fileGroups$1, ConcurrentHashMap locationStreamHandlerMap$1, int partitionId) {
        if ($this.handle.numMappers() > 0) {
            long startFetchWait = System.nanoTime();
            ObjectRef inputStream = ObjectRef.create((Object)((CelebornInputStream)streams$1.get(BoxesRunTime.boxToInteger((int)partitionId))));
            while ((CelebornInputStream)inputStream.elem == null) {
                if ($this.exceptionRef().get() != null) {
                    IOException iOException = $this.exceptionRef().get();
                    if (iOException instanceof CelebornIOException ? true : iOException instanceof PartitionUnRetryAbleException) {
                        throw $this.handleFetchExceptions($this.handle.shuffleId(), shuffleId$1, partitionId, iOException);
                    }
                    throw iOException;
                }
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "inputStream is null, sleeping...");
                Thread.sleep(50L);
                inputStream.elem = (CelebornInputStream)streams$1.get(BoxesRunTime.boxToInteger((int)partitionId));
            }
            metricsCallback$1.incReadTime(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startFetchWait));
            $this.context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
                CelebornShuffleReader.$anonfun$read$15(inputStream, x$2);
                return BoxedUnit.UNIT;
            });
            Object object = partitionId + inputStreamCreationWindow$1 < $this.endPartition ? CelebornShuffleReader$.MODULE$.streamCreatorPool().submit(new Runnable($this, partitionId, inputStreamCreationWindow$1, fileGroups$1, locationStreamHandlerMap$1, shuffleId$1, metricsCallback$1, streams$1){
                private final /* synthetic */ CelebornShuffleReader $outer;
                private final int partitionId$4;
                private final int inputStreamCreationWindow$1;
                private final ObjectRef fileGroups$1;
                private final ConcurrentHashMap locationStreamHandlerMap$1;
                private final int shuffleId$1;
                private final MetricsCallback metricsCallback$1;
                private final ConcurrentHashMap streams$1;

                public void run() {
                    this.$outer.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$createInputStream$1(this.partitionId$4 + this.inputStreamCreationWindow$1, this.fileGroups$1, this.locationStreamHandlerMap$1, this.shuffleId$1, this.metricsCallback$1, this.streams$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partitionId$4 = partitionId$4;
                    this.inputStreamCreationWindow$1 = inputStreamCreationWindow$1;
                    this.fileGroups$1 = fileGroups$1;
                    this.locationStreamHandlerMap$1 = locationStreamHandlerMap$1;
                    this.shuffleId$1 = shuffleId$1;
                    this.metricsCallback$1 = metricsCallback$1;
                    this.streams$1 = streams$1;
                }
            }) : BoxedUnit.UNIT;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)((CelebornInputStream)inputStream.elem));
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)CelebornInputStream.empty());
    }

    public static final /* synthetic */ boolean $anonfun$read$16(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            CelebornInputStream inputStream;
            CelebornInputStream celebornInputStream = inputStream = (CelebornInputStream)tuple2._2();
            CelebornInputStream celebornInputStream2 = CelebornInputStream.empty();
            return celebornInputStream == null ? celebornInputStream2 != null : !celebornInputStream.equals(celebornInputStream2);
        }
        throw new MatchError((Object)tuple2);
    }

    public CelebornShuffleReader(CelebornShuffleHandle<K, ?, C> handle, int startPartition, int endPartition, int startMapIndex, int endMapIndex, TaskContext context, CelebornConf conf, ShuffleReadMetricsReporter metrics, ExecutorShuffleIdTracker shuffleIdTracker) {
        this.handle = handle;
        this.startPartition = startPartition;
        this.endPartition = endPartition;
        this.startMapIndex = startMapIndex;
        this.endMapIndex = endMapIndex;
        this.context = context;
        this.conf = conf;
        this.org$apache$spark$shuffle$celeborn$CelebornShuffleReader$$metrics = metrics;
        this.shuffleIdTracker = shuffleIdTracker;
        Logging.$init$((Logging)this);
        this.dep = handle.dependency();
        this.shuffleClient = ShuffleClient.get(handle.appUniqueId(), handle.lifecycleManagerHost(), handle.lifecycleManagerPort(), conf, handle.userIdentifier(), handle.extension());
        this.exceptionRef = new AtomicReference();
        this.throwsFetchFailure = handle.throwsFetchFailure();
        this.encodedAttemptId = SparkCommonUtils.getEncodedAttemptNumber(context);
    }
}

