/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ibatis.ognl.ASTKeyValue;
import org.apache.ibatis.ognl.Node;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.SimpleNode;
import org.apache.ibatis.ognl.enhance.UnsupportedCompilationException;

public class ASTMap
extends SimpleNode {
    private static final long serialVersionUID = -849999202189860682L;
    private String className;

    public ASTMap(int id) {
        super(id);
    }

    public ASTMap(OgnlParser p, int id) {
        super(p, id);
    }

    protected void setClassName(String value) {
        this.className = value;
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        Map<Object, Object> answer;
        if (this.className == null) {
            answer = new LinkedHashMap();
        } else {
            try {
                answer = (Map)OgnlRuntime.classForName(context, this.className).newInstance();
            }
            catch (Exception ex) {
                throw new OgnlException("Map implementor '" + this.className + "' not found", ex);
            }
        }
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ASTKeyValue kv = (ASTKeyValue)this.children[i];
            Node k = kv.getKey();
            Node v = kv.getValue();
            answer.put(k.getValue(context, source), v == null ? null : v.getValue(context, source));
        }
        return answer;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("#");
        if (this.className != null) {
            result.append("@").append(this.className).append("@");
        }
        result.append("{ ");
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ASTKeyValue kv = (ASTKeyValue)this.children[i];
            if (i > 0) {
                result.append(", ");
            }
            result.append(kv.getKey()).append(" : ").append(kv.getValue());
        }
        return result + " }";
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        throw new UnsupportedCompilationException("Map expressions not supported as native java yet.");
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        throw new UnsupportedCompilationException("Map expressions not supported as native java yet.");
    }
}

