/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

public class FloatConverterTestCase
extends NumberConverterTestBase {
    private Converter converter;

    public static TestSuite suite() {
        return new TestSuite(FloatConverterTestCase.class);
    }

    public FloatConverterTestCase(String name) {
        super(name);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Float.class;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new FloatConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new FloatConverter(defaultValue);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Float.valueOf("-12");
        this.numbers[1] = Float.valueOf("13");
        this.numbers[2] = Float.valueOf("-22");
        this.numbers[3] = Float.valueOf("23");
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    public void testInvalidAmount() {
        NumberConverter converter = this.makeConverter();
        Class<Float> clazz = Float.class;
        Double max = 3.4028234663852886E38;
        Double tooBig = Double.MAX_VALUE;
        FloatConverterTestCase.assertEquals((String)"Maximum", (Object)Float.valueOf(Float.MAX_VALUE), (Object)converter.convert(clazz, (Object)max));
        try {
            FloatConverterTestCase.assertEquals((String)"Too Big", null, (Object)converter.convert(clazz, (Object)tooBig));
            FloatConverterTestCase.fail((String)"More than maximum, expected ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Float.MIN_VALUE), "-17.2", "-1.1", "0.0", "1.1", "17.2", String.valueOf(Float.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Float[] expected = new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(-17.2f), Float.valueOf(-1.1f), Float.valueOf(0.0f), Float.valueOf(1.1f), Float.valueOf(17.2f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(10.0f), Float.valueOf(11.1f), Float.valueOf(12.2f)};
        for (int i = 0; i < expected.length; ++i) {
            FloatConverterTestCase.assertEquals((String)(message[i] + " to Float"), (double)expected[i].floatValue(), (double)((Float)this.converter.convert(Float.class, input[i])).floatValue(), (double)1.0E-5);
            FloatConverterTestCase.assertEquals((String)(message[i] + " to float"), (double)expected[i].floatValue(), (double)((Float)this.converter.convert(Float.TYPE, input[i])).floatValue(), (double)1.0E-5);
            FloatConverterTestCase.assertEquals((String)(message[i] + " to null type"), (double)expected[i].floatValue(), (double)((Float)this.converter.convert(null, input[i])).floatValue(), (double)1.0E-5);
        }
    }
}

