/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.http.api.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Context;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.rest.v1.model.ConfResponse;
import org.apache.celeborn.rest.v1.model.ConfigData;
import org.apache.celeborn.rest.v1.model.DeleteDynamicConfigRequest;
import org.apache.celeborn.rest.v1.model.DynamicConfig;
import org.apache.celeborn.rest.v1.model.DynamicConfigResponse;
import org.apache.celeborn.rest.v1.model.HandleResponse;
import org.apache.celeborn.rest.v1.model.UpsertDynamicConfigRequest;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.http.api.ApiRequestContext;
import org.apache.celeborn.server.common.service.config.ConfigLevel;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.commons.lang3.StringUtils;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.MapLike;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Tag(name="Conf")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005uh!\u0002\u0006\f\u00015Y\u0002\"\u0002\u0014\u0001\t\u0003A\u0003\"B\u0016\u0001\t\u0013a\u0003\"B\u001b\u0001\t\u00031\u0004\"\u0002>\u0001\t\u0003Y\bbBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!!2\u0001\t\u0013\t9\rC\u0004\u0002R\u0002!I!a5\u0003\u0019\r{gN\u001a*fg>,(oY3\u000b\u00051i\u0011A\u0001<2\u0015\tqq\"A\u0002ba&T!\u0001E\t\u0002\t!$H\u000f\u001d\u0006\u0003%M\taaY8n[>t'B\u0001\u000b\u0016\u0003\u0019\u0019XM\u001d<fe*\u0011acF\u0001\tG\u0016dWMY8s]*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h'\r\u0001AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r\"S\"A\u0007\n\u0005\u0015j!!E!qSJ+\u0017/^3ti\u000e{g\u000e^3yi\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001*!\tQ\u0003!D\u0001\f\u00035\u0019wN\u001c4jON+'O^5dKV\tQ\u0006\u0005\u0002/g5\tqF\u0003\u00021c\u000511m\u001c8gS\u001eT!AM\t\u0002\u000fM,'O^5dK&\u0011Ag\f\u0002\u000e\u0007>tg-[4TKJ4\u0018nY3\u0002\t\r|gNZ\u000b\u0002oA\u0011\u0001HP\u0007\u0002s)\u0011!hO\u0001\u0006[>$W\r\u001c\u0006\u0003\u0019qR!!P\u000b\u0002\tI,7\u000f^\u0005\u0003\u007fe\u0012AbQ8oMJ+7\u000f]8og\u0016D#aA!\u0011\u0005\tKU\"A\"\u000b\u0005\u0011+\u0015A\u0001:t\u0015\t1u)\u0001\u0002xg*\t\u0001*A\u0003kCZ\f\u00070\u0003\u0002K\u0007\n\u0019q)\u0012+)\r\raE,X0a!\ti%,D\u0001O\u0015\ty\u0005+A\u0005sKN\u0004xN\\:fg*\u0011\u0011KU\u0001\fC:tw\u000e^1uS>t7O\u0003\u0002T)\u0006\u0019q.Y:\u000b\u0005U3\u0016A\u0001<4\u0015\t9\u0006,A\u0004to\u0006<w-\u001a:\u000b\u0003e\u000b!![8\n\u0005ms%aC!qSJ+7\u000f]8og\u0016\fAB]3ta>t7/Z\"pI\u0016\f\u0013AX\u0001\u0004eA\u0002\u0014aB2p]R,g\u000e\u001e\u0017\u0002C.*!\r[5lYB\u00111MZ\u0007\u0002I*\u0011Q\rU\u0001\u0006[\u0016$\u0017.Y\u0005\u0003O\u0012\u0014qaQ8oi\u0016tG/A\u0005nK\u0012L\u0017\rV=qK\u0006\n!.\u0001\tbaBd\u0017nY1uS>twF[:p]\u000611o\u00195f[\u0006\\3!\u001c9r!\t\u0019g.\u0003\u0002pI\n11k\u00195f[\u0006\fa\"[7qY\u0016lWM\u001c;bi&|gnI\u00018Q\u0011\u00191o\u001e=\u0011\u0005Q,X\"\u0001)\n\u0005Y\u0004&!C(qKJ\fG/[8o\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003e\fQ\u0003T5ti\u0002\"\b.\u001a\u0011d_:4\u0007e]3ui&tw-A\u0006es:\fW.[2D_:4GC\u0002?\u0000\u0003K\ti\u0003\u0005\u00029{&\u0011a0\u000f\u0002\u0016\tft\u0017-\\5d\u0007>tg-[4SKN\u0004xN\\:f\u0011\u001d\t\t\u0001\u0002a\u0001\u0003\u0007\tQ\u0001\\3wK2\u0004B!!\u0002\u0002\u00149!\u0011qAA\b!\r\tIAH\u0007\u0003\u0003\u0017Q1!!\u0004(\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0003\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\rM#(/\u001b8h\u0015\r\t\tB\b\u0015\b\u007f\u0006m\u0011\u0011EA\u0012!\r\u0011\u0015QD\u0005\u0004\u0003?\u0019%AC)vKJL\b+\u0019:b[\u0006)a/\u00197vK\u0006\u0012\u0011\u0011\u0001\u0005\b\u0003O!\u0001\u0019AA\u0002\u0003\u0019!XM\\1oi\"B\u0011QEA\u000e\u0003C\tY#\t\u0002\u0002(!9\u0011q\u0006\u0003A\u0002\u0005\r\u0011\u0001\u00028b[\u0016D\u0003\"!\f\u0002\u001c\u0005\u0005\u00121G\u0011\u0003\u0003_As\u0001BA\u001c\u0003C\ti\u0004E\u0002C\u0003sI1!a\u000fD\u0005\u0011\u0001\u0016\r\u001e5\"\u0005\u0005}\u0012\u0001C\u0018es:\fW.[2)\u0005\u0011\t\u0005f\u0002\u0003M9v{\u0016Q\t\u0017\u0003\u0003\u000fZcA\u00195jW\u0006%3\u0006B7q\u0003\u0017\u001a\u0013\u0001 \u0015\u0006\tM<\u0018qJ\u0011\u0003\u0003#\n!Q\u0014'jgR\u0004C\u000f[3!Ift\u0017-\\5dA\r|gNZ5hg:\u0002C\u000b[3!a\u0006\u0014\u0018-\\3uKJ\u0004C.\u001a<fY\u0002\u001a\b/Z2jM&,7\u000f\t;iK\u0002\u001awN\u001c4jO\u0002bWM^3mA=4\u0007\u0005Z=oC6L7\rI2p]\u001aLwm\u001d\u0018!)\",\u0007\u0005]1sC6,G/\u001a:!i\u0016t\u0017M\u001c;!gB,7-\u001b4jKN\u0004C\u000f[3!i\u0016t\u0017M\u001c;!S\u0012\u0004sN\u001a\u0011U\u000b:\u000be\n\u0016\u0011pe\u0002\"VIT!O)~+6+\u0012*!Y\u00164X\r\u001c\u0018!)\",\u0007\u0005]1sC6,G/\u001a:!]\u0006lW\rI:qK\u000eLg-[3tAQDW\rI;tKJ\u0004c.Y7fA=4\u0007\u0005V#O\u0003:#v,V*F%\u0002bWM^3m]\u0001jU-\u00198xQ&dW\r\f\u0011fSRDWM\u001d\u0011o_:,\u0007e\u001c:!C2d\u0007e\u001c4!i\",\u0007\u0005]1sC6,G/\u001a:!i\u0016t\u0017M\u001c;!C:$\u0007E\\1nK\u0002\n'/\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u00022wN\u001d\u0011U\u000b:\u000be\nV0V'\u0016\u0013\u0006\u0005\\3wK2t\u0013!E;qg\u0016\u0014H\u000fR=oC6L7mQ8oMR!\u0011qKA/!\rA\u0014\u0011L\u0005\u0004\u00037J$A\u0004%b]\u0012dWMU3ta>t7/\u001a\u0005\b\u0003?*\u0001\u0019AA1\u0003\u001d\u0011X-];fgR\u00042\u0001OA2\u0013\r\t)'\u000f\u0002\u001b+B\u001cXM\u001d;Es:\fW.[2D_:4\u0017n\u001a*fcV,7\u000f\u001e\u0015\b\u000b\u0005]\u0012\u0011EA5C\t\tY'A\b0Ift\u0017-\\5d_U\u00048/\u001a:uQ\r)\u0011q\u000e\t\u0004\u0005\u0006E\u0014bAA:\u0007\n!\u0001kT*UQ\u001d)A\nX/`\u0003ob#!!\u001f,\r\tD\u0017n[A>W\u0011i\u0007/! $\u0005\u0005]\u0003&B\u0003to\u0006\u0005\u0015EAAB\u0003\t\u0005V\u000b]:feR\u0004C\u000f[3!Ift\u0017-\\5dA\r|gNZ5hg:\u0002C\u000b[3!a\u0006\u0014\u0018-\\3uKJ\u0004C.\u001a<fY\u0002\u001a\b/Z2jM&,7\u000f\t;iK\u0002\u001awN\u001c4jO\u0002bWM^3mA=4\u0007\u0005Z=oC6L7\rI2p]\u001aLwm\u001d\u0018!)\",\u0007\u0005]1sC6,G/\u001a:!i\u0016t\u0017M\u001c;!gB,7-\u001b4jKN\u0004C\u000f[3!i\u0016t\u0017M\u001c;!S\u0012\u0004sN\u001a\u0011U\u000b:\u000be\n\u0016\u0011pe\u0002\"VIT!O)~+6+\u0012*!Y\u00164X\r\u001c\u0018!)\",\u0007\u0005]1sC6,G/\u001a:!]\u0006lW\rI:qK\u000eLg-[3tAQDW\rI;tKJ\u0004c.Y7fA=4\u0007\u0005V#O\u0003:#v,V*F%\u0002bWM^3m]\u0001jU-\u00198xQ&dW\r\f\u0011fSRDWM\u001d\u0011o_:,\u0007e\u001c:!C2d\u0007e\u001c4!i\",\u0007\u0005]1sC6,G/\u001a:!i\u0016t\u0017M\u001c;!C:$\u0007E\\1nK\u0002\n'/\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u00022wN\u001d\u0011U\u000b:\u000be\nV0V'\u0016\u0013\u0006\u0005\\3wK2t\u0013!\u00053fY\u0016$X\rR=oC6L7mQ8oMR!\u0011qKAE\u0011\u001d\tyF\u0002a\u0001\u0003\u0017\u00032\u0001OAG\u0013\r\ty)\u000f\u0002\u001b\t\u0016dW\r^3Es:\fW.[2D_:4\u0017n\u001a*fcV,7\u000f\u001e\u0015\b\r\u0005]\u0012\u0011EAJC\t\t)*A\b0Ift\u0017-\\5d_\u0011,G.\u001a;fQ\r1\u0011q\u000e\u0015\b\r1cVlXANY\t\tI\bK\u0003\u0007g^\fy*\t\u0002\u0002\"\u0006\u0011\t\u000bR3mKR,\u0007\u0005\u001e5fA\u0011Lh.Y7jG\u0002\u001awN\u001c4jONt\u0003\u0005\u00165fAA\f'/Y7fi\u0016\u0014\b\u0005\\3wK2\u00043\u000f]3dS\u001aLWm\u001d\u0011uQ\u0016\u00043m\u001c8gS\u001e\u0004C.\u001a<fY\u0002zg\r\t3z]\u0006l\u0017n\u0019\u0011d_:4\u0017nZ:/AQCW\r\t9be\u0006lW\r^3sAQ,g.\u00198uAM\u0004XmY5gS\u0016\u001c\b\u0005\u001e5fAQ,g.\u00198uA%$\u0007e\u001c4!)\u0016s\u0015I\u0014+!_J\u0004C+\u0012(B\u001dR{VkU#SA1,g/\u001a7/AQCW\r\t9be\u0006lW\r^3sA9\fW.\u001a\u0011ta\u0016\u001c\u0017NZ5fg\u0002\"\b.\u001a\u0011vg\u0016\u0014\bE\\1nK\u0002zg\r\t+F\u001d\u0006sEkX+T\u000bJ\u0003C.\u001a<fY:\u0002S*Z1oo\"LG.\u001a\u0017!K&$\b.\u001a:!]>tW\rI8sA\u0005dG\u000eI8gAQDW\r\t9be\u0006lW\r^3sAQ,g.\u00198uA\u0005tG\r\t8b[\u0016\u0004\u0013M]3!gB,7-\u001b4jK\u0012\u0004cm\u001c:!)\u0016s\u0015I\u0014+`+N+%\u000b\t7fm\u0016dg&\u0001\thKR$\u0015P\\1nS\u000e\u001cuN\u001c4jORA\u0011qUA`\u0003\u0003\f\u0019\r\u0005\u0004\u0002*\u0006M\u0016\u0011\u0018\b\u0005\u0003W\u000byK\u0004\u0003\u0002\n\u00055\u0016\"A\u0010\n\u0007\u0005Ef$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0016q\u0017\u0002\u0004'\u0016\f(bAAY=A\u0019\u0001(a/\n\u0007\u0005u\u0016HA\u0007Es:\fW.[2D_:4\u0017n\u001a\u0005\b\u0003\u00039\u0001\u0019AA\u0002\u0011\u001d\t9c\u0002a\u0001\u0003\u0007Aq!a\f\b\u0001\u0004\t\u0019!A\nvaN,'\u000f\u001e#z]\u0006l\u0017nY\"p]\u001aLw\r\u0006\u0003\u0002J\u0006=\u0007cA\u000f\u0002L&\u0019\u0011Q\u001a\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003?B\u0001\u0019AA1\u0003M!W\r\\3uK\u0012Kh.Y7jG\u000e{gNZ5h)\u0011\tI-!6\t\u000f\u0005}\u0013\u00021\u0001\u0002\f\":\u0001!!7\u0002\"\u0005}\u0007c\u0001\"\u0002\\&\u0019\u0011Q\\\"\u0003\u0011\r{gn];nKNd\u0013!\u001b\u0015\b\u0001\u0005\r\u0018\u0011EAu!\r\u0011\u0015Q]\u0005\u0004\u0003O\u001c%\u0001\u0003)s_\u0012,8-Z:-\u0003%Ds\u0001AAw\u0003_\tI\u0010\u0005\u0003\u0002p\u0006UXBAAy\u0015\r\t\u0019\u0010U\u0001\u0005i\u0006<7/\u0003\u0003\u0002x\u0006E(a\u0001+bO\u0006\u0012\u00111`\u0001\u0005\u0007>tg\r")
public class ConfResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public final HttpService httpService() {
        return ApiRequestContext.httpService$(this);
    }

    @Override
    public String normalizeParam(String param) {
        return ApiRequestContext.normalizeParam$(this, param);
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private ConfigService configService() {
        return this.httpService().configService();
    }

    @Operation(description="List the conf setting")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConfResponse.class))})
    @GET
    public ConfResponse conf() {
        return new ConfResponse().configs((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Utils$.MODULE$.redact(this.httpService().conf(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.httpService().conf().getAll())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String n = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new ConfigData().name(n).value(v);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).asJava());
    }

    @Operation(description="List the dynamic configs. The parameter level specifies the config level of dynamic configs. The parameter tenant specifies the tenant id of TENANT or TENANT_USER level. The parameter name specifies the user name of TENANT_USER level. Meanwhile, either none or all of the parameter tenant and name are specified for TENANT_USER level.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=DynamicConfigResponse.class))})
    @GET
    @Path(value="/dynamic")
    public DynamicConfigResponse dynamicConf(@QueryParam(value="level") String level, @QueryParam(value="tenant") String tenant, @QueryParam(value="name") String name) {
        if (this.configService() == null) {
            throw new ServiceUnavailableException(new StringBuilder(69).append("Dynamic configuration is disabled. Please check whether to config").append(" `").append(CelebornConf$.MODULE$.DYNAMIC_CONFIG_STORE_BACKEND().key()).append("`.").toString());
        }
        if (StringUtils.isEmpty((CharSequence)level)) {
            return new DynamicConfigResponse().configs((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ConfigLevel.values())).flatMap((Function1 & Serializable & scala.Serializable)configLevel -> this.getDynamicConfig(configLevel.name(), tenant, name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DynamicConfig.class))))).toSeq()).asJava());
        }
        return new DynamicConfigResponse().configs((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.getDynamicConfig(level, tenant, name)).asJava());
    }

    @Operation(description="Upsert the dynamic configs. The parameter level specifies the config level of dynamic configs. The parameter tenant specifies the tenant id of TENANT or TENANT_USER level. The parameter name specifies the user name of TENANT_USER level. Meanwhile, either none or all of the parameter tenant and name are specified for TENANT_USER level.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/dynamic/upsert")
    public HandleResponse upsertDynamicConf(UpsertDynamicConfigRequest request) {
        if (this.configService() == null) {
            throw new ServiceUnavailableException(new StringBuilder(69).append("Dynamic configuration is disabled. Please check whether to config").append(" `").append(CelebornConf$.MODULE$.DYNAMIC_CONFIG_STORE_BACKEND().key()).append("`.").toString());
        }
        this.upsertDynamicConfig(request);
        return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(29).append("Upsert dynamic configs of `").append(request).append("`.").toString());
    }

    @Operation(description="Delete the dynamic configs. The parameter level specifies the config level of dynamic configs. The parameter tenant specifies the tenant id of TENANT or TENANT_USER level. The parameter name specifies the user name of TENANT_USER level. Meanwhile, either none or all of the parameter tenant and name are specified for TENANT_USER level.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/dynamic/delete")
    public HandleResponse deleteDynamicConf(DeleteDynamicConfigRequest request) {
        if (this.configService() == null) {
            throw new ServiceUnavailableException(new StringBuilder(69).append("Dynamic configuration is disabled. Please check whether to config").append(" `").append(CelebornConf$.MODULE$.DYNAMIC_CONFIG_STORE_BACKEND().key()).append("`.").toString());
        }
        this.deleteDynamicConfig(request);
        return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(new StringBuilder(29).append("Delete dynamic configs of `").append(request).append("`.").toString());
    }

    private Seq<DynamicConfig> getDynamicConfig(String level, String tenant, String name) {
        if (ConfigLevel.SYSTEM.name().equalsIgnoreCase(level)) {
            Map config = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.configService().getSystemConfigFromCache().getConfigs()).asScala();
            return (Seq)new .colon.colon((Object)new DynamicConfig().level(DynamicConfig.LevelEnum.SYSTEM).configs((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)config.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String n = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return new ConfigData().name(n).value(v);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).asJava()), (List)Nil$.MODULE$);
        }
        if (ConfigLevel.TENANT.name().equalsIgnoreCase(level)) {
            .colon.colon tenantConfigs = StringUtils.isEmpty((CharSequence)tenant) ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.configService().listRawTenantConfigsFromCache()).asScala() : new .colon.colon((Object)this.configService().getRawTenantConfigFromCache(tenant), (List)Nil$.MODULE$);
            return ((SeqLike)((TraversableLike)tenantConfigs.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getTenantId(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)tenantConfig -> new DynamicConfig().level(DynamicConfig.LevelEnum.TENANT).desc(new StringBuilder(8).append("Tenant: ").append(tenantConfig.getTenantId()).toString()).configs((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(tenantConfig.getConfigs()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String n = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return new ConfigData().name(n).value(v);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).asJava()), Seq$.MODULE$.canBuildFrom())).toSeq();
        }
        if (ConfigLevel.TENANT_USER.name().equalsIgnoreCase(level)) {
            Nil$ tenantUserConfigs = StringUtils.isEmpty((CharSequence)tenant) && StringUtils.isEmpty((CharSequence)name) ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.configService().listRawTenantUserConfigsFromCache()).asScala() : (new StringOps(Predef$.MODULE$.augmentString(tenant)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(name)).nonEmpty() ? new .colon.colon((Object)this.configService().getRawTenantUserConfigFromCache(tenant, name), (List)Nil$.MODULE$) : Nil$.MODULE$);
            return ((SeqLike)((TraversableLike)tenantUserConfigs.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTenantId(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)tenantUserConfig -> new DynamicConfig().level(DynamicConfig.LevelEnum.TENANT_USER).desc(new StringBuilder(16).append("Tenant: ").append(tenantUserConfig.getTenantId()).append(", User: ").append(tenantUserConfig.getName()).toString()).configs((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(tenantUserConfig.getConfigs()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    String n = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return new ConfigData().name(n).value(v);
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).asJava()), Seq$.MODULE$.canBuildFrom())).toSeq();
        }
        return (Seq)Nil$.MODULE$;
    }

    private void upsertDynamicConfig(UpsertDynamicConfigRequest request) {
        String level = request.getLevel().name();
        if (ConfigLevel.SYSTEM.name().equalsIgnoreCase(level)) {
            this.configService().upsertSystemConfig(request.getConfigs());
            return;
        }
        if (ConfigLevel.TENANT.name().equalsIgnoreCase(level) || ConfigLevel.TENANT_USER.name().equalsIgnoreCase(level)) {
            this.configService().upsertTenantConfig(ConfigLevel.valueOf(level), request.getTenant(), request.getName(), request.getConfigs());
            return;
        }
    }

    private void deleteDynamicConfig(DeleteDynamicConfigRequest request) {
        String level = request.getLevel().name();
        if (ConfigLevel.SYSTEM.name().equalsIgnoreCase(level)) {
            this.configService().deleteSystemConfigByKeys(request.getConfigs());
            return;
        }
        if (ConfigLevel.TENANT.name().equalsIgnoreCase(level) || ConfigLevel.TENANT_USER.name().equalsIgnoreCase(level)) {
            this.configService().deleteTenantConfigByKeys(ConfigLevel.valueOf(level), request.getTenant(), request.getName(), request.getConfigs());
            return;
        }
    }

    public ConfResource() {
        ApiRequestContext.$init$(this);
    }
}

