/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.cli.master;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.celeborn.cli.CelebornCli;
import org.apache.celeborn.cli.common.BaseCommand;
import org.apache.celeborn.cli.common.CommonOptions;
import org.apache.celeborn.cli.config.CliConfigManager;
import org.apache.celeborn.cli.config.CliConfigManager$;
import org.apache.celeborn.cli.master.MasterOptions;
import org.apache.celeborn.cli.master.MasterSubcommand;
import org.apache.celeborn.cli.master.ReviseLostShuffleOptions;
import org.apache.celeborn.rest.v1.master.ApplicationApi;
import org.apache.celeborn.rest.v1.master.ConfApi;
import org.apache.celeborn.rest.v1.master.DefaultApi;
import org.apache.celeborn.rest.v1.master.MasterApi;
import org.apache.celeborn.rest.v1.master.ShuffleApi;
import org.apache.celeborn.rest.v1.master.WorkerApi;
import org.apache.celeborn.rest.v1.model.ApplicationsHeartbeatResponse;
import org.apache.celeborn.rest.v1.model.ConfResponse;
import org.apache.celeborn.rest.v1.model.ContainerInfo;
import org.apache.celeborn.rest.v1.model.DeleteAppsRequest;
import org.apache.celeborn.rest.v1.model.DeleteDynamicConfigRequest;
import org.apache.celeborn.rest.v1.model.DynamicConfigResponse;
import org.apache.celeborn.rest.v1.model.ExcludeWorkerRequest;
import org.apache.celeborn.rest.v1.model.HandleResponse;
import org.apache.celeborn.rest.v1.model.HostnamesResponse;
import org.apache.celeborn.rest.v1.model.MasterInfoResponse;
import org.apache.celeborn.rest.v1.model.RemoveWorkersUnavailableInfoRequest;
import org.apache.celeborn.rest.v1.model.ReviseLostShufflesRequest;
import org.apache.celeborn.rest.v1.model.SendWorkerEventRequest;
import org.apache.celeborn.rest.v1.model.ShufflesResponse;
import org.apache.celeborn.rest.v1.model.ThreadStackResponse;
import org.apache.celeborn.rest.v1.model.TopologyResponse;
import org.apache.celeborn.rest.v1.model.UpsertDynamicConfigRequest;
import org.apache.celeborn.rest.v1.model.WorkerData;
import org.apache.celeborn.rest.v1.model.WorkerEventsResponse;
import org.apache.celeborn.rest.v1.model.WorkerId;
import org.apache.celeborn.rest.v1.model.WorkerTimestampData;
import org.apache.celeborn.rest.v1.model.WorkersResponse;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@CommandLine.Command(name="master")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001\u0002\u0010 \u0001)BQ!\u000e\u0001\u0005\u0002YBQ\u0001\u000f\u0001\u0005BeBa\u0001\u0011\u0001\u0005\u0002}\t\u0005B\u0002'\u0001\t\u0003yR\n\u0003\u0004R\u0001\u0011\u0005qD\u0015\u0005\u0007-\u0002!\taH,\t\rm\u0003A\u0011A\u0010X\u0011\u0019a\u0006\u0001\"\u0001 /\"1Q\f\u0001C\u0001?]CaA\u0018\u0001\u0005\u0002}y\u0006BB2\u0001\t\u0003yB\r\u0003\u0004u\u0001\u0011\u0005q$\u001e\u0005\u0007u\u0002!\taH;\t\rm\u0004A\u0011A\u0010v\u0011\u0019a\b\u0001\"\u0001 k\"1Q\u0010\u0001C\u0001?yD\u0001\"!\u0002\u0001\t\u0003y\u0012q\u0001\u0005\t\u0003\u001f\u0001A\u0011A\u0010\u0002\u0012!A\u0011\u0011\u0004\u0001\u0005\u0002}\tY\u0002\u0003\u0005\u00024\u0001!\taHA\u001b\u0011!\ti\u0004\u0001C\u0001?\u0005}\u0002bBA$\u0001\u0011\u0005qd\u0016\u0005\b\u0003\u0013\u0002A\u0011A\u0010X\u0011!\tY\u0005\u0001C\u0001?\u00055\u0003\u0002CA+\u0001\u0011\u0005q$a\u0016\t\u0011\u0005e\u0003\u0001\"\u0001 \u0003/B\u0001\"a\u0017\u0001\t\u0003y\u0012Q\f\u0005\b\u0003K\u0002A\u0011I\u0010X\u0011\u001d\t9\u0007\u0001C!?]\u0013A#T1ti\u0016\u00148+\u001e2d_6l\u0017M\u001c3J[Bd'B\u0001\u0011\"\u0003\u0019i\u0017m\u001d;fe*\u0011!eI\u0001\u0004G2L'B\u0001\u0013&\u0003!\u0019W\r\\3c_Jt'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001WE\u0002\"\u0001L\u0018\u000e\u00035R!AL\u0011\u0002\r\r|W.\\8o\u0013\t\u0001TFA\u0006CCN,7i\\7nC:$\u0007C\u0001\u001a4\u001b\u0005y\u0012B\u0001\u001b \u0005Ai\u0015m\u001d;feN+(mY8n[\u0006tG-\u0001\u0004=S:LGO\u0010\u000b\u0002oA\u0011!\u0007A\u0001\u0004eVtG#\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\tUs\u0017\u000e^\u0001\u0013eVt7\u000b[8x\u001b\u0006\u001cH/\u001a:t\u0013:4w.F\u0001C!\t\u0019%*D\u0001E\u0015\t)e)A\u0003n_\u0012,GN\u0003\u0002H\u0011\u0006\u0011a/\r\u0006\u0003\u0013\u000e\nAA]3ti&\u00111\n\u0012\u0002\u0013\u001b\u0006\u001cH/\u001a:J]\u001a|'+Z:q_:\u001cX-\u0001\nsk:\u001c\u0006n\\<DYV\u001cH/\u001a:BaB\u001cX#\u0001(\u0011\u0005\r{\u0015B\u0001)E\u0005u\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8t\u0011\u0016\f'\u000f\u001e2fCR\u0014Vm\u001d9p]N,\u0017A\u0006:v]NCwn^\"mkN$XM]*ik\u001a4G.Z:\u0016\u0003M\u0003\"a\u0011+\n\u0005U#%\u0001E*ik\u001a4G.Z:SKN\u0004xN\\:f\u0003E\u0011XO\\#yG2,H-Z,pe.,'o]\u000b\u00021B\u00111)W\u0005\u00035\u0012\u0013a\u0002S1oI2,'+Z:q_:\u001cX-\u0001\rsk:\u0014V-\\8wK\u0016C8\r\\;eK\u0012<vN]6feN\fqD];o%\u0016lwN^3X_J\\WM]:V]\u00064\u0018-\u001b7bE2,\u0017J\u001c4p\u0003I\u0011XO\\*f]\u0012<vN]6fe\u00163XM\u001c;\u0002-I,hn\u00155po^{'o[3s\u000bZ,g\u000e^%oM>,\u0012\u0001\u0019\t\u0003\u0007\u0006L!A\u0019#\u0003)]{'o[3s\u000bZ,g\u000e^:SKN\u0004xN\\:f\u0003I\u0011XO\\*i_^dun\u001d;X_J\\WM]:\u0016\u0003\u0015\u00042A\u001a8r\u001d\t9GN\u0004\u0002iW6\t\u0011N\u0003\u0002kS\u00051AH]8pizJ\u0011!P\u0005\u0003[r\nq\u0001]1dW\u0006<W-\u0003\u0002pa\n\u00191+Z9\u000b\u00055d\u0004CA\"s\u0013\t\u0019HIA\nX_J\\WM\u001d+j[\u0016\u001cH/Y7q\t\u0006$\u0018-\u0001\fsk:\u001c\u0006n\\<Fq\u000edW\u000fZ3e/>\u00148.\u001a:t+\u00051\bc\u00014ooB\u00111\t_\u0005\u0003s\u0012\u0013!bV8sW\u0016\u0014H)\u0019;b\u0003q\u0011XO\\*i_^l\u0015M\\;bY\u0016C8\r\\;eK\u0012<vN]6feN\faC];o'\"|wo\u00155vi\u0012|wO\\,pe.,'o]\u0001\u001eeVt7\u000b[8x\t\u0016\u001cw.\\7jgNLwN\\5oO^{'o[3sg\u0006A\"/\u001e8TQ><H*\u001b4fGf\u001cG.Z'b]\u0006<WM]:\u0016\u0003}\u00042aQA\u0001\u0013\r\t\u0019\u0001\u0012\u0002\u0012\u0011>\u001cHO\\1nKN\u0014Vm\u001d9p]N,\u0017A\u0004:v]NCwn^,pe.,'o]\u000b\u0003\u0003\u0013\u00012aQA\u0006\u0013\r\ti\u0001\u0012\u0002\u0010/>\u00148.\u001a:t%\u0016\u001c\bo\u001c8tK\u00061\"/\u001e8TQ><xk\u001c:lKJ\u001cHk\u001c9pY><\u00170\u0006\u0002\u0002\u0014A\u00191)!\u0006\n\u0007\u0005]AI\u0001\tU_B|Gn\\4z%\u0016\u001c\bo\u001c8tK\u0006aq-\u001a;X_J\\WM]%egV\u0011\u0011Q\u0004\t\u0007\u0003?\tI#!\f\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\tA!\u001e;jY*\u0011\u0011qE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002,\u0005\u0005\"\u0001\u0002'jgR\u00042aQA\u0018\u0013\r\t\t\u0004\u0012\u0002\t/>\u00148.\u001a:JI\u0006Y!/\u001e8TQ><8i\u001c8g+\t\t9\u0004E\u0002D\u0003sI1!a\u000fE\u00051\u0019uN\u001c4SKN\u0004xN\\:f\u0003I\u0011XO\\*i_^$\u0015P\\1nS\u000e\u001cuN\u001c4\u0016\u0005\u0005\u0005\u0003cA\"\u0002D%\u0019\u0011Q\t#\u0003+\u0011Kh.Y7jG\u000e{gNZ5h%\u0016\u001c\bo\u001c8tK\u0006!\"/\u001e8VaN,'\u000f\u001e#z]\u0006l\u0017nY\"p]\u001a\fAC];o\t\u0016dW\r^3Es:\fW.[2D_:4\u0017!\u0005:v]NCwn\u001e+ie\u0016\fG\rR;naV\u0011\u0011q\n\t\u0004\u0007\u0006E\u0013bAA*\t\n\u0019B\u000b\u001b:fC\u0012\u001cF/Y2l%\u0016\u001c\bo\u001c8tK\u0006\u0011\"/\u001e8BI\u0012\u001cE.^:uKJ\fE.[1t+\u0005Q\u0014!\u0006:v]J+Wn\u001c<f\u00072,8\u000f^3s\u00032L\u0017m]\u0001\u0015eVt7\u000b[8x\u0007>tG/Y5oKJLeNZ8\u0016\u0005\u0005}\u0003cA\"\u0002b%\u0019\u00111\r#\u0003\u001b\r{g\u000e^1j]\u0016\u0014\u0018J\u001c4p\u0003I\u0011XM^5tK2{7\u000f^*ik\u001a4G.Z:\u0002\u0015\u0011,G.\u001a;f\u0003B\u00048\u000fK\u0004\u0001\u0003W\n\t)a!\u0011\t\u00055\u00141\u0010\b\u0005\u0003_\n)HD\u0002i\u0003cJ!!a\u001d\u0002\u000fAL7m\\2mS&!\u0011qOA=\u0003-\u0019u.\\7b]\u0012d\u0015N\\3\u000b\u0005\u0005M\u0014\u0002BA?\u0003\u007f\u0012qaQ8n[\u0006tGM\u0003\u0003\u0002x\u0005e\u0014\u0001\u00028b[\u0016\f\u0013\u0001\t")
public class MasterSubcommandImpl
extends BaseCommand
implements MasterSubcommand {
    @CommandLine.ParentCommand
    private CelebornCli org$apache$celeborn$cli$master$MasterSubcommand$$celebornCli;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    private MasterOptions masterOptions;
    @CommandLine.ArgGroup(exclusive=false)
    private ReviseLostShuffleOptions reviseLostShuffleOptions;
    @CommandLine.Mixin
    private CommonOptions commonOptions;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    private final CliConfigManager cliConfigManager;

    @Override
    public ApplicationApi applicationApi() {
        return MasterSubcommand.applicationApi$(this);
    }

    @Override
    public ConfApi confApi() {
        return MasterSubcommand.confApi$(this);
    }

    @Override
    public DefaultApi defaultApi() {
        return MasterSubcommand.defaultApi$(this);
    }

    @Override
    public MasterApi masterApi() {
        return MasterSubcommand.masterApi$(this);
    }

    @Override
    public ShuffleApi shuffleApi() {
        return MasterSubcommand.shuffleApi$(this);
    }

    @Override
    public WorkerApi workerApi() {
        return MasterSubcommand.workerApi$(this);
    }

    @Override
    public CelebornCli org$apache$celeborn$cli$master$MasterSubcommand$$celebornCli() {
        return this.org$apache$celeborn$cli$master$MasterSubcommand$$celebornCli;
    }

    @Override
    public void org$apache$celeborn$cli$master$MasterSubcommand$$celebornCli_$eq(CelebornCli x$1) {
        this.org$apache$celeborn$cli$master$MasterSubcommand$$celebornCli = x$1;
    }

    @Override
    public MasterOptions masterOptions() {
        return this.masterOptions;
    }

    @Override
    public void masterOptions_$eq(MasterOptions x$1) {
        this.masterOptions = x$1;
    }

    @Override
    public ReviseLostShuffleOptions reviseLostShuffleOptions() {
        return this.reviseLostShuffleOptions;
    }

    @Override
    public void reviseLostShuffleOptions_$eq(ReviseLostShuffleOptions x$1) {
        this.reviseLostShuffleOptions = x$1;
    }

    @Override
    public CommonOptions commonOptions() {
        return this.commonOptions;
    }

    @Override
    public void commonOptions_$eq(CommonOptions x$1) {
        this.commonOptions = x$1;
    }

    @Override
    public CommandLine.Model.CommandSpec spec() {
        return this.spec;
    }

    @Override
    public void spec_$eq(CommandLine.Model.CommandSpec x$1) {
        this.spec = x$1;
    }

    @Override
    public CliConfigManager cliConfigManager() {
        return this.cliConfigManager;
    }

    @Override
    public void org$apache$celeborn$cli$master$MasterSubcommand$_setter_$cliConfigManager_$eq(CliConfigManager x$1) {
        this.cliConfigManager = x$1;
    }

    @Override
    public void run() {
        if (this.masterOptions().showMastersInfo()) {
            this.log(this.runShowMastersInfo());
        }
        if (this.masterOptions().showClusterApps()) {
            this.log(this.runShowClusterApps());
        }
        if (this.masterOptions().showClusterShuffles()) {
            this.log(this.runShowClusterShuffles());
        }
        if (this.masterOptions().excludeWorkers()) {
            this.log(this.runExcludeWorkers());
        }
        if (this.masterOptions().removeExcludedWorkers()) {
            this.log(this.runRemoveExcludedWorkers());
        }
        if (this.masterOptions().removeWorkersUnavailableInfo()) {
            this.log(this.runRemoveWorkersUnavailableInfo());
        }
        if (this.masterOptions().sendWorkerEvent() != null && new StringOps(Predef$.MODULE$.augmentString(this.masterOptions().sendWorkerEvent())).nonEmpty()) {
            this.log(this.runSendWorkerEvent());
        }
        if (this.masterOptions().showWorkerEventInfo()) {
            this.log(this.runShowWorkerEventInfo());
        }
        if (this.masterOptions().showLostWorkers()) {
            this.log(this.runShowLostWorkers());
        }
        if (this.masterOptions().showExcludedWorkers()) {
            this.log(this.runShowExcludedWorkers());
        }
        if (this.masterOptions().showManualExcludedWorkers()) {
            this.log(this.runShowManualExcludedWorkers());
        }
        if (this.masterOptions().showShutdownWorkers()) {
            this.log(this.runShowShutdownWorkers());
        }
        if (this.masterOptions().showDecommissioningWorkers()) {
            this.log(this.runShowDecommissioningWorkers());
        }
        if (this.masterOptions().showLifecycleManagers()) {
            this.log(this.runShowLifecycleManagers());
        }
        if (this.masterOptions().showWorkers()) {
            this.log(this.runShowWorkers());
        }
        if (this.masterOptions().showWorkersTopology()) {
            this.log(this.runShowWorkersTopology());
        }
        if (this.masterOptions().showConf()) {
            this.log(this.runShowConf());
        }
        if (this.masterOptions().showContainerInfo()) {
            this.log(this.runShowContainerInfo());
        }
        if (this.masterOptions().showDynamicConf()) {
            this.log(this.runShowDynamicConf());
        }
        if (this.masterOptions().upsertDynamicConf()) {
            this.log(this.runUpsertDynamicConf());
        }
        if (this.masterOptions().deleteDynamicConf()) {
            this.log(this.runDeleteDynamicConf());
        }
        if (this.masterOptions().showThreadDump()) {
            this.log(this.runShowThreadDump());
        }
        if (this.masterOptions().reviseLostShuffles()) {
            this.log(this.reviseLostShuffles());
        }
        if (this.masterOptions().deleteApps()) {
            this.log(this.deleteApps());
        }
        if (this.masterOptions().addClusterAlias() != null && new StringOps(Predef$.MODULE$.augmentString(this.masterOptions().addClusterAlias())).nonEmpty()) {
            this.runAddClusterAlias();
        }
        if (this.masterOptions().removeClusterAlias() != null && new StringOps(Predef$.MODULE$.augmentString(this.masterOptions().removeClusterAlias())).nonEmpty()) {
            this.runRemoveClusterAlias();
            return;
        }
    }

    @Override
    public MasterInfoResponse runShowMastersInfo() {
        return this.masterApi().getMasterGroupInfo(this.commonOptions().getAuthHeader());
    }

    @Override
    public ApplicationsHeartbeatResponse runShowClusterApps() {
        return this.applicationApi().getApplications(this.commonOptions().getAuthHeader());
    }

    @Override
    public ShufflesResponse runShowClusterShuffles() {
        return this.shuffleApi().getShuffles(this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse runExcludeWorkers() {
        List<WorkerId> workerIds = this.getWorkerIds();
        ExcludeWorkerRequest excludeWorkerRequest = new ExcludeWorkerRequest().add(workerIds);
        this.logInfo(new StringBuilder(69).append("Sending exclude worker requests to master for the following workers: ").append(workerIds).toString());
        return this.workerApi().excludeWorker(excludeWorkerRequest, this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse runRemoveExcludedWorkers() {
        List<WorkerId> workerIds = this.getWorkerIds();
        ExcludeWorkerRequest removeExcludeWorkerRequest = new ExcludeWorkerRequest().remove(workerIds);
        this.logInfo(new StringBuilder(76).append("Sending remove exclude worker requests to master for the following workers: ").append(workerIds).toString());
        return this.workerApi().excludeWorker(removeExcludeWorkerRequest, this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse runRemoveWorkersUnavailableInfo() {
        List<WorkerId> workerIds = this.getWorkerIds();
        RemoveWorkersUnavailableInfoRequest removeWorkersUnavailableInfoRequest = new RemoveWorkersUnavailableInfoRequest().workers(workerIds);
        this.logInfo(new StringBuilder(86).append("Sending remove workers unavailable info requests to master for the following workers: ").append(workerIds).toString());
        return this.workerApi().removeWorkersUnavailableInfo(removeWorkersUnavailableInfoRequest, this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse runSendWorkerEvent() {
        SendWorkerEventRequest.EventTypeEnum eventTypeEnum;
        try {
            eventTypeEnum = SendWorkerEventRequest.EventTypeEnum.valueOf((String)this.masterOptions().sendWorkerEvent().toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), new StringBuilder(26).append("Worker event type must be ").append(((Stream)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SendWorkerEventRequest.EventTypeEnum.values())).toStream().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Stream$.MODULE$.canBuildFrom())).mkString(",")).toString());
        }
        SendWorkerEventRequest.EventTypeEnum eventType = eventTypeEnum;
        List<WorkerId> workerIds = this.getWorkerIds();
        SendWorkerEventRequest sendWorkerEventRequest = new SendWorkerEventRequest().workers(workerIds).eventType(eventType);
        this.logInfo(new StringBuilder(33).append("Sending workerEvent ").append(eventType).append(" to workers: ").append(workerIds).toString());
        return this.workerApi().sendWorkerEvent(sendWorkerEventRequest, this.commonOptions().getAuthHeader());
    }

    @Override
    public WorkerEventsResponse runShowWorkerEventInfo() {
        return this.workerApi().getWorkerEvents(this.commonOptions().getAuthHeader());
    }

    @Override
    public Seq<WorkerTimestampData> runShowLostWorkers() {
        Seq lostWorkers = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.runShowWorkers().getLostWorkers()).asScala()).toSeq();
        if (lostWorkers.isEmpty()) {
            this.log("No lost workers found.");
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)lostWorkers.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getWorker().getHost(), (Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Seq<WorkerData> runShowExcludedWorkers() {
        Seq excludedWorkers = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.runShowWorkers().getExcludedWorkers()).asScala()).toSeq();
        if (excludedWorkers.isEmpty()) {
            this.log("No excluded workers found.");
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)excludedWorkers.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getHost(), (Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Seq<WorkerData> runShowManualExcludedWorkers() {
        Seq manualExcludedWorkers = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.runShowWorkers().getManualExcludedWorkers()).asScala()).toSeq();
        if (manualExcludedWorkers.isEmpty()) {
            this.log("No manual excluded workers found.");
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)manualExcludedWorkers.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getHost(), (Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Seq<WorkerData> runShowShutdownWorkers() {
        Seq shutdownWorkers = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.runShowWorkers().getShutdownWorkers()).asScala()).toSeq();
        if (shutdownWorkers.isEmpty()) {
            this.log("No shutdown workers found.");
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)shutdownWorkers.sortBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getHost(), (Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Seq<WorkerData> runShowDecommissioningWorkers() {
        Seq decommissioningWorkers = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.runShowWorkers().getDecommissioningWorkers()).asScala()).toSeq();
        if (decommissioningWorkers.isEmpty()) {
            this.log("No decommissioning workers found.");
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)decommissioningWorkers.sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getHost(), (Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public HostnamesResponse runShowLifecycleManagers() {
        return this.applicationApi().getApplicationHostNames(this.commonOptions().getAuthHeader());
    }

    @Override
    public WorkersResponse runShowWorkers() {
        return this.workerApi().getWorkers(this.commonOptions().getAuthHeader());
    }

    public TopologyResponse runShowWorkersTopology() {
        return this.workerApi().getWorkersTopology(this.commonOptions().getAuthHeader());
    }

    @Override
    public List<WorkerId> getWorkerIds() {
        String workerIds = this.commonOptions().workerIds();
        if (workerIds == null || workerIds.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), "Host list must be provided for this command.");
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])workerIds.trim().split(","))).map((Function1 & Serializable & scala.Serializable)workerId -> {
            String[] splitWorkerId = workerId.split(":");
            String host = splitWorkerId[0];
            int rpcPort = new StringOps(Predef$.MODULE$.augmentString(splitWorkerId[1])).toInt();
            int pushPort = new StringOps(Predef$.MODULE$.augmentString(splitWorkerId[2])).toInt();
            int fetchPort = new StringOps(Predef$.MODULE$.augmentString(splitWorkerId[3])).toInt();
            int replicatePort = new StringOps(Predef$.MODULE$.augmentString(splitWorkerId[4])).toInt();
            return new WorkerId().host(host).rpcPort(Predef$.MODULE$.int2Integer(rpcPort)).pushPort(Predef$.MODULE$.int2Integer(pushPort)).fetchPort(Predef$.MODULE$.int2Integer(fetchPort)).replicatePort(Predef$.MODULE$.int2Integer(replicatePort));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WorkerId.class))))).toList()).asJava();
    }

    @Override
    public ConfResponse runShowConf() {
        return this.confApi().getConf(this.commonOptions().getAuthHeader());
    }

    @Override
    public DynamicConfigResponse runShowDynamicConf() {
        return this.confApi().getDynamicConf(this.commonOptions().configLevel(), this.commonOptions().configTenant(), this.commonOptions().configName(), this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse runUpsertDynamicConf() {
        ConfApi confApi = this.confApi();
        return this.upsertDynamicConf(this.commonOptions(), this.spec(), (Function2<UpsertDynamicConfigRequest, Map<String, String>, HandleResponse>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> confApi.upsertDynamicConf(x$1, x$2));
    }

    @Override
    public HandleResponse runDeleteDynamicConf() {
        ConfApi confApi = this.confApi();
        return this.deleteDynamicConf(this.commonOptions(), this.spec(), (Function2<DeleteDynamicConfigRequest, Map<String, String>, HandleResponse>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> confApi.deleteDynamicConf(x$1, x$2));
    }

    @Override
    public ThreadStackResponse runShowThreadDump() {
        return this.defaultApi().getThreadDump(this.commonOptions().getAuthHeader());
    }

    public void runAddClusterAlias() {
        String aliasToAdd = this.masterOptions().addClusterAlias();
        String hosts = this.commonOptions().hostList();
        if (hosts == null || hosts.isEmpty()) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), "Host list must be supplied via --host-list to add to alias.");
        }
        this.cliConfigManager().add(aliasToAdd, hosts);
        this.logInfo(new StringBuilder(80).append("Cluster alias ").append(aliasToAdd).append(" added to ").append(CliConfigManager$.MODULE$.cliConfigFilePath()).append(". You can now use the --cluster").append(" command with this alias.").toString());
    }

    public void runRemoveClusterAlias() {
        String aliasToRemove = this.masterOptions().removeClusterAlias();
        this.cliConfigManager().remove(aliasToRemove);
        this.logInfo(new StringBuilder(23).append("Cluster alias ").append(aliasToRemove).append(" removed.").toString());
    }

    @Override
    public ContainerInfo runShowContainerInfo() {
        return this.defaultApi().getContainerInfo(this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse reviseLostShuffles() {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.commonOptions().apps(), this.reviseLostShuffleOptions().shuffleIds()})) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), "Application id and Shuffle ids must be provided for this command.");
        }
        String app = this.commonOptions().apps();
        if (app.contains(",")) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), "Only one application id can be provided for this command.");
        }
        List<Object> shuffleIds = Arrays.asList((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.reviseLostShuffleOptions().shuffleIds().split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> Integer.valueOf(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))));
        ReviseLostShufflesRequest request = new ReviseLostShufflesRequest().appId(app).shuffleIds(shuffleIds);
        return this.applicationApi().reviseLostShuffles(request, this.commonOptions().getAuthHeader());
    }

    @Override
    public HandleResponse deleteApps() {
        if (StringUtils.isBlank((CharSequence)this.commonOptions().apps())) {
            throw new CommandLine.ParameterException(this.spec().commandLine(), "Applications must be provided for this command.");
        }
        List<Object> appIds = Arrays.asList((Object[])this.commonOptions().apps().split(","));
        DeleteAppsRequest request = new DeleteAppsRequest().apps(appIds);
        return this.applicationApi().deleteApps(request, this.commonOptions().getAuthHeader());
    }

    public MasterSubcommandImpl() {
        MasterSubcommand.$init$(this);
    }
}

