/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.config.ConfigEntry;
import org.apache.celeborn.common.quota.StorageQuota;
import org.apache.celeborn.common.quota.UserTrafficQuota;
import org.apache.celeborn.common.quota.WorkerTrafficQuota;
import org.apache.celeborn.common.tags.WorkerTagsMeta;
import org.apache.celeborn.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicConfig.class);
    protected volatile Map<String, String> configs = new HashMap<String, String>();
    protected volatile Map<String, Set<String>> tags = null;

    public abstract DynamicConfig getParentLevelConfig();

    public <T> T getWithDefaultValue(String configKey, T defaultValue, Class<T> finalType, ConfigType configType) {
        T formatValue;
        String configValue = this.configs.get(configKey);
        T t = formatValue = configValue != null ? (T)this.formatValue(configKey, configValue, finalType, configType) : null;
        if (formatValue == null) {
            return defaultValue;
        }
        return formatValue;
    }

    public <T, V> T getValue(String configKey, ConfigEntry<V> configEntry, Class<T> finalType, ConfigType configType) {
        T formatValue;
        String configValue = this.configs.get(configKey);
        T t = formatValue = configValue != null ? (T)this.formatValue(configKey, configValue, finalType, configType) : null;
        if (formatValue == null) {
            DynamicConfig parentLevelConfig = this.getParentLevelConfig();
            return parentLevelConfig != null ? (T)parentLevelConfig.getValue(configKey, configEntry, finalType, configType) : null;
        }
        return formatValue;
    }

    public <T> T formatValue(String configKey, String configValue, Class<T> finalType, ConfigType configType) {
        try {
            if (configValue != null) {
                if (ConfigType.BYTES == configType) {
                    return DynamicConfig.convert(finalType, String.valueOf(Utils.byteStringAsBytes((String)configValue)));
                }
                if (ConfigType.TIME_MS == configType) {
                    return DynamicConfig.convert(finalType, String.valueOf(Utils.timeStringAsMs((String)configValue)));
                }
                return DynamicConfig.convert(finalType, configValue);
            }
        }
        catch (Exception e) {
            LOG.warn("Config {} value format is not valid, refer to parent if exist", (Object)configKey, (Object)e);
        }
        return null;
    }

    public StorageQuota getTenantStorageQuota() {
        return new StorageQuota(this.getValue(CelebornConf.QUOTA_TENANT_DISK_BYTES_WRITTEN().key(), CelebornConf.QUOTA_TENANT_DISK_BYTES_WRITTEN(), Long.TYPE, ConfigType.BYTES).longValue(), this.getValue(CelebornConf.QUOTA_TENANT_DISK_FILE_COUNT().key(), CelebornConf.QUOTA_TENANT_DISK_FILE_COUNT(), Long.TYPE, ConfigType.STRING).longValue(), this.getValue(CelebornConf.QUOTA_TENANT_HDFS_BYTES_WRITTEN().key(), CelebornConf.QUOTA_TENANT_HDFS_BYTES_WRITTEN(), Long.TYPE, ConfigType.BYTES).longValue(), this.getValue(CelebornConf.QUOTA_TENANT_HDFS_FILE_COUNT().key(), CelebornConf.QUOTA_TENANT_HDFS_FILE_COUNT(), Long.TYPE, ConfigType.STRING).longValue());
    }

    public UserTrafficQuota getUserTrafficQuota() {
        return new UserTrafficQuota(this.getValue(CelebornConf.WORKER_CONGESTION_CONTROL_USER_PRODUCE_SPEED_HIGH_WATERMARK().key(), CelebornConf.WORKER_CONGESTION_CONTROL_USER_PRODUCE_SPEED_HIGH_WATERMARK(), Long.TYPE, ConfigType.BYTES).longValue(), this.getValue(CelebornConf.WORKER_CONGESTION_CONTROL_USER_PRODUCE_SPEED_LOW_WATERMARK().key(), CelebornConf.WORKER_CONGESTION_CONTROL_USER_PRODUCE_SPEED_LOW_WATERMARK(), Long.TYPE, ConfigType.BYTES).longValue());
    }

    public WorkerTrafficQuota getWorkerTrafficQuota() {
        return new WorkerTrafficQuota(this.getValue(CelebornConf.WORKER_CONGESTION_CONTROL_DISK_BUFFER_HIGH_WATERMARK().key(), CelebornConf.WORKER_CONGESTION_CONTROL_DISK_BUFFER_HIGH_WATERMARK(), Long.TYPE, ConfigType.BYTES).longValue(), this.getValue(CelebornConf.WORKER_CONGESTION_CONTROL_DISK_BUFFER_LOW_WATERMARK().key(), CelebornConf.WORKER_CONGESTION_CONTROL_DISK_BUFFER_LOW_WATERMARK(), Long.TYPE, ConfigType.BYTES).longValue(), this.getValue(CelebornConf.WORKER_CONGESTION_CONTROL_WORKER_PRODUCE_SPEED_HIGH_WATERMARK().key(), CelebornConf.WORKER_CONGESTION_CONTROL_WORKER_PRODUCE_SPEED_HIGH_WATERMARK(), Long.TYPE, ConfigType.BYTES).longValue(), this.getValue(CelebornConf.WORKER_CONGESTION_CONTROL_WORKER_PRODUCE_SPEED_LOW_WATERMARK().key(), CelebornConf.WORKER_CONGESTION_CONTROL_WORKER_PRODUCE_SPEED_LOW_WATERMARK(), Long.TYPE, ConfigType.BYTES).longValue());
    }

    public WorkerTagsMeta getWorkerTagsMeta() {
        return new WorkerTagsMeta(this.getValue(CelebornConf.TAGS_EXPR().key(), CelebornConf.TAGS_EXPR(), String.class, ConfigType.STRING), this.getValue(CelebornConf.PREFER_CLIENT_TAGS_EXPR().key(), CelebornConf.PREFER_CLIENT_TAGS_EXPR(), Boolean.TYPE, ConfigType.STRING).booleanValue());
    }

    public StorageQuota getClusterStorageQuota() {
        return new StorageQuota(this.getValue(CelebornConf.QUOTA_CLUSTER_DISK_BYTES_WRITTEN().key(), CelebornConf.QUOTA_CLUSTER_DISK_BYTES_WRITTEN(), Long.TYPE, ConfigType.BYTES).longValue(), this.getValue(CelebornConf.QUOTA_CLUSTER_DISK_FILE_COUNT().key(), CelebornConf.QUOTA_CLUSTER_DISK_FILE_COUNT(), Long.TYPE, ConfigType.STRING).longValue(), this.getValue(CelebornConf.QUOTA_CLUSTER_HDFS_BYTES_WRITTEN().key(), CelebornConf.QUOTA_CLUSTER_HDFS_BYTES_WRITTEN(), Long.TYPE, ConfigType.BYTES).longValue(), this.getValue(CelebornConf.QUOTA_CLUSTER_HDFS_FILE_COUNT().key(), CelebornConf.QUOTA_CLUSTER_HDFS_FILE_COUNT(), Long.TYPE, ConfigType.STRING).longValue());
    }

    public StorageQuota getUserStorageQuota() {
        return new StorageQuota(this.getValue(CelebornConf.QUOTA_USER_DISK_BYTES_WRITTEN().key(), CelebornConf.QUOTA_USER_DISK_BYTES_WRITTEN(), Long.TYPE, ConfigType.BYTES).longValue(), this.getValue(CelebornConf.QUOTA_USER_DISK_FILE_COUNT().key(), CelebornConf.QUOTA_USER_DISK_FILE_COUNT(), Long.TYPE, ConfigType.STRING).longValue(), this.getValue(CelebornConf.QUOTA_USER_HDFS_BYTES_WRITTEN().key(), CelebornConf.QUOTA_USER_HDFS_BYTES_WRITTEN(), Long.TYPE, ConfigType.BYTES).longValue(), this.getValue(CelebornConf.QUOTA_USER_HDFS_FILE_COUNT().key(), CelebornConf.QUOTA_USER_HDFS_FILE_COUNT(), Long.TYPE, ConfigType.STRING).longValue());
    }

    public boolean interruptShuffleEnabled() {
        return this.getValue(CelebornConf.QUOTA_INTERRUPT_SHUFFLE_ENABLED().key(), CelebornConf.QUOTA_INTERRUPT_SHUFFLE_ENABLED(), Boolean.TYPE, ConfigType.BOOLEAN);
    }

    public boolean clusterQuotaEnabled() {
        return this.getValue(CelebornConf.CLUSTER_QUOTA_ENABLED().key(), CelebornConf.CLUSTER_QUOTA_ENABLED(), Boolean.TYPE, ConfigType.BOOLEAN);
    }

    public boolean tenantQuotaEnabled() {
        return this.getValue(CelebornConf.TENANT_QUOTA_ENABLED().key(), CelebornConf.TENANT_QUOTA_ENABLED(), Boolean.TYPE, ConfigType.BOOLEAN);
    }

    public boolean userQuotaEnabled() {
        return this.getValue(CelebornConf.USER_QUOTA_ENABLED().key(), CelebornConf.USER_QUOTA_ENABLED(), Boolean.TYPE, ConfigType.BOOLEAN);
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Set<String>> getTags() {
        if (this.tags != null) return this.tags;
        Class<DynamicConfig> clazz = DynamicConfig.class;
        synchronized (DynamicConfig.class) {
            if (this.tags != null) return this.tags;
            this.tags = this.currentTags();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.tags;
        }
    }

    protected Map<String, Set<String>> currentTags() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DynamicConfig{");
        sb.append("configs=").append(this.configs);
        sb.append('}');
        return sb.toString();
    }

    public static <T> T convert(Class<T> clazz, String value) {
        if (Boolean.TYPE == clazz) {
            return (T)Boolean.valueOf(value);
        }
        if (Byte.TYPE == clazz) {
            return (T)Byte.valueOf(value);
        }
        if (Short.TYPE == clazz) {
            return (T)Short.valueOf(value);
        }
        if (Integer.TYPE == clazz) {
            return (T)Integer.valueOf(value);
        }
        if (Long.TYPE == clazz) {
            return (T)Long.valueOf(value);
        }
        if (Float.TYPE == clazz) {
            return (T)Float.valueOf(value);
        }
        if (Double.TYPE == clazz) {
            return (T)Double.valueOf(value);
        }
        return (T)value;
    }

    public static enum ConfigType {
        BYTES,
        STRING,
        TIME_MS,
        BOOLEAN;

    }
}

