/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;

@Deprecated
public final class OpenStream
extends RequestMessage {
    public byte[] shuffleKey;
    public byte[] fileName;
    public int startMapIndex;
    public int endMapIndex;

    public OpenStream(String shuffleKey, String fileName, int startMapIndex, int endMapIndex) {
        this(shuffleKey.getBytes(StandardCharsets.UTF_8), fileName.getBytes(StandardCharsets.UTF_8), startMapIndex, endMapIndex);
    }

    public OpenStream(byte[] shuffleKey, byte[] fileName, int startMapIndex, int endMapIndex) {
        this.shuffleKey = shuffleKey;
        this.fileName = fileName;
        this.startMapIndex = startMapIndex;
        this.endMapIndex = endMapIndex;
    }

    @Override
    public Message.Type type() {
        return Message.Type.OPEN_STREAM;
    }

    @Override
    public int encodedLength() {
        return 4 + this.shuffleKey.length + 4 + this.fileName.length + 4 + 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeInt(this.shuffleKey.length);
        buf.writeBytes(this.shuffleKey);
        buf.writeInt(this.fileName.length);
        buf.writeBytes(this.fileName);
        buf.writeInt(this.startMapIndex);
        buf.writeInt(this.endMapIndex);
    }

    public static OpenStream decode(ByteBuf buf) {
        int shuffleKeySize = buf.readInt();
        byte[] shuffleKey = new byte[shuffleKeySize];
        buf.readBytes(shuffleKey);
        int fileNameSize = buf.readInt();
        byte[] fileName = new byte[fileNameSize];
        buf.readBytes(fileName);
        return new OpenStream(shuffleKey, fileName, buf.readInt(), buf.readInt());
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.shuffleKey), Arrays.hashCode(this.fileName), this.startMapIndex, this.endMapIndex);
    }

    public boolean equals(Object other) {
        if (other instanceof OpenStream) {
            OpenStream o = (OpenStream)other;
            return this.startMapIndex == o.startMapIndex && this.endMapIndex == o.endMapIndex && Arrays.equals(this.shuffleKey, o.shuffleKey) && Arrays.equals(this.fileName, o.fileName);
        }
        return false;
    }

    public String toString() {
        return "OpenStream[shuffleKey=" + new String(this.shuffleKey, StandardCharsets.UTF_8) + ",fileName=" + new String(this.fileName, StandardCharsets.UTF_8) + ",startMapIndex=" + this.startMapIndex + ",endMapIndex=" + this.endMapIndex + "]";
    }
}

