/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.db.load.CatalogPopUpMenu;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.dialog.db.load.DefaultPopUpMenu;
import org.apache.cayenne.modeler.dialog.db.load.IncludeTablePopUpMenu;
import org.apache.cayenne.modeler.dialog.db.load.RootPopUpMenu;
import org.apache.cayenne.modeler.dialog.db.load.SchemaPopUpMenu;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTreeCellEditor;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTreeCellRenderer;
import org.apache.cayenne.modeler.editor.dbimport.DraggableTreePanel;
import org.apache.cayenne.modeler.editor.dbimport.TreeToolbarPanel;

class ReverseEngineeringTreePanel
extends JScrollPane {
    private DbImportTree reverseEngineeringTree;
    private DbImportTree dbSchemaTree;
    private ProjectController projectController;
    private TreeToolbarPanel treeToolbar;
    private Map<Class, DefaultPopUpMenu> popups;

    ReverseEngineeringTreePanel(ProjectController projectController, DbImportTree reverseEngineeringTree, DbImportTree dbSchemaTree) {
        super(reverseEngineeringTree);
        this.projectController = projectController;
        this.reverseEngineeringTree = reverseEngineeringTree;
        this.dbSchemaTree = dbSchemaTree;
        reverseEngineeringTree.setEditable(true);
        reverseEngineeringTree.setCellRenderer(new DbImportTreeCellRenderer());
        DbImportTreeCellEditor editor = new DbImportTreeCellEditor(reverseEngineeringTree, (DefaultTreeCellRenderer)reverseEngineeringTree.getCellRenderer());
        editor.setProjectController(projectController);
        reverseEngineeringTree.setCellEditor(editor);
        this.initListeners();
        this.initPopupMenus();
        this.changeIcons();
    }

    void updateTree() {
        this.reverseEngineeringTree.translateReverseEngineeringToTree(this.getReverseEngineeringBySelectedMap(), false);
    }

    private void initPopupMenus() {
        this.popups = new HashMap<Class, DefaultPopUpMenu>();
        this.popups.put(Catalog.class, new CatalogPopUpMenu());
        this.popups.put(Schema.class, new SchemaPopUpMenu());
        this.popups.put(ReverseEngineering.class, new RootPopUpMenu());
        this.popups.put(String.class, new RootPopUpMenu());
        this.popups.put(IncludeTable.class, new IncludeTablePopUpMenu());
        this.popups.put(ExcludeTable.class, new DefaultPopUpMenu());
        this.popups.put(IncludeColumn.class, new DefaultPopUpMenu());
        this.popups.put(ExcludeColumn.class, new DefaultPopUpMenu());
        this.popups.put(IncludeProcedure.class, new DefaultPopUpMenu());
        this.popups.put(ExcludeProcedure.class, new DefaultPopUpMenu());
    }

    private void initListeners() {
        this.reverseEngineeringTree.addTreeSelectionListener(e -> this.treeToolbar.lockButtons());
        this.reverseEngineeringTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ReverseEngineeringTreePanel.this.reverseEngineeringTree.getRowForLocation(e.getX(), e.getY()) == -1) {
                    ReverseEngineeringTreePanel.this.reverseEngineeringTree.setSelectionRow(-1);
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    DefaultPopUpMenu popupMenu;
                    DbImportTreeNode selectedElement;
                    if (ReverseEngineeringTreePanel.this.reverseEngineeringTree.isEditing()) {
                        return;
                    }
                    int row = ReverseEngineeringTreePanel.this.reverseEngineeringTree.getClosestRowForLocation(e.getX(), e.getY());
                    ReverseEngineeringTreePanel.this.reverseEngineeringTree.setSelectionRow(row);
                    if (ReverseEngineeringTreePanel.this.reverseEngineeringTree.getSelectionPath() != null) {
                        selectedElement = ReverseEngineeringTreePanel.this.reverseEngineeringTree.getSelectedNode();
                        popupMenu = (DefaultPopUpMenu)ReverseEngineeringTreePanel.this.popups.get(selectedElement.getUserObject().getClass());
                    } else {
                        selectedElement = ReverseEngineeringTreePanel.this.reverseEngineeringTree.getRootNode();
                        popupMenu = (DefaultPopUpMenu)ReverseEngineeringTreePanel.this.popups.get(ReverseEngineering.class);
                    }
                    if (popupMenu != null) {
                        popupMenu.setProjectController(ReverseEngineeringTreePanel.this.projectController);
                        popupMenu.setSelectedElement(selectedElement);
                        popupMenu.setParentElement((DbImportTreeNode)selectedElement.getParent());
                        popupMenu.setTree(ReverseEngineeringTreePanel.this.reverseEngineeringTree);
                        popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                } else if (ReverseEngineeringTreePanel.this.reverseEngineeringTree.getSelectionPath() != null) {
                    DbImportTreeNode selectedNode = ReverseEngineeringTreePanel.this.reverseEngineeringTree.getSelectedNode();
                    if (selectedNode.isExcludeColumn() || selectedNode.isIncludeColumn()) {
                        DbImportTreeNode expandNode = (DbImportTreeNode)selectedNode.getParent();
                        DbImportTreeNode parentPath = ReverseEngineeringTreePanel.this.dbSchemaTree.findNode(ReverseEngineeringTreePanel.this.dbSchemaTree.getRootNode(), expandNode, 0);
                        if (parentPath != null) {
                            ReverseEngineeringTreePanel.this.dbSchemaTree.expandPath(new TreePath(parentPath.getPath()));
                            ReverseEngineeringTreePanel.this.scrollToNode(ReverseEngineeringTreePanel.this.dbSchemaTree, parentPath);
                        }
                    } else {
                        DbImportTreeNode findNode = ReverseEngineeringTreePanel.this.dbSchemaTree.findNode(ReverseEngineeringTreePanel.this.dbSchemaTree.getRootNode(), selectedNode, 0);
                        if (findNode != null) {
                            ReverseEngineeringTreePanel.this.dbSchemaTree.expandPath(new TreePath(((DbImportTreeNode)findNode.getParent()).getPath()));
                            ReverseEngineeringTreePanel.this.scrollToNode(ReverseEngineeringTreePanel.this.dbSchemaTree, findNode);
                        }
                    }
                }
            }
        });
    }

    private void scrollToNode(JTree tree, DbImportTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        tree.scrollPathToVisible(path);
        DraggableTreePanel parentPanel = (DraggableTreePanel)this.dbSchemaTree.getParent().getParent();
        parentPanel.getHorizontalScrollBar().setValue(0);
    }

    private ReverseEngineering getReverseEngineeringBySelectedMap() {
        DataMap dataMap = this.projectController.getCurrentDataMap();
        return this.projectController.getApplication().getMetaData().get(dataMap, ReverseEngineering.class);
    }

    private void changeIcons() {
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.reverseEngineeringTree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
    }

    public DbImportTree getReverseEngineeringTree() {
        return this.reverseEngineeringTree;
    }

    void setTreeToolbar(TreeToolbarPanel treeToolbar) {
        this.treeToolbar = treeToolbar;
    }
}

