/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks.builder.maven;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.v1.buildspec.tasks.builder.maven.Servers;

public class ServersFluent<A extends ServersFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> configuration;
    private String id;
    private String password;
    private String username;

    public ServersFluent() {
    }

    public ServersFluent(Servers instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Servers instance) {
        Servers servers = instance = instance != null ? instance : new Servers();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withId(instance.getId());
            this.withPassword(instance.getPassword());
            this.withUsername(instance.getUsername());
        }
    }

    public A addToConfiguration(String key, String value) {
        if (this.configuration == null && key != null && value != null) {
            this.configuration = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.configuration.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfiguration(Map<String, String> map) {
        if (this.configuration == null && map != null) {
            this.configuration = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.configuration.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConfiguration(String key) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        if (key != null && this.configuration != null) {
            this.configuration.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConfiguration(Map<String, String> map) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.configuration == null) continue;
                this.configuration.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public <K, V> A withConfiguration(Map<String, String> configuration) {
        this.configuration = configuration == null ? null : new LinkedHashMap<String, String>(configuration);
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)((Object)this);
    }

    public boolean hasId() {
        return this.id != null;
    }

    public String getPassword() {
        return this.password;
    }

    public A withPassword(String password) {
        this.password = password;
        return (A)((Object)this);
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)((Object)this);
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServersFluent that = (ServersFluent)((Object)o);
        if (!Objects.equals(this.configuration, that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        return Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.id, this.password, this.username, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null && !this.configuration.isEmpty()) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username);
        }
        sb.append("}");
        return sb.toString();
    }
}

