/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import org.apache.camel.v1.IntegrationPlatformStatusBuilder;
import org.apache.camel.v1.integrationplatformstatus.Build;
import org.apache.camel.v1.integrationplatformstatus.Conditions;
import org.apache.camel.v1.integrationplatformstatus.Configuration;
import org.apache.camel.v1.integrationplatformstatus.Kamelet;
import org.apache.camel.v1.integrationplatformstatus.Traits;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"build", "cluster", "conditions", "configuration", "info", "kamelet", "observedGeneration", "phase", "profile", "traits", "version"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class IntegrationPlatformStatus
implements Editable<IntegrationPlatformStatusBuilder>,
KubernetesResource {
    @JsonProperty(value="build")
    @JsonPropertyDescription(value="specify how to build the Integration/IntegrationKits")
    @JsonSetter(nulls=Nulls.SKIP)
    private Build build;
    @JsonProperty(value="cluster")
    @JsonPropertyDescription(value="what kind of cluster you're running (ie, plain Kubernetes or OpenShift)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String cluster;
    @JsonProperty(value="conditions")
    @JsonPropertyDescription(value="which are the conditions met (particularly useful when in ERROR phase)")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Conditions> conditions;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Deprecated: Use camel trait (camel.properties) to manage properties Use mount trait (mount.configs) to manage configs Use mount trait (mount.resources) to manage resources Use mount trait (mount.volumes) to manage volumes list of configuration properties to be attached to all the Integration/IntegrationKits built from this IntegrationPlatform")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Configuration> configuration;
    @JsonProperty(value="info")
    @JsonPropertyDescription(value="generic information related to the build of Camel K operator software")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> info;
    @JsonProperty(value="kamelet")
    @JsonPropertyDescription(value="configuration to be executed to all Kamelets controlled by this IntegrationPlatform")
    @JsonSetter(nulls=Nulls.SKIP)
    private Kamelet kamelet;
    @JsonProperty(value="observedGeneration")
    @JsonPropertyDescription(value="ObservedGeneration is the most recent generation observed for this IntegrationPlatform.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long observedGeneration;
    @JsonProperty(value="phase")
    @JsonPropertyDescription(value="defines in what phase the IntegrationPlatform is found")
    @JsonSetter(nulls=Nulls.SKIP)
    private String phase;
    @JsonProperty(value="profile")
    @JsonPropertyDescription(value="the profile you wish to use. It will apply certain traits which are required by the specific profile chosen. It usually relates the Cluster with the optional definition of special profiles (ie, Knative)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String profile;
    @JsonProperty(value="traits")
    @JsonPropertyDescription(value="list of traits to be executed for all the Integration/IntegrationKits built from this IntegrationPlatform")
    @JsonSetter(nulls=Nulls.SKIP)
    private Traits traits;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="the Camel K operator version controlling this IntegrationPlatform")
    @JsonSetter(nulls=Nulls.SKIP)
    private String version;

    public IntegrationPlatformStatusBuilder edit() {
        return new IntegrationPlatformStatusBuilder(this);
    }

    public Build getBuild() {
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public List<Conditions> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Conditions> conditions) {
        this.conditions = conditions;
    }

    public List<Configuration> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(List<Configuration> configuration) {
        this.configuration = configuration;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, String> info) {
        this.info = info;
    }

    public Kamelet getKamelet() {
        return this.kamelet;
    }

    public void setKamelet(Kamelet kamelet) {
        this.kamelet = kamelet;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public Traits getTraits() {
        return this.traits;
    }

    public void setTraits(Traits traits) {
        this.traits = traits;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "IntegrationPlatformStatus(build=" + this.getBuild() + ", cluster=" + this.getCluster() + ", conditions=" + this.getConditions() + ", configuration=" + this.getConfiguration() + ", info=" + this.getInfo() + ", kamelet=" + this.getKamelet() + ", observedGeneration=" + this.getObservedGeneration() + ", phase=" + this.getPhase() + ", profile=" + this.getProfile() + ", traits=" + this.getTraits() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegrationPlatformStatus)) {
            return false;
        }
        IntegrationPlatformStatus other = (IntegrationPlatformStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$observedGeneration = this.getObservedGeneration();
        Long other$observedGeneration = other.getObservedGeneration();
        if (this$observedGeneration == null ? other$observedGeneration != null : !((Object)this$observedGeneration).equals(other$observedGeneration)) {
            return false;
        }
        Build this$build = this.getBuild();
        Build other$build = other.getBuild();
        if (this$build == null ? other$build != null : !((Object)this$build).equals(other$build)) {
            return false;
        }
        String this$cluster = this.getCluster();
        String other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
            return false;
        }
        List<Conditions> this$conditions = this.getConditions();
        List<Conditions> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        List<Configuration> this$configuration = this.getConfiguration();
        List<Configuration> other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Map<String, String> this$info = this.getInfo();
        Map<String, String> other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        Kamelet this$kamelet = this.getKamelet();
        Kamelet other$kamelet = other.getKamelet();
        if (this$kamelet == null ? other$kamelet != null : !((Object)this$kamelet).equals(other$kamelet)) {
            return false;
        }
        String this$phase = this.getPhase();
        String other$phase = other.getPhase();
        if (this$phase == null ? other$phase != null : !this$phase.equals(other$phase)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        Traits this$traits = this.getTraits();
        Traits other$traits = other.getTraits();
        if (this$traits == null ? other$traits != null : !((Object)this$traits).equals(other$traits)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntegrationPlatformStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $observedGeneration = this.getObservedGeneration();
        result = result * 59 + ($observedGeneration == null ? 43 : ((Object)$observedGeneration).hashCode());
        Build $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        String $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
        List<Conditions> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        List<Configuration> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Map<String, String> $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        Kamelet $kamelet = this.getKamelet();
        result = result * 59 + ($kamelet == null ? 43 : ((Object)$kamelet).hashCode());
        String $phase = this.getPhase();
        result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        Traits $traits = this.getTraits();
        result = result * 59 + ($traits == null ? 43 : ((Object)$traits).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

