/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.scaleio.SecretRef;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fsType", "gateway", "protectionDomain", "readOnly", "secretRef", "sslEnabled", "storageMode", "storagePool", "system", "volumeName"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ScaleIO
implements KubernetesResource {
    @JsonProperty(value="fsType")
    @JsonPropertyDescription(value="fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Default is \"xfs\".")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsType;
    @JsonProperty(value="gateway")
    @Required
    @JsonPropertyDescription(value="gateway is the host address of the ScaleIO API Gateway.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String gateway;
    @JsonProperty(value="protectionDomain")
    @JsonPropertyDescription(value="protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String protectionDomain;
    @JsonProperty(value="readOnly")
    @JsonPropertyDescription(value="readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnly;
    @JsonProperty(value="secretRef")
    @Required
    @JsonPropertyDescription(value="secretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SecretRef secretRef;
    @JsonProperty(value="sslEnabled")
    @JsonPropertyDescription(value="sslEnabled Flag enable/disable SSL communication with Gateway, default false")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean sslEnabled;
    @JsonProperty(value="storageMode")
    @JsonPropertyDescription(value="storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String storageMode;
    @JsonProperty(value="storagePool")
    @JsonPropertyDescription(value="storagePool is the ScaleIO Storage Pool associated with the protection domain.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String storagePool;
    @JsonProperty(value="system")
    @Required
    @JsonPropertyDescription(value="system is the name of the storage system as configured in ScaleIO.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String system;
    @JsonProperty(value="volumeName")
    @JsonPropertyDescription(value="volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String volumeName;

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public void setProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public SecretRef getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(SecretRef secretRef) {
        this.secretRef = secretRef;
    }

    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public String getStorageMode() {
        return this.storageMode;
    }

    public void setStorageMode(String storageMode) {
        this.storageMode = storageMode;
    }

    public String getStoragePool() {
        return this.storagePool;
    }

    public void setStoragePool(String storagePool) {
        this.storagePool = storagePool;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public String toString() {
        return "ScaleIO(fsType=" + this.getFsType() + ", gateway=" + this.getGateway() + ", protectionDomain=" + this.getProtectionDomain() + ", readOnly=" + this.getReadOnly() + ", secretRef=" + this.getSecretRef() + ", sslEnabled=" + this.getSslEnabled() + ", storageMode=" + this.getStorageMode() + ", storagePool=" + this.getStoragePool() + ", system=" + this.getSystem() + ", volumeName=" + this.getVolumeName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScaleIO)) {
            return false;
        }
        ScaleIO other = (ScaleIO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        Boolean this$sslEnabled = this.getSslEnabled();
        Boolean other$sslEnabled = other.getSslEnabled();
        if (this$sslEnabled == null ? other$sslEnabled != null : !((Object)this$sslEnabled).equals(other$sslEnabled)) {
            return false;
        }
        String this$fsType = this.getFsType();
        String other$fsType = other.getFsType();
        if (this$fsType == null ? other$fsType != null : !this$fsType.equals(other$fsType)) {
            return false;
        }
        String this$gateway = this.getGateway();
        String other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway)) {
            return false;
        }
        String this$protectionDomain = this.getProtectionDomain();
        String other$protectionDomain = other.getProtectionDomain();
        if (this$protectionDomain == null ? other$protectionDomain != null : !this$protectionDomain.equals(other$protectionDomain)) {
            return false;
        }
        SecretRef this$secretRef = this.getSecretRef();
        SecretRef other$secretRef = other.getSecretRef();
        if (this$secretRef == null ? other$secretRef != null : !((Object)this$secretRef).equals(other$secretRef)) {
            return false;
        }
        String this$storageMode = this.getStorageMode();
        String other$storageMode = other.getStorageMode();
        if (this$storageMode == null ? other$storageMode != null : !this$storageMode.equals(other$storageMode)) {
            return false;
        }
        String this$storagePool = this.getStoragePool();
        String other$storagePool = other.getStoragePool();
        if (this$storagePool == null ? other$storagePool != null : !this$storagePool.equals(other$storagePool)) {
            return false;
        }
        String this$system = this.getSystem();
        String other$system = other.getSystem();
        if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
            return false;
        }
        String this$volumeName = this.getVolumeName();
        String other$volumeName = other.getVolumeName();
        return !(this$volumeName == null ? other$volumeName != null : !this$volumeName.equals(other$volumeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScaleIO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        Boolean $sslEnabled = this.getSslEnabled();
        result = result * 59 + ($sslEnabled == null ? 43 : ((Object)$sslEnabled).hashCode());
        String $fsType = this.getFsType();
        result = result * 59 + ($fsType == null ? 43 : $fsType.hashCode());
        String $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        String $protectionDomain = this.getProtectionDomain();
        result = result * 59 + ($protectionDomain == null ? 43 : $protectionDomain.hashCode());
        SecretRef $secretRef = this.getSecretRef();
        result = result * 59 + ($secretRef == null ? 43 : ((Object)$secretRef).hashCode());
        String $storageMode = this.getStorageMode();
        result = result * 59 + ($storageMode == null ? 43 : $storageMode.hashCode());
        String $storagePool = this.getStoragePool();
        result = result * 59 + ($storagePool == null ? 43 : $storagePool.hashCode());
        String $system = this.getSystem();
        result = result * 59 + ($system == null ? 43 : $system.hashCode());
        String $volumeName = this.getVolumeName();
        result = result * 59 + ($volumeName == null ? 43 : $volumeName.hashCode());
        return result;
    }
}

