/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Objects;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.trait.Changeable;
import org.apache.brooklyn.util.collections.CollectionFunctionals;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="PropagateToMembers", description="Propagates sensors from entity to members")
public class PropagateToMembers
extends AbstractEnricher
implements SensorEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(PropagateToMembers.class);
    @SetFromFlag(value="propagating")
    public static final ConfigKey<Collection<? extends Sensor<?>>> PROPAGATING = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<Collection<? extends Sensor<?>>>(){}).name("enricher.propagating.inclusions")).description("Collection of sensors to propagate to members")).constraint(Predicates.and((Predicate)Predicates.notNull(), (Predicate)CollectionFunctionals.notEmpty()))).build();

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        if (!(entity instanceof Group)) {
            throw new IllegalStateException("Only valid for groups");
        }
        this.subscriptions().subscribe((Entity)entity, Changeable.MEMBER_ADDED, new PropagationSubscriber(this));
        this.getConfig(PROPAGATING).forEach(sensor -> this.subscriptions().subscribe((Entity)entity, sensor, this));
    }

    public void onEvent(SensorEvent<Object> event) {
        if (this.getConfig(PROPAGATING).contains(event.getSensor())) {
            LOG.debug("Propagating updated {}: {}", (Object)event.getSensor(), event.getValue());
            ((Group)this.entity).getMembers().forEach(member -> {
                if (!Objects.isNull(event.getValue())) {
                    member.sensors().set((AttributeSensor)event.getSensor(), event.getValue());
                }
            });
        }
    }

    static class PropagationSubscriber
    implements SensorEventListener<Entity> {
        private final PropagateToMembers adjunct;

        public PropagationSubscriber(PropagateToMembers adjunct) {
            this.adjunct = adjunct;
        }

        public void onEvent(SensorEvent<Entity> event) {
            LOG.debug("Propagating '{}' to a new member '{}' ", this.adjunct.getConfig(PROPAGATING), event.getValue());
            this.adjunct.getConfig(PROPAGATING).forEach(sensor -> {
                AttributeSensor attributeSensor = (AttributeSensor)sensor;
                Object value = this.adjunct.entity.getAttribute(attributeSensor);
                if (!Objects.isNull(value)) {
                    LOG.debug("Propagating initial {}: {}", (Object)attributeSensor, value);
                    ((Entity)event.getValue()).sensors().set(attributeSensor, value);
                }
            });
        }
    }
}

