/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.entity.group;

import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityAsserts;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.mgmt.rebind.RebindOptions;
import org.apache.brooklyn.core.mgmt.rebind.RebindTestFixtureWithApp;
import org.apache.brooklyn.entity.software.base.EmptySoftwareProcess;
import org.testng.annotations.Test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public class DynamicClusterRebindTest extends RebindTestFixtureWithApp {

    // See https://issues.apache.org/jira/browse/BROOKLYN-396
    @Test(groups = "Integration")
    public void testResizeAfterRebind() throws Exception {
        DynamicCluster cluster = app().createAndManageChild(EntitySpec.create(DynamicCluster.class)
                .configure(DynamicCluster.INITIAL_SIZE, 3)
                .configure(DynamicCluster.MEMBER_SPEC, EntitySpec.create(EmptySoftwareProcess.class)));
        app().start(ImmutableList.of(app().newLocalhostProvisioningLocation()));
        EntityAsserts.assertAttributeEquals(cluster, DynamicCluster.GROUP_SIZE, 3);

        rebind(RebindOptions.create().terminateOrigManagementContext(true));

        cluster = Iterables.getOnlyElement(Entities.descendantsAndSelf(newApp, DynamicCluster.class));
        cluster.resize(5);
        EntityAsserts.assertAttributeEquals(cluster, DynamicCluster.GROUP_SIZE, 5);
        EntityAsserts.assertAttributeEquals(cluster, Attributes.SERVICE_STATE_ACTUAL, Lifecycle.RUNNING);
    }
}
