/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.mysql;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.objs.HasShortName;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.database.DatastoreMixins;
import org.apache.brooklyn.entity.database.mysql.MySqlNodeImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="MySql Node", description="MySql is an open source relational database management system (RDBMS)", iconUrl="classpath:///mysql-logo-110x57.png")
@ImplementedBy(value=MySqlNodeImpl.class)
public interface MySqlNode
extends SoftwareProcess,
HasShortName,
DatastoreMixins.DatastoreCommon {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"5.6.26");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey((AttributeSensorAndConfigKey)Attributes.DOWNLOAD_URL, "http://dev.mysql.com/get/Downloads/MySQL-${driver.majorVersion}/mysql-${version}-${driver.osTag}.tar.gz");
    @SetFromFlag(value="port")
    public static final PortAttributeSensorAndConfigKey MYSQL_PORT = new PortAttributeSensorAndConfigKey("mysql.port", "MySQL port", (Object)PortRanges.fromString((String)"3306, 13306+"));
    @SetFromFlag(value="dataDir")
    public static final ConfigKey<String> DATA_DIR = ConfigKeys.newStringConfigKey((String)"mysql.datadir", (String)"Directory for writing data files", null);
    @SetFromFlag(value="serverConf")
    public static final MapConfigKey<Object> MYSQL_SERVER_CONF = new MapConfigKey(Object.class, "mysql.server.conf", "Configuration options for mysqld (appended to mysql.conf in the format 'key = value')");
    public static final ConfigKey<Object> MYSQL_SERVER_CONF_LOWER_CASE_TABLE_NAMES = MYSQL_SERVER_CONF.subKey("lower_case_table_names", "See MySQL guide. Set 1 to ignore case in table names (useful for OS portability)");
    @SetFromFlag(value="serverId")
    public static final ConfigKey<Integer> MYSQL_SERVER_ID = ConfigKeys.newIntegerConfigKey((String)"mysql.server_id", (String)"Corresponds to server_id option", (Integer)0);
    @SetFromFlag(value="user")
    public static final AttributeSensor<String> USER = Sensors.newStringSensor((String)"mysql.user", (String)"Database admin user (default is 'root')");
    @SetFromFlag(value="password")
    public static final BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey PASSWORD = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("mysql.password", "Database admin password (or randomly generated if not set)", null);
    @SetFromFlag(value="socketUid")
    public static final BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey SOCKET_UID = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("mysql.socketUid", "Socket uid, for use in file /tmp/mysql.sock.<uid>.3306 (or randomly generated if not set)", null);
    @SetFromFlag(value="generalLog")
    public static final ConfigKey<Boolean> GENERAL_LOG = ConfigKeys.newBooleanConfigKey((String)"mysql.general_log", (String)"Enable general_log option in mysql.conf", (Boolean)false);
    @SetFromFlag(value="configurationTemplateUrl")
    public static final BasicAttributeSensorAndConfigKey<String> TEMPLATE_CONFIGURATION_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("mysql.template.configuration.url", "Template file (in freemarker format) for the mysql.conf file. The default respects other config options such as 'mysql.general_log'", "classpath://org/apache/brooklyn/entity/database/mysql/mysql.conf");
    public static final AttributeSensor<Double> QUERIES_PER_SECOND_FROM_MYSQL = Sensors.newDoubleSensor((String)"mysql.queries.perSec.fromMysql");
    public static final Effector<Void> EXPORT_DUMP = ExportDumpEffector.EXPORT_DUMP;
    public static final Effector<Void> IMPORT_DUMP = ImportDumpEffector.IMPORT_DUMP;
    public static final Effector<Void> CHANGE_PASSWORD = ChangePasswordEffector.CHANGE_PASSWORD;

    @org.apache.brooklyn.core.annotation.Effector(description="Execute SQL script on the node as the root user")
    public String executeScript(@EffectorParam(name="commands") String var1);

    public static interface ChangePasswordEffector {
        public static final ConfigKey<String> PASSWORD = ConfigKeys.newStringConfigKey((String)"password", (String)"New password to set");
        public static final Effector<Void> CHANGE_PASSWORD = Effectors.effector(Void.class, (String)"change_password").description("Change the mysql root password").parameter(PASSWORD).buildAbstract();
    }

    public static interface ImportDumpEffector {
        public static final ConfigKey<String> PATH = ConfigKeys.newStringConfigKey((String)"path", (String)"Path to a file with SQL statements to import as the root user");
        public static final Effector<Void> IMPORT_DUMP = Effectors.effector(Void.class, (String)"import_dump").description("Runs the sql statements in the file as the root user").parameter(PATH).buildAbstract();
    }

    public static interface ExportDumpEffector {
        public static final ConfigKey<String> PATH = ConfigKeys.newStringConfigKey((String)"path", (String)"Where to export the dump to. Resolved against runtime directory if relative.", (String)"dump.sql");
        public static final ConfigKey<String> ADDITIONAL_OPTIONS = ConfigKeys.newStringConfigKey((String)"additionalOptions", (String)"Additional command line options to pass to mysqldump");
        public static final Effector<Void> EXPORT_DUMP = Effectors.effector(Void.class, (String)"export_dump").description("Invokes mysqldump against the node").parameter(PATH).parameter(ADDITIONAL_OPTIONS).buildAbstract();
    }
}

