/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;

public class Event
implements Comparable<Event> {
    private final String id;
    private final String account;
    private final String description;
    private final Date created;
    private final String domain;
    private final String domainId;
    private final String level;
    private final String parentId;
    private final String state;
    private final String type;
    private final String username;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromEvent(this);
    }

    @ConstructorProperties(value={"id", "account", "description", "created", "domain", "domainId", "level", "parentId", "state", "type", "username"})
    protected Event(String id, @Nullable String account, @Nullable String description, @Nullable Date created, @Nullable String domain, @Nullable String domainId, @Nullable String level, @Nullable String parentId, @Nullable String state, @Nullable String type, @Nullable String username) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.account = account;
        this.description = description;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.level = level;
        this.parentId = parentId;
        this.state = state;
        this.type = type;
        this.username = username;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getLevel() {
        return this.level;
    }

    @Nullable
    public String getParentId() {
        return this.parentId;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.account, this.description, this.created, this.domain, this.domainId, this.level, this.parentId, this.state, this.type, this.username});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Event that = (Event)Event.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.level, (Object)that.level) && Objects.equal((Object)this.parentId, (Object)that.parentId) && Objects.equal((Object)this.state, (Object)that.state) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.username, (Object)that.username);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("account", (Object)this.account).add("description", (Object)this.description).add("created", (Object)this.created).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("level", (Object)this.level).add("parentId", (Object)this.parentId).add("state", (Object)this.state).add("type", (Object)this.type).add("username", (Object)this.username);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Event other) {
        return this.id.compareTo(other.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String account;
        protected String description;
        protected Date created;
        protected String domain;
        protected String domainId;
        protected String level;
        protected String parentId;
        protected String state;
        protected String type;
        protected String username;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T level(String level) {
            this.level = level;
            return this.self();
        }

        public T parentId(String parentId) {
            this.parentId = parentId;
            return this.self();
        }

        public T state(String state) {
            this.state = state;
            return this.self();
        }

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public T username(String username) {
            this.username = username;
            return this.self();
        }

        public Event build() {
            return new Event(this.id, this.account, this.description, this.created, this.domain, this.domainId, this.level, this.parentId, this.state, this.type, this.username);
        }

        public T fromEvent(Event in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).account(in.getAccount())).description(in.getDescription())).created(in.getCreated())).domain(in.getDomain())).domainId(in.getDomainId())).level(in.getLevel())).parentId(in.getParentId())).state(in.getState())).type(in.getType())).username(in.getUsername());
        }
    }
}

