/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.util.Throwables2;

public class Suppliers2 {
    public static <K, V> Supplier<V> getLastValueInMap(final Supplier<Map<K, Supplier<V>>> input) {
        return new Supplier<V>(){

            public V get() {
                Supplier last = (Supplier)Iterables.getLast(((Map)input.get()).values());
                return last != null ? last.get() : null;
            }

            public String toString() {
                return "getLastValueInMap()";
            }
        };
    }

    public static <K, V> Supplier<V> getValueInMapOrNull(final Supplier<Map<K, Supplier<V>>> input, final K keyValue) {
        return new Supplier<V>(){

            public V get() {
                Map map = (Map)input.get();
                return map.containsKey(keyValue) ? ((Supplier)map.get(keyValue)).get() : null;
            }

            public String toString() {
                return String.format("getValueInMapOrNull('%1$s')", keyValue);
            }
        };
    }

    public static <X> Function<X, Supplier<X>> ofInstanceFunction() {
        return new Function<X, Supplier<X>>(){

            public Supplier<X> apply(X arg0) {
                return Suppliers.ofInstance(arg0);
            }

            public String toString() {
                return "Suppliers.ofInstance()";
            }
        };
    }

    @Beta
    public static <T> Supplier<T> or(final Supplier<T> unlessNull, final Supplier<T> fallback) {
        return new Supplier<T>(){

            public T get() {
                Object val = unlessNull.get();
                if (val != null) {
                    return val;
                }
                return fallback.get();
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("unlessNull", (Object)unlessNull).add("fallback", (Object)fallback).toString();
            }
        };
    }

    @Beta
    public static <T, X extends Throwable> Supplier<T> onThrowable(final Supplier<T> unlessThrowable, final Class<X> throwable, final Supplier<T> fallback) {
        return new Supplier<T>(){

            public T get() {
                try {
                    return unlessThrowable.get();
                }
                catch (Throwable t) {
                    if (Throwables2.getFirstThrowableOfType(t, throwable) != null) {
                        return fallback.get();
                    }
                    throw Throwables.propagate((Throwable)t);
                }
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("unlessThrowable", (Object)unlessThrowable).add("throwable", (Object)throwable.getSimpleName()).add("fallback", (Object)fallback).toString();
            }
        };
    }
}

