/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.entity.group.DynamicFabricImpl;
import org.apache.brooklyn.entity.group.Fabric;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=DynamicFabricImpl.class)
public interface DynamicFabric
extends AbstractGroup,
Startable,
Fabric {
    public static final ConfigKey<Boolean> INCLUDE_INITIAL_CHILDREN = ConfigKeys.newBooleanConfigKey("includeInitialChildren", "Whether to include the initial children when handing out the locations to new members (i.e. if true, these children will each be given a location (round-robin), rather than creating new members; if false then the children will be given just the first location (if any), and new members will be created dynamically for each given location).", true);
    @CatalogConfig(label="Member spec")
    @SetFromFlag(value="memberSpec")
    public static final ConfigKey<EntitySpec<?>> MEMBER_SPEC = ConfigKeys.newConfigKey(new TypeToken<EntitySpec<?>>(){}, "dynamicfabric.memberspec", "Entity spec for creating new members (one per location)", null);
    @SetFromFlag(value="firstMemberSpec")
    public static final ConfigKey<EntitySpec<?>> FIRST_MEMBER_SPEC = ConfigKeys.newConfigKey(new TypeToken<EntitySpec<?>>(){}, "dynamicfabric.firstmemberspec", "Entity spec for the first member", null);
    @SetFromFlag(value="displayNamePrefix")
    public static final ConfigKey<String> DISPLAY_NAME_PREFIX = ConfigKeys.newStringConfigKey("dynamicfabric.displayNamePrefix", "Display name prefix, for created children");
    @SetFromFlag(value="displayNameSuffix")
    public static final ConfigKey<String> DISPLAY_NAME_SUFFIX = ConfigKeys.newStringConfigKey("dynamicfabric.displayNameSuffix", "Display name suffix, for created children");
    @SetFromFlag(value="customChildFlags")
    public static final MapConfigKey<Object> CUSTOM_CHILD_FLAGS = new MapConfigKey<Object>(Object.class, "dynamicfabric.customChildFlags", "Additional flags to be passed to children when they are being created", (Map<String, Object>)ImmutableMap.of());
    public static final AttributeSensor<Integer> FABRIC_SIZE = Sensors.newIntegerSensor("fabric.size", "Fabric size");
    public static final AttributeSensor<Lifecycle> SERVICE_STATE_ACTUAL = Attributes.SERVICE_STATE_ACTUAL;

    public void setMemberSpec(EntitySpec<?> var1);

    public Integer getFabricSize();
}

