/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.IOException;
import org.apache.hadoop.hdfs.server.common.UpgradeObjectCollection;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.common.Upgradeable;

public abstract class UpgradeObject
implements Upgradeable {
    protected short status;

    @Override
    public short getUpgradeStatus() {
        return this.status;
    }

    @Override
    public String getDescription() {
        return "Upgrade object for " + (Object)((Object)this.getType()) + " layout version " + this.getVersion();
    }

    @Override
    public UpgradeStatusReport getUpgradeStatusReport(boolean details) throws IOException {
        return new UpgradeStatusReport(this.getVersion(), this.getUpgradeStatus(), false);
    }

    @Override
    public int compareTo(Upgradeable o) {
        if (this.getVersion() != o.getVersion()) {
            return this.getVersion() > o.getVersion() ? -1 : 1;
        }
        int res = this.getType().toString().compareTo(o.getType().toString());
        if (res != 0) {
            return res;
        }
        return this.getClass().getCanonicalName().compareTo(o.getClass().getCanonicalName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof UpgradeObject)) {
            return false;
        }
        return this.compareTo((UpgradeObject)o) == 0;
    }

    public int hashCode() {
        return new UpgradeObjectCollection.UOSignature(this).hashCode();
    }
}

