/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xcollator;

import java.util.ArrayList;
import java.util.Locale;

public final class LocaleUtility {
    private static final char IETF_SEPARATOR = '-';
    private static final char LOCALE_SEPARATOR = '_';
    private static final String EMPTY_STRING = "";

    private static final String IETFToLocaleLang(String string) {
        return string != null ? string.replace('-', '_') : null;
    }

    public static final Locale IETFToValidLocale(String string, Locale[] localeArray, ArrayList arrayList) {
        if (localeArray == null) {
            return null;
        }
        if (string == null) {
            return Locale.getDefault();
        }
        if (!LocaleUtility.isIETFLangValid(string)) {
            return Locale.getDefault();
        }
        String string2 = LocaleUtility.IETFToLocaleLang(string);
        Locale locale = LocaleUtility.stringToLocale(string2, localeArray, arrayList);
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    static final Locale stringToLocale(String string, Locale[] localeArray, ArrayList arrayList) {
        if (localeArray == null) {
            return null;
        }
        String string2 = string;
        int n = -1;
        n = arrayList.indexOf(string2);
        if (n > -1) {
            return localeArray[n];
        }
        String[] stringArray = LocaleUtility.splitLangName(string2, '_');
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        if (string5.length() != 0 && (n = arrayList.indexOf(string2 = string4.length() != 0 ? string3 + '_' + string4 : string3)) > -1) {
            return localeArray[n];
        }
        if (string4.length() != 0 && (n = arrayList.indexOf(string2 = string5.length() != 0 ? string3 + '_' + string5 : string3)) > -1) {
            return localeArray[n];
        }
        string2 = string3;
        n = arrayList.indexOf(string2);
        if (n > -1) {
            return localeArray[n];
        }
        return null;
    }

    static boolean isIETFLangValid(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (string.charAt(0) == '-') {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static String[] splitLangName(String string, char c) {
        String string2 = EMPTY_STRING;
        String string3 = EMPTY_STRING;
        String string4 = EMPTY_STRING;
        int n = string.indexOf(c);
        if (n < 0) {
            string2 = string;
        } else {
            int n2;
            string2 = string.substring(0, n);
            if ((n2 = string.indexOf(c, ++n)) < 0) {
                string3 = string.substring(n);
            } else {
                string3 = string.substring(n, n2);
                string4 = string.substring(n2 + 1);
            }
        }
        string2 = string2.length() == 2 ? string2.toLowerCase() : EMPTY_STRING;
        string3 = string3.length() == 2 ? string3.toUpperCase() : EMPTY_STRING;
        string4 = string4.length() > 0 && (string2.length() == 2 || string3.length() == 2) ? string4.toUpperCase() : EMPTY_STRING;
        String[] stringArray = new String[]{string2, string3, string4};
        return stringArray;
    }

    static int compareLangCountryVariant(String string, String string2) {
        int n;
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            n = 4;
        } else {
            String string3;
            String string4;
            String string5;
            String string6;
            String[] stringArray;
            String string7;
            string = LocaleUtility.IETFToLocaleLang(string);
            string2 = LocaleUtility.IETFToLocaleLang(string2);
            String[] stringArray2 = LocaleUtility.splitLangName(string, '_');
            String string8 = stringArray2[0];
            n = !string8.equals(string7 = (stringArray = LocaleUtility.splitLangName(string2, '_'))[0]) ? 3 : (!(string6 = stringArray2[1]).equals(string5 = stringArray[1]) ? 2 : (!(string4 = stringArray2[2]).equals(string3 = stringArray[2]) ? 1 : 0));
        }
        return n;
    }
}

