/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax.serializer;

import com.ibm.xml.xlxp.api.stax.serializer.ASCIIEncoding;
import com.ibm.xml.xlxp.api.stax.serializer.GenericEncoding;
import com.ibm.xml.xlxp.api.stax.serializer.Latin1Encoding;
import com.ibm.xml.xlxp.api.stax.serializer.UTF8Encoding;
import com.ibm.xml.xlxp.api.stax.serializer.UTFEncoding;
import com.ibm.xml.xlxp.api.stax.serializer.Windows125XEncoding;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public abstract class Encoding {
    private static final ThreadLocal fEncodings = new ThreadLocal(){

        public Object initialValue() {
            return new Hashtable();
        }
    };
    private static final Encoding fgUTF8Encoding = new UTF8Encoding();
    protected final String encoding;

    public static final boolean contains(int n, int[] nArray) {
        int n2;
        int n3 = 0;
        while ((n2 = nArray[n3]) != n) {
            n3 = n < n2 ? 2 * n3 + 1 : 2 * n3 + 2;
            if (n3 < nArray.length) continue;
            return false;
        }
        return true;
    }

    public static final int find(int n, int[] nArray) {
        int n2;
        int n3 = 0;
        while ((n2 = nArray[n3]) != n) {
            n3 = n < n2 ? 2 * n3 + 1 : 2 * n3 + 2;
            if (n3 < nArray.length) continue;
            return -1;
        }
        return n3;
    }

    private static final Hashtable getEncodings() {
        return (Hashtable)fEncodings.get();
    }

    public static Encoding getUTF8Encoding() {
        return fgUTF8Encoding;
    }

    public static Encoding getEncoding(int n, String string) throws UnsupportedEncodingException {
        if (n == 0) {
            return fgUTF8Encoding;
        }
        Hashtable hashtable = Encoding.getEncodings();
        Encoding encoding = (Encoding)hashtable.get(string);
        if (encoding == null) {
            switch (n) {
                case 1: {
                    encoding = new ASCIIEncoding();
                    break;
                }
                case 2: {
                    encoding = new Latin1Encoding();
                    break;
                }
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: {
                    encoding = new Windows125XEncoding(n, string);
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    encoding = new UTFEncoding(string);
                    break;
                }
                default: {
                    encoding = new GenericEncoding(string);
                }
            }
            hashtable.put(string, encoding);
        }
        return encoding;
    }

    public static int toCodePoint(char c, char c2) {
        return (c << 10) + c2 + 65536 - 0x3600000 - 56320;
    }

    public Encoding(String string) {
        this.encoding = string;
    }

    public abstract boolean isEncodable(char var1);

    public abstract boolean isEncodable(char var1, char var2);
}

