/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.ForEachInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.MatchInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xylem.types.StreamType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ForEachEvaluator
extends PartialEvaluator {
    public static final int s_loopUnrollThreshold = 10;

    protected static boolean checkInstruction(PartialInformationCollector partialInformationCollector, Instruction instruction) {
        if (instruction instanceof ChooseInstruction) {
            return ForEachEvaluator.checkChooseInstruction(partialInformationCollector, (ChooseInstruction)instruction);
        }
        if (instruction instanceof MatchInstruction) {
            return ForEachEvaluator.checkMatchInstruction(partialInformationCollector, (MatchInstruction)instruction);
        }
        if (instruction instanceof StreamInstruction) {
            return ForEachEvaluator.checkStreamInstruction(partialInformationCollector, (StreamInstruction)instruction);
        }
        return false;
    }

    protected static boolean checkStreamInstruction(PartialInformationCollector partialInformationCollector, StreamInstruction streamInstruction) {
        int n = streamInstruction.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            Instruction instruction = streamInstruction.getChildInstruction(i);
            if (!(partialInformationCollector.resolveType(instruction) instanceof StreamType)) continue;
            return false;
        }
        return true;
    }

    protected static boolean checkChooseInstruction(PartialInformationCollector partialInformationCollector, ChooseInstruction chooseInstruction) {
        BindingEnvironment bindingEnvironment = partialInformationCollector.getCurrentBindingEnvironment();
        for (ChooseInstruction.Case object : chooseInstruction.m_cases) {
            Instruction instruction = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(object.getHandler()), bindingEnvironment);
            if (ForEachEvaluator.checkInstruction(partialInformationCollector, instruction)) continue;
            return false;
        }
        Instruction instruction = chooseInstruction.getDefaultHandler();
        if (instruction != null) {
            Instruction instruction2 = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(instruction), bindingEnvironment);
            return ForEachEvaluator.checkInstruction(partialInformationCollector, instruction2);
        }
        return true;
    }

    protected static boolean checkMatchInstruction(PartialInformationCollector partialInformationCollector, MatchInstruction matchInstruction) {
        Object object;
        BindingEnvironment bindingEnvironment = partialInformationCollector.getCurrentBindingEnvironment();
        int n = matchInstruction.getMatches().length;
        for (int i = 0; i < n; ++i) {
            object = matchInstruction.getMatches()[i];
            Instruction instruction = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(((MatchInstruction.Match)object).getHandler()), bindingEnvironment);
            if (ForEachEvaluator.checkInstruction(partialInformationCollector, instruction)) continue;
            return false;
        }
        Instruction instruction = matchInstruction.getDefault();
        if (instruction != null) {
            object = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(instruction), bindingEnvironment);
            return ForEachEvaluator.checkInstruction(partialInformationCollector, (Instruction)object);
        }
        return true;
    }

    protected static void implantForEach(ForEachInstruction forEachInstruction, Instruction instruction, int n, HashMap hashMap) {
        Instruction instruction2 = instruction.getChildInstruction(n);
        if (instruction2 instanceof LetInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction2;
            hashMap.put(letInstruction.getVariable(), letInstruction);
            ForEachEvaluator.implantForEach(forEachInstruction, instruction2, 1, hashMap);
        } else if (instruction2 instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
            LetInstruction letInstruction = (LetInstruction)hashMap.get(identifierInstruction.getVariable());
            if (letInstruction != null) {
                instruction.setChildInstruction(n, letInstruction.getValue().cloneReduced());
                ForEachEvaluator.implantForEach(forEachInstruction, instruction, n, hashMap);
            } else {
                ForEachInstruction forEachInstruction2 = (ForEachInstruction)forEachInstruction.cloneWithNewNames();
                Object object = forEachInstruction2.getVarName();
                instruction.setChildInstruction(n, new LetInstruction(object, identifierInstruction, forEachInstruction2.getBody()));
            }
        } else if (instruction2 instanceof ChooseInstruction) {
            ChooseInstruction chooseInstruction = (ChooseInstruction)instruction2;
            int n2 = chooseInstruction.m_cases.length;
            Instruction instruction3 = chooseInstruction.getDefaultHandler();
            int n3 = 1;
            if (instruction3 != null) {
                ++n3;
                ForEachEvaluator.implantForEach(forEachInstruction, chooseInstruction, 0, hashMap);
            }
            for (int i = 0; i < n2; ++i) {
                ForEachEvaluator.implantForEach(forEachInstruction, chooseInstruction, n3, hashMap);
                n3 += 2;
            }
        } else if (instruction2 instanceof MatchInstruction) {
            MatchInstruction matchInstruction = (MatchInstruction)instruction2;
            int n4 = matchInstruction.getMatches().length;
            Instruction instruction4 = matchInstruction.getDefault();
            int n5 = 1;
            if (instruction4 != null) {
                ++n5;
                ForEachEvaluator.implantForEach(forEachInstruction, matchInstruction, 0, hashMap);
            }
            for (int i = 0; i < n4; ++i) {
                ForEachEvaluator.implantForEach(forEachInstruction, matchInstruction, n5, hashMap);
                ++n5;
            }
        } else if (instruction2 instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction2;
            ForEachInstruction forEachInstruction3 = (ForEachInstruction)forEachInstruction.cloneWithNewNames();
            Integer n6 = ReductionHelper.generateIntermediateIdentifier2();
            forEachInstruction3.setSource(new IdentifierInstruction(n6));
            instruction.setChildInstruction(n, new LetInstruction(n6, streamInstruction, forEachInstruction3));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected static void unrollLoop(PartialInformationCollector partialInformationCollector, Instruction instruction, String string, StreamInstruction streamInstruction, LetInstruction letInstruction, LetChainManager letChainManager, ArrayList arrayList) {
        int n = streamInstruction.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            Instruction instruction2 = streamInstruction.getChildInstruction(i);
            if (partialInformationCollector.resolveType(instruction2) instanceof StreamType) {
                ForEachEvaluator.unrollLoop(partialInformationCollector, instruction, string, (StreamInstruction)letChainManager.lookupBinding(instruction2), letInstruction, letChainManager, arrayList);
                continue;
            }
            HashMap<String, IdentifierInstruction> hashMap = new HashMap<String, IdentifierInstruction>();
            IdentifierInstruction identifierInstruction = letChainManager.insertBody(instruction2.cloneWithNewNames(), letInstruction);
            hashMap.put(string, identifierInstruction);
            Instruction instruction3 = instruction.assignNewNames(hashMap);
            arrayList.add(letChainManager.insertBody(instruction3, letInstruction));
        }
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        HashSet hashSet;
        ForEachInstruction forEachInstruction;
        block9: {
            TypeEnvironment typeEnvironment;
            Object object;
            Instruction instruction2;
            block10: {
                forEachInstruction = (ForEachInstruction)instruction;
                partialInformationCollector.partiallyEvaluate(forEachInstruction.getSource(), letChainManager);
                instruction2 = letChainManager.lookupBinding(forEachInstruction.getSource());
                if (forEachInstruction.getIndexVar() != null && !(object = forEachInstruction.getBody().accumulateFreeBindingsInOrder(partialInformationCollector.getCurrentBindingEnvironment())).contains(forEachInstruction.getIndexBinding())) {
                    forEachInstruction.setIndexVar(null);
                }
                object = partialInformationCollector.getCurrentBindingEnvironment();
                typeEnvironment = partialInformationCollector.getCurrentTypeEnvironment();
                if (!(instruction2 instanceof StreamInstruction) || instruction2.getChildInstructionCount() >= 10 || !(instruction2.getType(typeEnvironment, (BindingEnvironment)object).resolveType(typeEnvironment) instanceof StreamType)) break block9;
                if (forEachInstruction.getIndexVar() == null) break block10;
                hashSet = new HashSet();
                forEachInstruction.getBody().accumulateFreeBindings(hashSet, (BindingEnvironment)object);
                if (hashSet.contains(forEachInstruction.getIndexBinding())) break block9;
            }
            hashSet = (StreamInstruction)instruction2;
            ArrayList<IdentifierInstruction> arrayList = new ArrayList<IdentifierInstruction>();
            ArrayList arrayList2 = new ArrayList();
            ForEachEvaluator.accumulateStream(hashSet, arrayList2, partialInformationCollector, letChainManager);
            Type type = ((StreamType)forEachInstruction.getType(typeEnvironment, (BindingEnvironment)object).resolveType(typeEnvironment)).getElementType();
            if (arrayList2.size() == 0) {
                return new PartialEvaluationResult(new StreamInstruction(type));
            }
            for (Instruction instruction3 : arrayList2) {
                Instruction instruction4;
                if (instruction3.getType(typeEnvironment, (BindingEnvironment)object).resolveType(typeEnvironment) instanceof StreamType) {
                    if (arrayList2.size() == 1) {
                        forEachInstruction.setSource(instruction3);
                        return new PartialEvaluationResult(null, true);
                    }
                    instruction4 = (ForEachInstruction)forEachInstruction.cloneWithNewNames();
                    ((ForEachInstruction)instruction4).setBody(((ForEachInstruction)instruction4).getBody().cloneReduced());
                    ((ForEachInstruction)instruction4).setSource(instruction3);
                    arrayList.add(letChainManager.insertBody(instruction4, letInstruction));
                    continue;
                }
                instruction4 = forEachInstruction.getBody();
                HashMap<Object, Instruction> hashMap = new HashMap<Object, Instruction>();
                hashMap.put(forEachInstruction.getVarName(), instruction3);
                arrayList.add(letChainManager.insertBody(instruction4.assignNewNames(hashMap), letInstruction));
            }
            return new PartialEvaluationResult((Instruction)new StreamInstruction(type, arrayList), true);
        }
        if (((PartialEvaluationResult)((Object)(hashSet = partialInformationCollector.partiallyEvaluateBody(forEachInstruction.getBody(), forEachInstruction, 1, letChainManager)))).getReplacement() != null) {
            forEachInstruction.setBody(((PartialEvaluationResult)((Object)hashSet)).getReplacement());
        }
        return PartialEvaluationResult.s_emptyResult;
    }
}

