/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.util.AbstractWsdlProcessor;
import org.wso2.carbon.core.transports.util.RequestProcessorUtil;
import org.wso2.carbon.utils.NetworkUtils;

public class Wsdl11Processor
extends AbstractWsdlProcessor {
    @Override
    public void process(final CarbonHttpRequest request, final CarbonHttpResponse response, final ConfigurationContext configurationContext) throws Exception {
        AbstractWsdlProcessor.WSDLPrinter wsdlPrinter = new AbstractWsdlProcessor.WSDLPrinter(){

            @Override
            public void printWSDL(AxisService axisService) throws IOException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                String importedWSDL = Wsdl11Processor.this.getImportedWSDL(request, "wsdl");
                if ("".equals(importedWSDL)) {
                    axisService.printWSDL((OutputStream)baos, NetworkUtils.getLocalHostname());
                } else {
                    axisService.printUserWSDL((OutputStream)baos, importedWSDL);
                }
                RequestProcessorUtil.writeDocument(baos, response.getOutputStream(), "annotated-wsdl.xsl", configurationContext.getContextRoot(), Wsdl11Processor.this.checkForAnnotation(request));
            }
        };
        String requestURI = request.getRequestURI();
        String contextPath = configurationContext.getServiceContextPath();
        String serviceName = requestURI.substring(requestURI.indexOf(contextPath) + contextPath.length() + 1);
        this.printWSDL(configurationContext, serviceName, response, wsdlPrinter);
    }
}

