/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.security.wsutil.SecuritySessionUtils;
import eu.unicore.security.wsutil.WSSecHeader;
import eu.unicore.security.wsutil.client.Configurable;
import eu.unicore.security.wsutil.client.DSigOutHandler;
import eu.unicore.security.wsutil.client.ExtendedTDOutHandler;
import eu.unicore.security.wsutil.client.TDOutHandler;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class SAMLAttributePushOutHandler
extends AbstractSoapInterceptor
implements Configurable {
    private static final Logger log = Log.getLogger("unicore.security", SAMLAttributePushOutHandler.class);
    public static final String PUSHED_RAW_ASSERTIONS = SAMLAttributePushOutHandler.class.getName() + ".RAW-SAML-TO-PUSH";
    public static final String PUSHED_ASSERTIONS = "SAMLPushedassertions";
    protected List<Element> toBeInserted = new ArrayList<Element>();
    protected List<Assertion> origList;

    public SAMLAttributePushOutHandler() {
        super("pre-protocol");
        this.getBefore().add(DSigOutHandler.class.getName());
        this.getAfter().add(TDOutHandler.class.getName());
        this.getAfter().add(ExtendedTDOutHandler.class.getName());
    }

    public SAMLAttributePushOutHandler(List<Assertion> assertions) throws IOException {
        this();
        this.convertToJDOM(assertions);
        this.origList = assertions;
    }

    @Override
    public void configure(IClientConfiguration properties) {
        Map<String, Object> secContext = properties.getExtraSecurityTokens();
        if (secContext == null) {
            log.debug("Extra security tokens are not set; SAML attributes won't be sent.");
            return;
        }
        Object assertionsO = secContext.get(PUSHED_ASSERTIONS);
        Object assertionsRawO = secContext.get(PUSHED_RAW_ASSERTIONS);
        if (assertionsO != null) {
            List assertions = (List)assertionsO;
            try {
                this.convertToJDOM(assertions);
                this.origList = assertions;
            }
            catch (Exception e) {
                log.error("Error when parsing SAML assertions.", e);
            }
        }
        if (assertionsRawO != null) {
            List assertionsRaw = (List)assertionsRawO;
            this.toBeInserted.addAll(assertionsRaw);
        }
        if (this.toBeInserted.size() == 0) {
            log.debug("Thre are no SAML assertions in extra security tokens; SAML attributes won't be sent.");
            return;
        }
        log.debug("Found SAML assertions to be sent, applying them");
    }

    public void handleMessage(SoapMessage message) {
        if (!MessageUtils.isOutbound((Message)message)) {
            log.warn("Handler " + SAMLAttributePushOutHandler.class.getName() + " used in non-client mode, what does not make sense. " + "Check your configuration.");
            return;
        }
        if (this.toBeInserted == null || this.toBeInserted.size() == 0) {
            return;
        }
        if (SecuritySessionUtils.haveSessionID(message)) {
            log.debug("Skipping SAML out handler as security session is being used");
            return;
        }
        log.debug("Adding SAML assertions to the request's header.");
        List h = message.getHeaders();
        WSSecHeader sec = new WSSecHeader(true);
        Element insertionPoint = sec.getOrInsertWSSecElement(h);
        for (Element o : this.toBeInserted) {
            if (log.isTraceEnabled()) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DOMUtils.writeXml((Node)o, (OutputStream)bos);
                    log.trace(bos.toString());
                }
                catch (Exception ex) {
                    log.warn("Can't output assertion", ex);
                }
            }
            Document parent = insertionPoint.getOwnerDocument();
            insertionPoint.appendChild(parent.importNode(o, true));
        }
    }

    protected void convertToJDOM(List<Assertion> rawAssertions) throws IOException {
        for (Assertion a : rawAssertions) {
            AssertionDocument asDoc = a.getXMLBeanDoc();
            try {
                Element elem = DOMUtils.readXml((InputStream)asDoc.newInputStream()).getDocumentElement();
                this.toBeInserted.add(elem);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
    }

    public List<Assertion> getOrigList() {
        return this.origList;
    }
}

