/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.core;

import java.util.HashMap;
import java.util.Optional;
import org.apache.airavata.gfac.core.Script;

public class GroovyMap
extends HashMap<String, Object> {
    public GroovyMap() {
        this.addDefaultValues();
    }

    public GroovyMap add(Script name, Object value) {
        this.put(name.name, value);
        return this;
    }

    @Override
    public Object get(Object key) {
        return super.getOrDefault(key, null);
    }

    public Object get(Script script) {
        return this.get(script.name);
    }

    public Optional<String> getStringValue(Script script) {
        Object obj = this.get(script);
        if (obj instanceof String) {
            return Optional.of((String)obj);
        }
        if (obj == null) {
            return Optional.empty();
        }
        throw new IllegalArgumentException("Value is not String type");
    }

    private void addDefaultValues() {
        this.add(Script.SHELL_NAME, null).add(Script.QUEUE_NAME, null).add(Script.NODES, null).add(Script.CPU_COUNT, null).add(Script.MAIL_ADDRESS, null).add(Script.ACCOUNT_STRING, null).add(Script.MAX_WALL_TIME, null).add(Script.JOB_NAME, null).add(Script.STANDARD_OUT_FILE, null).add(Script.STANDARD_ERROR_FILE, null).add(Script.QUALITY_OF_SERVICE, null).add(Script.RESERVATION, null).add(Script.EXPORTS, null).add(Script.MODULE_COMMANDS, null).add(Script.SCRATCH_LOCATION, null).add(Script.WORKING_DIR, null).add(Script.PRE_JOB_COMMANDS, null).add(Script.JOB_SUBMITTER_COMMAND, null).add(Script.EXECUTABLE_PATH, null).add(Script.INPUTS, null).add(Script.POST_JOB_COMMANDS, null).add(Script.USED_MEM, null).add(Script.PROCESS_PER_NODE, null).add(Script.CHASSIS_NAME, null).add(Script.INPUT_DIR, null).add(Script.OUTPUT_DIR, null).add(Script.USER_NAME, null).add(Script.GATEWAY_ID, null).add(Script.GATEWAY_USER_NAME, null).add(Script.APPLICATION_NAME, null);
    }
}

