/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.multipart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.impl.AbstractCollectionAdapter;
import org.apache.abdera.protocol.server.multipart.MultipartInputStream;
import org.apache.abdera.protocol.server.multipart.MultipartRelatedCollectionInfo;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultipartCollectionAdapter
extends AbstractCollectionAdapter
implements MultipartRelatedCollectionInfo {
    private static final String CONTENT_TYPE_HEADER = "content-type";
    private static final String CONTENT_ID_HEADER = "content-id";
    private static final String START_PARAM = "start";
    private static final String TYPE_PARAM = "type";
    private static final String BOUNDARY_PARAM = "boundary";
    protected Map<String, String> accepts;

    @Override
    public String[] getAccepts(RequestContext request) {
        Set<String> acceptKeys = this.getAlternateAccepts(request).keySet();
        return acceptKeys.toArray(new String[acceptKeys.size()]);
    }

    protected MultipartRelatedPost getMultipartRelatedData(RequestContext request) throws IOException, ParseException, MessagingException {
        MultipartInputStream multipart = this.getMultipartStream(request);
        multipart.skipBoundary();
        String start = request.getContentType().getParameter(START_PARAM);
        Document<Entry> entry = null;
        HashMap<String, String> entryHeaders = new HashMap<String, String>();
        InputStream data = null;
        HashMap<String, String> dataHeaders = new HashMap<String, String>();
        Map<String, String> headers = this.getHeaders(multipart);
        if (start == null || start.length() == 0 || headers.containsKey(CONTENT_ID_HEADER) && start.equals(headers.get(CONTENT_ID_HEADER)) || headers.containsKey(CONTENT_TYPE_HEADER) && MimeTypeHelper.isAtom(headers.get(CONTENT_TYPE_HEADER))) {
            entry = this.getEntry(multipart, request);
            entryHeaders.putAll(headers);
        } else {
            data = this.getDataInputStream(multipart);
            dataHeaders.putAll(headers);
        }
        multipart.skipBoundary();
        headers = this.getHeaders(multipart);
        if (start != null && headers.containsKey(CONTENT_ID_HEADER) && start.equals(headers.get(CONTENT_ID_HEADER)) && headers.containsKey(CONTENT_TYPE_HEADER) && MimeTypeHelper.isAtom(headers.get(CONTENT_TYPE_HEADER))) {
            entry = this.getEntry(multipart, request);
            entryHeaders.putAll(headers);
        } else {
            data = this.getDataInputStream(multipart);
            dataHeaders.putAll(headers);
        }
        this.checkMultipartContent(entry, dataHeaders, request);
        return new MultipartRelatedPost(entry, data, entryHeaders, dataHeaders);
    }

    private MultipartInputStream getMultipartStream(RequestContext request) throws IOException, ParseException, IllegalArgumentException {
        String boundary = request.getContentType().getParameter(BOUNDARY_PARAM);
        if (boundary == null) {
            throw new IllegalArgumentException("multipart/related stream invalid, boundary parameter is missing.");
        }
        boundary = "--" + boundary;
        String type = request.getContentType().getParameter(TYPE_PARAM);
        if (type == null || !MimeTypeHelper.isAtom(type)) {
            throw new ParseException("multipart/related stream invalid, type parameter should be application/atom+xml");
        }
        PushbackInputStream pushBackInput = new PushbackInputStream(request.getInputStream(), 2);
        pushBackInput.unread("\r\n".getBytes());
        return new MultipartInputStream(pushBackInput, boundary.getBytes());
    }

    private void checkMultipartContent(Document<Entry> entry, Map<String, String> dataHeaders, RequestContext request) throws ParseException {
        if (entry == null) {
            throw new ParseException("multipart/related stream invalid, media link entry is missing");
        }
        if (!dataHeaders.containsKey(CONTENT_TYPE_HEADER)) {
            throw new ParseException("multipart/related stream invalid, data content-type is missing");
        }
        if (!this.isContentTypeAccepted(dataHeaders.get(CONTENT_TYPE_HEADER), request)) {
            throw new ParseException("multipart/related stream invalid, content-type " + dataHeaders.get(CONTENT_TYPE_HEADER) + " not accepted into this multipart file");
        }
    }

    private Map<String, String> getHeaders(MultipartInputStream multipart) throws IOException, MessagingException {
        HashMap<String, String> mapHeaders = new HashMap<String, String>();
        this.moveToHeaders(multipart);
        InternetHeaders headers = new InternetHeaders((InputStream)multipart);
        Enumeration allHeaders = headers.getAllHeaders();
        if (allHeaders != null) {
            while (allHeaders.hasMoreElements()) {
                Header header = (Header)allHeaders.nextElement();
                mapHeaders.put(header.getName().toLowerCase(), header.getValue());
            }
        }
        return mapHeaders;
    }

    private boolean moveToHeaders(InputStream stream) throws IOException {
        int byteReaded;
        boolean dash = false;
        boolean cr = false;
        block5: while ((byteReaded = stream.read()) != -1) {
            switch (byteReaded) {
                case 13: {
                    cr = true;
                    dash = false;
                    continue block5;
                }
                case 10: {
                    if (cr) {
                        return true;
                    }
                    dash = false;
                    continue block5;
                }
                case 45: {
                    if (dash) {
                        stream.close();
                        return false;
                    }
                    dash = true;
                    cr = false;
                    continue block5;
                }
            }
            dash = false;
            cr = false;
        }
        return false;
    }

    private InputStream getDataInputStream(InputStream stream) throws IOException {
        Base64 base64 = new Base64();
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (stream.read(buffer) != -1) {
            bo.write(buffer);
        }
        return new ByteArrayInputStream(base64.decode(bo.toByteArray()));
    }

    private <T extends Element> Document<T> getEntry(InputStream stream, RequestContext request) throws ParseException, IOException {
        Parser parser = request.getAbdera().getParser();
        if (parser == null) {
            throw new IllegalArgumentException("No Parser implementation was provided");
        }
        Document document = parser.parse(stream, request.getResolvedUri().toString(), parser.getDefaultParserOptions());
        return document;
    }

    private boolean isContentTypeAccepted(String contentType, RequestContext request) {
        if (this.getAlternateAccepts(request) == null) {
            return false;
        }
        for (Map.Entry<String, String> accept : this.getAlternateAccepts(request).entrySet()) {
            if (!accept.getKey().equalsIgnoreCase(contentType) || accept.getValue() == null || !accept.getValue().equalsIgnoreCase("multipart-related")) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MultipartRelatedPost {
        private final Document<Entry> entry;
        private final InputStream data;
        private final Map<String, String> entryHeaders;
        private final Map<String, String> dataHeaders;

        public MultipartRelatedPost(Document<Entry> entry, InputStream data, Map<String, String> entryHeaders, Map<String, String> dataHeaders) {
            this.entry = entry;
            this.data = data;
            this.entryHeaders = entryHeaders;
            this.dataHeaders = dataHeaders;
        }

        public Document<Entry> getEntry() {
            return this.entry;
        }

        public InputStream getData() {
            return this.data;
        }

        public Map<String, String> getEntryHeaders() {
            return this.entryHeaders;
        }

        public Map<String, String> getDataHeaders() {
            return this.dataHeaders;
        }
    }
}

