/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.ClientPacket;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.SocketReader;
import com.hazelcast.nio.TcpIpConnection;
import java.nio.ByteBuffer;

class SocketClientDataReader
implements SocketReader {
    final TcpIpConnection connection;
    final IOService ioService;
    ClientPacket packet;
    boolean connectionTypeSet = false;

    public SocketClientDataReader(TcpIpConnection connection) {
        this.connection = connection;
        this.ioService = connection.getConnectionManager().ioService;
    }

    @Override
    public void read(ByteBuffer inBuffer) throws Exception {
        while (inBuffer.hasRemaining()) {
            boolean complete;
            if (!this.connectionTypeSet) {
                if (!this.setConnectionType(inBuffer)) {
                    return;
                }
                this.connectionTypeSet = true;
            }
            if (this.packet == null) {
                this.packet = new ClientPacket(this.ioService.getSerializationContext());
            }
            if (!(complete = this.packet.readFrom(inBuffer))) break;
            this.packet.setConn(this.connection);
            this.ioService.handleClientPacket(this.packet);
            this.packet = null;
        }
    }

    private boolean setConnectionType(ByteBuffer inBuffer) {
        if (inBuffer.remaining() >= 3) {
            byte[] typeBytes = new byte[3];
            inBuffer.get(typeBytes);
            String type = new String(typeBytes);
            if ("JVM".equals(type)) {
                this.connection.setType(ConnectionType.JAVA_CLIENT);
            } else if ("CSP".equals(type)) {
                this.connection.setType(ConnectionType.CSHARP_CLIENT);
            } else if ("CPP".equals(type)) {
                this.connection.setType(ConnectionType.CPP_CLIENT);
            } else if ("PHY".equals(type)) {
                this.connection.setType(ConnectionType.PYTHON_CLIENT);
            } else if ("RBY".equals(type)) {
                this.connection.setType(ConnectionType.RUBY_CLIENT);
            } else {
                this.ioService.getLogger(this.getClass().getName()).info("Unknown client type: " + type);
                this.connection.setType(ConnectionType.BINARY_CLIENT);
            }
            return true;
        }
        return false;
    }
}

