/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.dozer.classmap.MappingFileData;
import org.dozer.config.BeanContainer;
import org.dozer.loader.MappingsSource;
import org.dozer.loader.xml.MappingStreamReader;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingFileReader
implements MappingsSource<URL> {
    private static final Logger log = LoggerFactory.getLogger(MappingFileReader.class);
    private final MappingStreamReader streamReader;

    public MappingFileReader(XMLParserFactory parserFactory) {
        this.streamReader = new MappingStreamReader(parserFactory);
    }

    @Override
    public MappingFileData read(String fileName) {
        DozerClassLoader classLoader = BeanContainer.getInstance().getClassLoader();
        URL url = classLoader.loadResource(fileName);
        return this.read(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MappingFileData read(URL url) {
        MappingFileData result = null;
        InputStream stream = null;
        try {
            stream = url.openStream();
            result = this.streamReader.read(stream);
        }
        catch (IOException e) {
            log.error("Error while loading dozer mapping file url: [" + url + "]", (Throwable)e);
            MappingUtils.throwMappingException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                MappingUtils.throwMappingException(e);
            }
        }
        return result;
    }
}

