/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.runtime.description.marshal.impl;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.impl.ArtifactProcessor;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.PropertyDescriptorPlus;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescriptorMapBuilder {
    private static Log log = LogFactory.getLog(PropertyDescriptorMapBuilder.class);

    private PropertyDescriptorMapBuilder() {
    }

    public static Map<Class, Map<String, PropertyDescriptorPlus>> getPropertyDescMaps(ServiceDescription serviceDesc, ArtifactProcessor ap) {
        HashMap<Class, Map<String, PropertyDescriptorPlus>> map = new HashMap<Class, Map<String, PropertyDescriptorPlus>>();
        Collection<EndpointDescription> endpointDescs = serviceDesc.getEndpointDescriptions_AsCollection();
        if (endpointDescs != null) {
            for (EndpointDescription ed : endpointDescs) {
                PropertyDescriptorMapBuilder.getPropertyDescMaps(ed, ap, map);
            }
        }
        return map;
    }

    private static void getPropertyDescMaps(EndpointDescription endpointDesc, ArtifactProcessor ap, Map<Class, Map<String, PropertyDescriptorPlus>> map) {
        EndpointInterfaceDescription endpointInterfaceDesc = endpointDesc.getEndpointInterfaceDescription();
        if (endpointInterfaceDesc != null) {
            PropertyDescriptorMapBuilder.getPropertyDescMaps(endpointDesc, endpointInterfaceDesc, ap, map);
        }
    }

    private static void getPropertyDescMaps(EndpointDescription endpointDesc, EndpointInterfaceDescription endpointInterfaceDesc, ArtifactProcessor ap, Map<Class, Map<String, PropertyDescriptorPlus>> map) {
        OperationDescription[] opDescs = endpointInterfaceDesc.getOperations();
        if (opDescs != null) {
            for (int i = 0; i < opDescs.length; ++i) {
                PropertyDescriptorMapBuilder.getPropertyDescMaps(endpointDesc, opDescs[i], ap, map);
            }
        }
    }

    private static void getPropertyDescMaps(EndpointDescription endpointDesc, OperationDescription opDesc, ArtifactProcessor ap, Map<Class, Map<String, PropertyDescriptorPlus>> map) {
        String wrapperName;
        FaultDescription[] faultDescs = opDesc.getFaultDescriptions();
        if (faultDescs != null) {
            for (int i = 0; i < faultDescs.length; ++i) {
                PropertyDescriptorMapBuilder.getPropertyDescMaps(endpointDesc, faultDescs[i], ap, map);
            }
        }
        if ((wrapperName = ap.getRequestWrapperMap().get(opDesc)) != null) {
            PropertyDescriptorMapBuilder.addPropertyDesc(endpointDesc, wrapperName, map);
        }
        if ((wrapperName = ap.getResponseWrapperMap().get(opDesc)) != null) {
            PropertyDescriptorMapBuilder.addPropertyDesc(endpointDesc, wrapperName, map);
        }
    }

    private static void getPropertyDescMaps(EndpointDescription endpointDesc, FaultDescription faultDesc, ArtifactProcessor ap, Map<Class, Map<String, PropertyDescriptorPlus>> map) {
        FaultBeanDesc faultBeanDesc;
        String faultDescBeanName;
        Class faultDescBean;
        String faultDescExceptionName = faultDesc.getExceptionClassName();
        Class faultDescException = PropertyDescriptorMapBuilder.loadClass(faultDescExceptionName);
        if (faultDescException != null && (faultDesc.getFaultInfo() == null || faultDesc.getFaultInfo().length() == 0) && (faultDescBean = PropertyDescriptorMapBuilder.loadClass(faultDescBeanName = (faultBeanDesc = ap.getFaultBeanDescMap().get(faultDesc)).getFaultBeanClassName())) != null) {
            PropertyDescriptorMapBuilder.addPropertyDesc(endpointDesc, faultDescBeanName, map);
            PropertyDescriptorMapBuilder.addPropertyDesc(endpointDesc, faultDescExceptionName, map);
        }
    }

    private static void addPropertyDesc(EndpointDescription endpointDesc, String clsName, Map<Class, Map<String, PropertyDescriptorPlus>> map) {
        Class cls = PropertyDescriptorMapBuilder.loadClass(clsName);
        if (cls == null) {
            cls = PropertyDescriptorMapBuilder.loadClass(clsName, endpointDesc.getAxisService().getClassLoader());
        }
        if (cls == null) {
            return;
        }
        if (map.get(cls) == null) {
            try {
                Map<String, PropertyDescriptorPlus> pdMap = XMLRootElementUtil.createPropertyDescriptorMap(cls);
                map.put(cls, pdMap);
            }
            catch (Throwable t) {
                throw ExceptionFactory.makeWebServiceException(t);
            }
        }
    }

    private static Class loadClass(String className) {
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            return PropertyDescriptorMapBuilder.forName(className, true, PropertyDescriptorMapBuilder.getContextClassLoader());
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PackageSetBuilder cannot load the following class:" + className));
            }
            return null;
        }
    }

    private static Class loadClass(String className, ClassLoader cl) {
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            return PropertyDescriptorMapBuilder.forName(className, true, cl);
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PackageSetBuilder cannot load the following class:" + className));
            }
            return null;
        }
    }

    static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class<?> cls = ClassUtils.getPrimitiveClass(className);
                    if (cls == null) {
                        cls = Class.forName(className, initialize, classloader);
                    }
                    return cls;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (RuntimeException)e.getException();
        }
        return cl;
    }
}

