/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateApplicationVersionRequestMarshaller
implements Marshaller<Request<CreateApplicationVersionRequest>, CreateApplicationVersionRequest> {
    public Request<CreateApplicationVersionRequest> marshall(CreateApplicationVersionRequest createApplicationVersionRequest) {
        S3Location s3LocationSourceBundle;
        if (createApplicationVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createApplicationVersionRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        if (createApplicationVersionRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)createApplicationVersionRequest.getApplicationName()));
        }
        if (createApplicationVersionRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)createApplicationVersionRequest.getVersionLabel()));
        }
        if (createApplicationVersionRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createApplicationVersionRequest.getDescription()));
        }
        if ((s3LocationSourceBundle = createApplicationVersionRequest.getSourceBundle()) != null) {
            if (s3LocationSourceBundle.getS3Bucket() != null) {
                request.addParameter("SourceBundle.S3Bucket", StringUtils.fromString((String)s3LocationSourceBundle.getS3Bucket()));
            }
            if (s3LocationSourceBundle.getS3Key() != null) {
                request.addParameter("SourceBundle.S3Key", StringUtils.fromString((String)s3LocationSourceBundle.getS3Key()));
            }
        }
        if (createApplicationVersionRequest.isAutoCreateApplication() != null) {
            request.addParameter("AutoCreateApplication", StringUtils.fromBoolean((Boolean)createApplicationVersionRequest.isAutoCreateApplication()));
        }
        return request;
    }
}

