/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.security.wsutil.ConditionalGetServerInHandler;
import eu.unicore.security.wsutil.ConditionalGetServerOutHandler;
import eu.unicore.security.wsutil.client.ConditionalGetInHandler;
import eu.unicore.security.wsutil.client.ConditionalGetOutHandler;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ConditionalGetUtil {
    static DateFormat iso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    static DateFormat[] formats = new DateFormat[]{iso};

    public static class Server {
        public static String getIfNoneMatch() {
            return ConditionalGetServerInHandler.getIfNoneMatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Calendar getIfModifiedSince() {
            String raw = ConditionalGetServerInHandler.getIfModifiedSince();
            Calendar c = null;
            if (raw != null) {
                DateFormat[] arr$ = formats;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    DateFormat f;
                    DateFormat dateFormat = f = arr$[i$];
                    synchronized (dateFormat) {
                        try {
                            Date d = f.parse(raw);
                            c = Calendar.getInstance();
                            c.setTime(d);
                            break;
                        }
                        catch (ParseException pe) {
                            continue;
                        }
                    }
                }
            }
            return c;
        }

        public static boolean wasModifiedSince(Calendar lastModified) {
            Calendar clientMod = Server.getIfModifiedSince();
            if (clientMod == null) {
                return true;
            }
            clientMod.add(13, -5);
            return clientMod == null || lastModified.compareTo(clientMod) >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean mustSendData(Calendar lastModified, String newEtag) {
            String etag = Server.getIfNoneMatch();
            if (newEtag.equals(etag)) {
                Server.setNotModified();
                return false;
            }
            ConditionalGetServerOutHandler.setEtag(newEtag);
            DateFormat dateFormat = iso;
            synchronized (dateFormat) {
                ConditionalGetServerOutHandler.setLastModified(iso.format(lastModified.getTime()));
            }
            return true;
        }

        public static void setNotModified() {
            ConditionalGetServerOutHandler.setNotModified();
        }

        public static String md5(String string) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(string.getBytes());
                return Server.hexString(md.digest());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public static String hexString(byte[] bytes) {
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                String hex = Integer.toHexString(0xFF & bytes[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
    }

    public static class Client {
        public static String getEtag() {
            return ConditionalGetInHandler.getEtag();
        }

        public static String getLastModified() {
            return ConditionalGetInHandler.getLastModified();
        }

        public static boolean isNotModified() {
            return Boolean.TRUE.equals(ConditionalGetInHandler.isNotModified());
        }

        public static void setIfNoneMatch(String etag) {
            ConditionalGetOutHandler.setEtag(etag);
        }

        public static void setIfModifiedSince(String lastModified) {
            ConditionalGetOutHandler.setLastModified(lastModified);
        }
    }
}

