/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.RetryableRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.ContainsAllOperation;
import com.hazelcast.collection.operations.client.CollectionKeyBasedRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ContainsAllRequest
extends CollectionKeyBasedRequest
implements RetryableRequest {
    Set<Data> dataSet;

    public ContainsAllRequest() {
    }

    public ContainsAllRequest(CollectionProxyId proxyId, Data key, Set<Data> dataSet) {
        super(proxyId, key);
        this.dataSet = dataSet;
    }

    @Override
    protected Operation prepareOperation() {
        return new ContainsAllOperation(this.proxyId, this.key, this.dataSet);
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("s", this.dataSet.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Data data : this.dataSet) {
            data.writeData(out);
        }
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        int size = reader.readInt("s");
        this.dataSet = new HashSet<Data>(size);
        ObjectDataInput in = reader.getRawDataInput();
        for (int i = 0; i < size; ++i) {
            Data data = new Data();
            data.readData(in);
            this.dataSet.add(data);
        }
        super.readPortable(reader);
    }
}

