/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.problems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.Encoding;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.zookeeper.KeeperException;

public class ProblemReport {
    private TableId tableId;
    private ProblemType problemType;
    private String resource;
    private String exception;
    private String server;
    private long creationTime;

    public ProblemReport(TableId tableId, ProblemType problemType, String resource, String server, Throwable e, long creationTime) {
        Objects.requireNonNull(tableId, "tableId is null");
        Objects.requireNonNull(problemType, "problemType is null");
        Objects.requireNonNull(resource, "resource is null");
        this.tableId = tableId;
        this.problemType = problemType;
        this.resource = resource;
        if (e != null) {
            this.exception = e.getMessage();
        }
        if (server == null) {
            try {
                server = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.server = server;
        this.creationTime = creationTime;
    }

    public ProblemReport(TableId tableId, ProblemType problemType, String resource, String server, Throwable e) {
        this(tableId, problemType, resource, server, e, System.currentTimeMillis());
    }

    public ProblemReport(TableId tableId, ProblemType problemType, String resource, Throwable e) {
        this(tableId, problemType, resource, null, e);
    }

    private ProblemReport(TableId table, ProblemType problemType, String resource, byte[] enc) throws IOException {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(problemType, "problemType is null");
        Objects.requireNonNull(resource, "resource is null");
        this.tableId = table;
        this.problemType = problemType;
        this.resource = resource;
        this.decode(enc);
    }

    private byte[] encode() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeLong(this.creationTime);
        dos.writeBoolean(this.server != null);
        if (this.server != null) {
            dos.writeUTF(this.server);
        }
        dos.writeBoolean(this.exception != null);
        if (this.exception != null) {
            dos.writeUTF(this.exception);
        }
        dos.close();
        baos.close();
        return baos.toByteArray();
    }

    private void decode(byte[] enc) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(enc);
        DataInputStream dis = new DataInputStream(bais);
        this.creationTime = dis.readLong();
        this.server = dis.readBoolean() ? dis.readUTF() : null;
        this.exception = dis.readBoolean() ? dis.readUTF() : null;
    }

    void removeFromMetadataTable(ServerContext context) throws Exception {
        Mutation m = new Mutation((CharSequence)(MetadataSchema.ProblemSection.getRowPrefix() + this.tableId));
        m.putDelete((CharSequence)this.problemType.name(), (CharSequence)this.resource);
        MetadataTableUtil.getMetadataTable(context).update(m);
    }

    void saveToMetadataTable(ServerContext context) throws Exception {
        Mutation m = new Mutation((CharSequence)(MetadataSchema.ProblemSection.getRowPrefix() + this.tableId));
        m.put((CharSequence)this.problemType.name(), (CharSequence)this.resource, new Value(this.encode()));
        MetadataTableUtil.getMetadataTable(context).update(m);
    }

    void removeFromZooKeeper(ServerContext context) throws Exception {
        this.removeFromZooKeeper(context.getZooReaderWriter(), context);
    }

    void removeFromZooKeeper(ZooReaderWriter zoorw, ServerContext context) throws IOException, KeeperException, InterruptedException {
        String zpath = this.getZPath(context.getZooKeeperRoot());
        zoorw.recursiveDelete(zpath, ZooUtil.NodeMissingPolicy.SKIP);
    }

    void saveToZooKeeper(ServerContext context) throws IOException, KeeperException, InterruptedException {
        context.getZooReaderWriter().putPersistentData(this.getZPath(context.getZooKeeperRoot()), this.encode(), ZooUtil.NodeExistsPolicy.OVERWRITE);
    }

    private String getZPath(String zkRoot) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(this.getTableId().canonical());
        dos.writeUTF(this.getProblemType().name());
        dos.writeUTF(this.getResource());
        dos.close();
        baos.close();
        return zkRoot + "/problems/" + Encoding.encodeAsBase64FileName((byte[])baos.toByteArray());
    }

    static ProblemReport decodeZooKeeperEntry(ServerContext context, String node) throws IOException, KeeperException, InterruptedException {
        byte[] bytes = Encoding.decodeBase64FileName((String)node);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        TableId tableId = TableId.of((String)dis.readUTF());
        String problemType = dis.readUTF();
        String resource = dis.readUTF();
        String zpath = context.getZooKeeperRoot() + "/problems/" + node;
        byte[] enc = context.getZooReaderWriter().getData(zpath);
        return new ProblemReport(tableId, ProblemType.valueOf(problemType), resource, enc);
    }

    public static ProblemReport decodeMetadataEntry(Map.Entry<Key, Value> entry) throws IOException {
        TableId tableId = TableId.of((String)entry.getKey().getRow().toString().substring(MetadataSchema.ProblemSection.getRowPrefix().length()));
        String problemType = entry.getKey().getColumnFamily().toString();
        String resource = entry.getKey().getColumnQualifier().toString();
        return new ProblemReport(tableId, ProblemType.valueOf(problemType), resource, entry.getValue().get());
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public ProblemType getProblemType() {
        return this.problemType;
    }

    public String getResource() {
        return this.resource;
    }

    public String getException() {
        return this.exception;
    }

    public String getServer() {
        return this.server;
    }

    public long getTime() {
        return this.creationTime;
    }

    public int hashCode() {
        return this.tableId.hashCode() + this.problemType.hashCode() + this.resource.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ProblemReport) {
            ProblemReport opr = (ProblemReport)o;
            return this.tableId.equals((Object)opr.tableId) && this.problemType.equals((Object)opr.problemType) && this.resource.equals(opr.resource);
        }
        return false;
    }
}

