/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.proxy;

import com.google.common.collect.Iterators;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.iterators.DebugIterator;
import org.apache.accumulo.core.iterators.DevNull;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.examples.simple.constraints.MaxMutationSize;
import org.apache.accumulo.examples.simple.constraints.NumericValueConstraint;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.proxy.Proxy;
import org.apache.accumulo.proxy.thrift.AccumuloProxy;
import org.apache.accumulo.proxy.thrift.AccumuloSecurityException;
import org.apache.accumulo.proxy.thrift.ActiveCompaction;
import org.apache.accumulo.proxy.thrift.ActiveScan;
import org.apache.accumulo.proxy.thrift.BatchScanOptions;
import org.apache.accumulo.proxy.thrift.Column;
import org.apache.accumulo.proxy.thrift.ColumnUpdate;
import org.apache.accumulo.proxy.thrift.CompactionReason;
import org.apache.accumulo.proxy.thrift.CompactionStrategyConfig;
import org.apache.accumulo.proxy.thrift.CompactionType;
import org.apache.accumulo.proxy.thrift.Condition;
import org.apache.accumulo.proxy.thrift.ConditionalStatus;
import org.apache.accumulo.proxy.thrift.ConditionalUpdates;
import org.apache.accumulo.proxy.thrift.ConditionalWriterOptions;
import org.apache.accumulo.proxy.thrift.DiskUsage;
import org.apache.accumulo.proxy.thrift.IteratorScope;
import org.apache.accumulo.proxy.thrift.IteratorSetting;
import org.apache.accumulo.proxy.thrift.Key;
import org.apache.accumulo.proxy.thrift.KeyValue;
import org.apache.accumulo.proxy.thrift.MutationsRejectedException;
import org.apache.accumulo.proxy.thrift.NamespaceExistsException;
import org.apache.accumulo.proxy.thrift.NamespaceNotEmptyException;
import org.apache.accumulo.proxy.thrift.NamespaceNotFoundException;
import org.apache.accumulo.proxy.thrift.NamespacePermission;
import org.apache.accumulo.proxy.thrift.PartialKey;
import org.apache.accumulo.proxy.thrift.ScanColumn;
import org.apache.accumulo.proxy.thrift.ScanOptions;
import org.apache.accumulo.proxy.thrift.ScanResult;
import org.apache.accumulo.proxy.thrift.ScanState;
import org.apache.accumulo.proxy.thrift.ScanType;
import org.apache.accumulo.proxy.thrift.SystemPermission;
import org.apache.accumulo.proxy.thrift.TableExistsException;
import org.apache.accumulo.proxy.thrift.TableNotFoundException;
import org.apache.accumulo.proxy.thrift.TablePermission;
import org.apache.accumulo.proxy.thrift.TimeType;
import org.apache.accumulo.proxy.thrift.UnknownScanner;
import org.apache.accumulo.proxy.thrift.UnknownWriter;
import org.apache.accumulo.proxy.thrift.WriterOptions;
import org.apache.accumulo.server.util.PortUtils;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.accumulo.test.proxy.TestProxyClient;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleProxyBase
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(SimpleProxyBase.class);
    private static final long ZOOKEEPER_PROPAGATION_TIME = 10000L;
    private static TServer proxyServer;
    private static int proxyPort;
    private TestProxyClient proxyClient;
    private AccumuloProxy.Client client;
    private static Map<String, String> properties;
    private static String hostname;
    private static String proxyPrincipal;
    private static String proxyPrimary;
    private static String clientPrincipal;
    private static File proxyKeytab;
    private static File clientKeytab;
    private ByteBuffer creds = null;
    static TProtocolFactory factory;
    final IteratorSetting setting = new IteratorSetting(100, "slow", SlowIterator.class.getName(), Collections.singletonMap("sleepTime", "200"));
    String tableName;
    String namespaceName;
    ByteBuffer badLogin;

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    private static void waitForAccumulo(Connector c) throws Exception {
        Iterators.size((Iterator)c.createScanner("accumulo.metadata", Authorizations.EMPTY).iterator());
    }

    private static boolean isKerberosEnabled() {
        return SharedMiniClusterBase.TRUE.equals(System.getProperty("org.apache.accumulo.test.functional.useKrbForIT"));
    }

    public static void setUpProxy() throws Exception {
        String tokenClass;
        Assert.assertNotNull((String)"Implementations must initialize the TProtocolFactory", (Object)factory);
        Connector c = SharedMiniClusterBase.getConnector();
        Instance inst = c.getInstance();
        SimpleProxyBase.waitForAccumulo(c);
        hostname = InetAddress.getLocalHost().getCanonicalHostName();
        Properties props = new Properties();
        props.put("instance", inst.getInstanceName());
        props.put("zookeepers", inst.getZooKeepers());
        if (SimpleProxyBase.isKerberosEnabled()) {
            tokenClass = KerberosToken.class.getName();
            TestingKdc kdc = SimpleProxyBase.getKdc();
            proxyKeytab = new File(kdc.getKeytabDir(), "proxy.keytab");
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
            proxyPrimary = "proxy";
            proxyPrincipal = proxyPrimary + "/" + hostname;
            kdc.createPrincipal(proxyKeytab, proxyPrincipal);
            proxyPrincipal = kdc.qualifyUser(proxyPrincipal);
            props.setProperty("kerberosPrincipal", proxyPrincipal);
            props.setProperty("kerberosKeytab", proxyKeytab.getCanonicalPath());
            props.setProperty("thriftServerType", "sasl");
            Configuration conf = new Configuration(false);
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.loginUserFromKeytab((String)proxyPrincipal, (String)proxyKeytab.getAbsolutePath());
            ClusterUser user = kdc.getRootUser();
            clientPrincipal = user.getPrincipal();
            clientKeytab = user.getKeytab();
        } else {
            clientPrincipal = "root";
            tokenClass = PasswordToken.class.getName();
            properties.put("password", SharedMiniClusterBase.getRootPassword());
            hostname = "localhost";
        }
        props.put("tokenClass", tokenClass);
        ClientConfiguration clientConfig = SharedMiniClusterBase.getCluster().getClientConfig();
        String clientConfPath = new File(SharedMiniClusterBase.getCluster().getConfig().getConfDir(), "client.conf").getAbsolutePath();
        props.put("clientConfigurationFile", clientConfPath);
        properties.put("clientConfigurationFile", clientConfPath);
        proxyPort = PortUtils.getRandomFreePort();
        proxyServer = Proxy.createProxyServer((HostAndPort)HostAndPort.fromParts((String)SimpleProxyBase.hostname, (int)SimpleProxyBase.proxyPort), (TProtocolFactory)SimpleProxyBase.factory, (Properties)props, (ClientConfiguration)clientConfig).server;
        while (!proxyServer.isServing()) {
            UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    @AfterClass
    public static void tearDownProxy() throws Exception {
        if (null != proxyServer) {
            proxyServer.stop();
        }
        SharedMiniClusterBase.stopMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws Exception {
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
            this.proxyClient = new TestProxyClient(hostname, proxyPort, factory, proxyPrimary, UserGroupInformation.getCurrentUser());
            this.client = this.proxyClient.proxy();
            this.creds = this.client.login(clientPrincipal, properties);
            TestingKdc kdc = SimpleProxyBase.getKdc();
            ClusterUser user = kdc.getClientPrincipal(0);
            this.client.createLocalUser(this.creds, user.getPrincipal(), this.s2bb("unused"));
            UserGroupInformation.loginUserFromKeytab((String)user.getPrincipal(), (String)user.getKeytab().getAbsolutePath());
            UserGroupInformation badUgi = UserGroupInformation.getCurrentUser();
            try (TestProxyClient badClient = new TestProxyClient(hostname, proxyPort, factory, proxyPrimary, badUgi);){
                AccumuloProxy.Client badProxy = badClient.proxy();
                this.badLogin = badProxy.login(user.getPrincipal(), properties);
            }
            UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
            this.client.dropLocalUser(this.creds, user.getPrincipal());
        } else {
            this.proxyClient = new TestProxyClient(hostname, proxyPort, factory);
            this.client = this.proxyClient.proxy();
            this.creds = this.client.login("root", properties);
            this.client.createLocalUser(this.creds, "user", this.s2bb(SharedMiniClusterBase.getRootPassword()));
            this.badLogin = this.client.login("user", properties);
            this.client.dropLocalUser(this.creds, "user");
        }
        String[] uniqueNames = this.getUniqueNames(2);
        this.tableName = uniqueNames[0];
        this.client.createTable(this.creds, this.tableName, true, TimeType.MILLIS);
        this.namespaceName = uniqueNames[1];
        this.client.createNamespace(this.creds, this.namespaceName);
    }

    @After
    public void teardown() throws Exception {
        if (null != this.tableName) {
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
            }
            try {
                if (this.client.tableExists(this.creds, this.tableName)) {
                    this.client.deleteTable(this.creds, this.tableName);
                }
            }
            catch (Exception e) {
                log.warn("Failed to delete test table", (Throwable)e);
            }
        }
        if (null != this.namespaceName) {
            try {
                if (this.client.namespaceExists(this.creds, this.namespaceName)) {
                    this.client.deleteNamespace(this.creds, this.namespaceName);
                }
            }
            catch (Exception e) {
                log.warn("Failed to delete test namespace", (Throwable)e);
            }
        }
        if (null != this.proxyClient) {
            this.proxyClient.close();
        }
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void addConstraintLoginFailure() throws Exception {
        this.client.addConstraint(this.badLogin, this.tableName, NumericValueConstraint.class.getName());
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void addSplitsLoginFailure() throws Exception {
        this.client.addSplits(this.badLogin, this.tableName, Collections.singleton(this.s2bb("1")));
    }

    @Test(expected=TApplicationException.class, timeout=5000L)
    public void clearLocatorCacheLoginFailure() throws Exception {
        this.client.clearLocatorCache(this.badLogin, this.tableName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void compactTableLoginFailure() throws Exception {
        this.client.compactTable(this.badLogin, this.tableName, null, null, null, true, false, null);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void cancelCompactionLoginFailure() throws Exception {
        this.client.cancelCompaction(this.badLogin, this.tableName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void createTableLoginFailure() throws Exception {
        this.client.createTable(this.badLogin, this.tableName, false, TimeType.MILLIS);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void deleteTableLoginFailure() throws Exception {
        this.client.deleteTable(this.badLogin, this.tableName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void deleteRowsLoginFailure() throws Exception {
        this.client.deleteRows(this.badLogin, this.tableName, null, null);
    }

    @Test(expected=TApplicationException.class, timeout=5000L)
    public void tableExistsLoginFailure() throws Exception {
        this.client.tableExists(this.badLogin, this.tableName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void flustTableLoginFailure() throws Exception {
        this.client.flushTable(this.badLogin, this.tableName, null, null, false);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getLocalityGroupsLoginFailure() throws Exception {
        this.client.getLocalityGroups(this.badLogin, this.tableName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getMaxRowLoginFailure() throws Exception {
        this.client.getMaxRow(this.badLogin, this.tableName, Collections.emptySet(), null, false, null, false);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getTablePropertiesLoginFailure() throws Exception {
        this.client.getTableProperties(this.badLogin, this.tableName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void listSplitsLoginFailure() throws Exception {
        this.client.listSplits(this.badLogin, this.tableName, 10000);
    }

    @Test(expected=TApplicationException.class, timeout=5000L)
    public void listTablesLoginFailure() throws Exception {
        this.client.listTables(this.badLogin);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void listConstraintsLoginFailure() throws Exception {
        this.client.listConstraints(this.badLogin, this.tableName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void mergeTabletsLoginFailure() throws Exception {
        this.client.mergeTablets(this.badLogin, this.tableName, null, null);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void offlineTableLoginFailure() throws Exception {
        this.client.offlineTable(this.badLogin, this.tableName, false);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void onlineTableLoginFailure() throws Exception {
        this.client.onlineTable(this.badLogin, this.tableName, false);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void removeConstraintLoginFailure() throws Exception {
        this.client.removeConstraint(this.badLogin, this.tableName, 0);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void removeTablePropertyLoginFailure() throws Exception {
        this.client.removeTableProperty(this.badLogin, this.tableName, Property.TABLE_FILE_MAX.getKey());
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void renameTableLoginFailure() throws Exception {
        this.client.renameTable(this.badLogin, this.tableName, "someTableName");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void setLocalityGroupsLoginFailure() throws Exception {
        HashMap<String, Set<String>> groups = new HashMap<String, Set<String>>();
        groups.put("group1", Collections.singleton("cf1"));
        groups.put("group2", Collections.singleton("cf2"));
        this.client.setLocalityGroups(this.badLogin, this.tableName, groups);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void setTablePropertyLoginFailure() throws Exception {
        this.client.setTableProperty(this.badLogin, this.tableName, Property.TABLE_FILE_MAX.getKey(), "0");
    }

    @Test(expected=TException.class, timeout=5000L)
    public void tableIdMapLoginFailure() throws Exception {
        this.client.tableIdMap(this.badLogin);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getSiteConfigurationLoginFailure() throws Exception {
        this.client.getSiteConfiguration(this.badLogin);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getSystemConfigurationLoginFailure() throws Exception {
        this.client.getSystemConfiguration(this.badLogin);
    }

    @Test(expected=TException.class, timeout=5000L)
    public void getTabletServersLoginFailure() throws Exception {
        this.client.getTabletServers(this.badLogin);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getActiveScansLoginFailure() throws Exception {
        this.client.getActiveScans(this.badLogin, "fake");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getActiveCompactionsLoginFailure() throws Exception {
        this.client.getActiveCompactions(this.badLogin, "fakse");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void removePropertyLoginFailure() throws Exception {
        this.client.removeProperty(this.badLogin, "table.split.threshold");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void setPropertyLoginFailure() throws Exception {
        this.client.setProperty(this.badLogin, "table.split.threshold", "500M");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void testClassLoadLoginFailure() throws Exception {
        this.client.testClassLoad(this.badLogin, DevNull.class.getName(), SortedKeyValueIterator.class.getName());
    }

    @Test(timeout=5000L)
    public void authenticateUserLoginFailure() throws Exception {
        if (!SimpleProxyBase.isKerberosEnabled()) {
            try {
                this.client.authenticateUser(this.badLogin, "root", this.s2pp(SharedMiniClusterBase.getRootPassword()));
                Assert.fail((String)"Expected AccumuloSecurityException");
            }
            catch (AccumuloSecurityException e) {
                return;
            }
        }
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void changeUserAuthorizationsLoginFailure() throws Exception {
        HashSet<ByteBuffer> auths = new HashSet<ByteBuffer>(Arrays.asList(this.s2bb("A"), this.s2bb("B")));
        this.client.changeUserAuthorizations(this.badLogin, "stooge", auths);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void changePasswordLoginFailure() throws Exception {
        this.client.changeLocalUserPassword(this.badLogin, "stooge", this.s2bb(""));
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void createUserLoginFailure() throws Exception {
        this.client.createLocalUser(this.badLogin, "stooge", this.s2bb("password"));
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void dropUserLoginFailure() throws Exception {
        this.client.dropLocalUser(this.badLogin, "stooge");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getUserAuthorizationsLoginFailure() throws Exception {
        this.client.getUserAuthorizations(this.badLogin, "stooge");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void grantSystemPermissionLoginFailure() throws Exception {
        this.client.grantSystemPermission(this.badLogin, "stooge", SystemPermission.CREATE_TABLE);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void grantTablePermissionLoginFailure() throws Exception {
        this.client.grantTablePermission(this.badLogin, "root", this.tableName, TablePermission.WRITE);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void hasSystemPermissionLoginFailure() throws Exception {
        this.client.hasSystemPermission(this.badLogin, "stooge", SystemPermission.CREATE_TABLE);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void hasTablePermission() throws Exception {
        this.client.hasTablePermission(this.badLogin, "root", this.tableName, TablePermission.WRITE);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void listLocalUsersLoginFailure() throws Exception {
        this.client.listLocalUsers(this.badLogin);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void revokeSystemPermissionLoginFailure() throws Exception {
        this.client.revokeSystemPermission(this.badLogin, "stooge", SystemPermission.CREATE_TABLE);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void revokeTablePermissionLoginFailure() throws Exception {
        this.client.revokeTablePermission(this.badLogin, "root", this.tableName, TablePermission.ALTER_TABLE);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void createScannerLoginFailure() throws Exception {
        this.client.createScanner(this.badLogin, this.tableName, new ScanOptions());
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void createBatchScannerLoginFailure() throws Exception {
        this.client.createBatchScanner(this.badLogin, this.tableName, new BatchScanOptions());
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void updateAndFlushLoginFailure() throws Exception {
        this.client.updateAndFlush(this.badLogin, this.tableName, new HashMap());
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void createWriterLoginFailure() throws Exception {
        this.client.createWriter(this.badLogin, this.tableName, new WriterOptions());
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void attachIteratorLoginFailure() throws Exception {
        this.client.attachIterator(this.badLogin, "slow", this.setting, EnumSet.allOf(IteratorScope.class));
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void checkIteratorLoginFailure() throws Exception {
        this.client.checkIteratorConflicts(this.badLogin, this.tableName, this.setting, EnumSet.allOf(IteratorScope.class));
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void cloneTableLoginFailure() throws Exception {
        this.client.cloneTable(this.badLogin, this.tableName, this.tableName + "_clone", false, null, null);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void exportTableLoginFailure() throws Exception {
        this.client.exportTable(this.badLogin, this.tableName, "/tmp");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void importTableLoginFailure() throws Exception {
        this.client.importTable(this.badLogin, "testify", "/tmp");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getIteratorSettingLoginFailure() throws Exception {
        this.client.getIteratorSetting(this.badLogin, this.tableName, "foo", IteratorScope.SCAN);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void listIteratorsLoginFailure() throws Exception {
        this.client.listIterators(this.badLogin, this.tableName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void removeIteratorLoginFailure() throws Exception {
        this.client.removeIterator(this.badLogin, this.tableName, "name", EnumSet.allOf(IteratorScope.class));
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void splitRangeByTabletsLoginFailure() throws Exception {
        this.client.splitRangeByTablets(this.badLogin, this.tableName, this.client.getRowRange(ByteBuffer.wrap("row".getBytes(StandardCharsets.UTF_8))), 10);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void importDirectoryLoginFailure() throws Exception {
        MiniAccumuloClusterImpl cluster = SharedMiniClusterBase.getCluster();
        Path base = cluster.getTemporaryPath();
        Path importDir = new Path(base, "importDir");
        Path failuresDir = new Path(base, "failuresDir");
        Assert.assertTrue((boolean)cluster.getFileSystem().mkdirs(importDir));
        Assert.assertTrue((boolean)cluster.getFileSystem().mkdirs(failuresDir));
        this.client.importDirectory(this.badLogin, this.tableName, importDir.toString(), failuresDir.toString(), true);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void pingTabletServerLoginFailure() throws Exception {
        this.client.pingTabletServer(this.badLogin, "fake");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void loginFailure() throws Exception {
        this.client.login("badUser", properties);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void testTableClassLoadLoginFailure() throws Exception {
        this.client.testTableClassLoad(this.badLogin, this.tableName, VersioningIterator.class.getName(), SortedKeyValueIterator.class.getName());
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void createConditionalWriterLoginFailure() throws Exception {
        this.client.createConditionalWriter(this.badLogin, this.tableName, new ConditionalWriterOptions());
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void grantNamespacePermissionLoginFailure() throws Exception {
        this.client.grantNamespacePermission(this.badLogin, "stooge", this.namespaceName, NamespacePermission.ALTER_NAMESPACE);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void hasNamespacePermissionLoginFailure() throws Exception {
        this.client.hasNamespacePermission(this.badLogin, "stooge", this.namespaceName, NamespacePermission.ALTER_NAMESPACE);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void revokeNamespacePermissionLoginFailure() throws Exception {
        this.client.revokeNamespacePermission(this.badLogin, "stooge", this.namespaceName, NamespacePermission.ALTER_NAMESPACE);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void listNamespacesLoginFailure() throws Exception {
        this.client.listNamespaces(this.badLogin);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void namespaceExistsLoginFailure() throws Exception {
        this.client.namespaceExists(this.badLogin, this.namespaceName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void createNamespaceLoginFailure() throws Exception {
        this.client.createNamespace(this.badLogin, "abcdef");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void deleteNamespaceLoginFailure() throws Exception {
        this.client.deleteNamespace(this.badLogin, this.namespaceName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void renameNamespaceLoginFailure() throws Exception {
        this.client.renameNamespace(this.badLogin, this.namespaceName, "abcdef");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void setNamespacePropertyLoginFailure() throws Exception {
        this.client.setNamespaceProperty(this.badLogin, this.namespaceName, "table.compaction.major.ratio", "4");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void removeNamespacePropertyLoginFailure() throws Exception {
        this.client.removeNamespaceProperty(this.badLogin, this.namespaceName, "table.compaction.major.ratio");
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getNamespacePropertiesLoginFailure() throws Exception {
        this.client.getNamespaceProperties(this.badLogin, this.namespaceName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void namespaceIdMapLoginFailure() throws Exception {
        this.client.namespaceIdMap(this.badLogin);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void attachNamespaceIteratorLoginFailure() throws Exception {
        IteratorSetting setting = new IteratorSetting(100, "DebugTheThings", DebugIterator.class.getName(), Collections.emptyMap());
        this.client.attachNamespaceIterator(this.badLogin, this.namespaceName, setting, EnumSet.allOf(IteratorScope.class));
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void removeNamespaceIteratorLoginFailure() throws Exception {
        this.client.removeNamespaceIterator(this.badLogin, this.namespaceName, "DebugTheThings", EnumSet.allOf(IteratorScope.class));
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void getNamespaceIteratorSettingLoginFailure() throws Exception {
        this.client.getNamespaceIteratorSetting(this.badLogin, this.namespaceName, "DebugTheThings", IteratorScope.SCAN);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void listNamespaceIteratorsLoginFailure() throws Exception {
        this.client.listNamespaceIterators(this.badLogin, this.namespaceName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void checkNamespaceIteratorConflictsLoginFailure() throws Exception {
        IteratorSetting setting = new IteratorSetting(100, "DebugTheThings", DebugIterator.class.getName(), Collections.emptyMap());
        this.client.checkNamespaceIteratorConflicts(this.badLogin, this.namespaceName, setting, EnumSet.allOf(IteratorScope.class));
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void addNamespaceConstraintLoginFailure() throws Exception {
        this.client.addNamespaceConstraint(this.badLogin, this.namespaceName, MaxMutationSize.class.getName());
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void removeNamespaceConstraintLoginFailure() throws Exception {
        this.client.removeNamespaceConstraint(this.badLogin, this.namespaceName, 1);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void listNamespaceConstraintsLoginFailure() throws Exception {
        this.client.listNamespaceConstraints(this.badLogin, this.namespaceName);
    }

    @Test(expected=AccumuloSecurityException.class, timeout=5000L)
    public void testNamespaceClassLoadLoginFailure() throws Exception {
        this.client.testNamespaceClassLoad(this.badLogin, this.namespaceName, DebugIterator.class.getName(), SortedKeyValueIterator.class.getName());
    }

    @Test
    public void tableNotFound() throws Exception {
        String doesNotExist = "doesNotExists";
        try {
            this.client.addConstraint(this.creds, "doesNotExists", NumericValueConstraint.class.getName());
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.addSplits(this.creds, "doesNotExists", Collections.emptySet());
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        IteratorSetting setting = new IteratorSetting(100, "slow", SlowIterator.class.getName(), Collections.singletonMap("sleepTime", "200"));
        try {
            this.client.attachIterator(this.creds, "doesNotExists", setting, EnumSet.allOf(IteratorScope.class));
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.cancelCompaction(this.creds, "doesNotExists");
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.checkIteratorConflicts(this.creds, "doesNotExists", setting, EnumSet.allOf(IteratorScope.class));
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.clearLocatorCache(this.creds, "doesNotExists");
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            String TABLE_TEST = this.getUniqueNames(1)[0];
            this.client.cloneTable(this.creds, "doesNotExists", TABLE_TEST, false, null, null);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.compactTable(this.creds, "doesNotExists", null, null, null, true, false, null);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.createBatchScanner(this.creds, "doesNotExists", new BatchScanOptions());
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.createScanner(this.creds, "doesNotExists", new ScanOptions());
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.createWriter(this.creds, "doesNotExists", new WriterOptions());
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.deleteRows(this.creds, "doesNotExists", null, null);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.deleteTable(this.creds, "doesNotExists");
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.exportTable(this.creds, "doesNotExists", "/tmp");
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.flushTable(this.creds, "doesNotExists", null, null, false);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.getIteratorSetting(this.creds, "doesNotExists", "foo", IteratorScope.SCAN);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.getLocalityGroups(this.creds, "doesNotExists");
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.getMaxRow(this.creds, "doesNotExists", Collections.emptySet(), null, false, null, false);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.getTableProperties(this.creds, "doesNotExists");
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.grantTablePermission(this.creds, "root", "doesNotExists", TablePermission.WRITE);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            this.client.hasTablePermission(this.creds, "root", "doesNotExists", TablePermission.WRITE);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException TABLE_TEST) {
            // empty catch block
        }
        try {
            MiniAccumuloClusterImpl cluster = SharedMiniClusterBase.getCluster();
            Path base = cluster.getTemporaryPath();
            Path importDir = new Path(base, "importDir");
            Path failuresDir = new Path(base, "failuresDir");
            Assert.assertTrue((boolean)cluster.getFileSystem().mkdirs(importDir));
            Assert.assertTrue((boolean)cluster.getFileSystem().mkdirs(failuresDir));
            this.client.importDirectory(this.creds, "doesNotExists", importDir.toString(), failuresDir.toString(), true);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.listConstraints(this.creds, "doesNotExists");
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.listSplits(this.creds, "doesNotExists", 10000);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.mergeTablets(this.creds, "doesNotExists", null, null);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.offlineTable(this.creds, "doesNotExists", false);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.onlineTable(this.creds, "doesNotExists", false);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.removeConstraint(this.creds, "doesNotExists", 0);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.removeIterator(this.creds, "doesNotExists", "name", EnumSet.allOf(IteratorScope.class));
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.removeTableProperty(this.creds, "doesNotExists", Property.TABLE_FILE_MAX.getKey());
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.renameTable(this.creds, "doesNotExists", "someTableName");
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.revokeTablePermission(this.creds, "root", "doesNotExists", TablePermission.ALTER_TABLE);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.setTableProperty(this.creds, "doesNotExists", Property.TABLE_FILE_MAX.getKey(), "0");
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.splitRangeByTablets(this.creds, "doesNotExists", this.client.getRowRange(ByteBuffer.wrap("row".getBytes(StandardCharsets.UTF_8))), 10);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.updateAndFlush(this.creds, "doesNotExists", new HashMap());
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.getDiskUsage(this.creds, Collections.singleton("doesNotExists"));
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.testTableClassLoad(this.creds, "doesNotExists", VersioningIterator.class.getName(), SortedKeyValueIterator.class.getName());
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            this.client.createConditionalWriter(this.creds, "doesNotExists", new ConditionalWriterOptions());
            Assert.fail((String)"exception not thrown");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void namespaceNotFound() throws Exception {
        IteratorSetting setting2;
        String doesNotExist = "doesNotExists";
        try {
            this.client.deleteNamespace(this.creds, "doesNotExists");
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        try {
            this.client.renameNamespace(this.creds, "doesNotExists", "abcdefg");
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        try {
            this.client.setNamespaceProperty(this.creds, "doesNotExists", "table.compaction.major.ratio", "4");
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        try {
            this.client.removeNamespaceProperty(this.creds, "doesNotExists", "table.compaction.major.ratio");
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        try {
            this.client.getNamespaceProperties(this.creds, "doesNotExists");
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        try {
            setting2 = new IteratorSetting(100, "DebugTheThings", DebugIterator.class.getName(), Collections.emptyMap());
            this.client.attachNamespaceIterator(this.creds, "doesNotExists", setting2, EnumSet.allOf(IteratorScope.class));
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException setting2) {
            // empty catch block
        }
        try {
            this.client.removeNamespaceIterator(this.creds, "doesNotExists", "DebugTheThings", EnumSet.allOf(IteratorScope.class));
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException setting2) {
            // empty catch block
        }
        try {
            this.client.getNamespaceIteratorSetting(this.creds, "doesNotExists", "DebugTheThings", IteratorScope.SCAN);
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException setting2) {
            // empty catch block
        }
        try {
            this.client.listNamespaceIterators(this.creds, "doesNotExists");
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException setting2) {
            // empty catch block
        }
        try {
            setting2 = new IteratorSetting(100, "DebugTheThings", DebugIterator.class.getName(), Collections.emptyMap());
            this.client.checkNamespaceIteratorConflicts(this.creds, "doesNotExists", setting2, EnumSet.allOf(IteratorScope.class));
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        try {
            this.client.addNamespaceConstraint(this.creds, "doesNotExists", MaxMutationSize.class.getName());
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        try {
            this.client.removeNamespaceConstraint(this.creds, "doesNotExists", 1);
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        try {
            this.client.listNamespaceConstraints(this.creds, "doesNotExists");
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        try {
            this.client.testNamespaceClassLoad(this.creds, "doesNotExists", DebugIterator.class.getName(), SortedKeyValueIterator.class.getName());
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testExists() throws Exception {
        this.client.createTable(this.creds, "ett1", false, TimeType.MILLIS);
        this.client.createTable(this.creds, "ett2", false, TimeType.MILLIS);
        try {
            this.client.createTable(this.creds, "ett1", false, TimeType.MILLIS);
            Assert.fail((String)"exception not thrown");
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
        try {
            this.client.renameTable(this.creds, "ett1", "ett2");
            Assert.fail((String)"exception not thrown");
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
        try {
            this.client.cloneTable(this.creds, "ett1", "ett2", false, new HashMap(), new HashSet());
            Assert.fail((String)"exception not thrown");
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testNamespaceExists() throws Exception {
        this.client.createNamespace(this.creds, "foobar");
        try {
            this.client.createNamespace(this.creds, this.namespaceName);
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceExistsException namespaceExistsException) {
            // empty catch block
        }
        try {
            this.client.renameNamespace(this.creds, "foobar", this.namespaceName);
            Assert.fail((String)"exception not thrown");
        }
        catch (NamespaceExistsException namespaceExistsException) {
            // empty catch block
        }
    }

    @Test(expected=NamespaceNotEmptyException.class)
    public void testNamespaceNotEmpty() throws Exception {
        this.client.createTable(this.creds, this.namespaceName + ".abcdefg", true, TimeType.MILLIS);
        this.client.deleteNamespace(this.creds, this.namespaceName);
    }

    @Test
    public void testUnknownScanner() throws Exception {
        String scanner = this.client.createScanner(this.creds, this.tableName, null);
        Assert.assertFalse((boolean)this.client.hasNext(scanner));
        this.client.closeScanner(scanner);
        try {
            this.client.hasNext(scanner);
            Assert.fail((String)"exception not thrown");
        }
        catch (UnknownScanner unknownScanner) {
            // empty catch block
        }
        try {
            this.client.closeScanner(scanner);
            Assert.fail((String)"exception not thrown");
        }
        catch (UnknownScanner unknownScanner) {
            // empty catch block
        }
        try {
            this.client.nextEntry("99999999");
            Assert.fail((String)"exception not thrown");
        }
        catch (UnknownScanner unknownScanner) {
            // empty catch block
        }
        try {
            this.client.nextK("99999999", 6);
            Assert.fail((String)"exception not thrown");
        }
        catch (UnknownScanner unknownScanner) {
            // empty catch block
        }
        try {
            this.client.hasNext("99999999");
            Assert.fail((String)"exception not thrown");
        }
        catch (UnknownScanner unknownScanner) {
            // empty catch block
        }
        try {
            this.client.hasNext(UUID.randomUUID().toString());
            Assert.fail((String)"exception not thrown");
        }
        catch (UnknownScanner unknownScanner) {
            // empty catch block
        }
    }

    @Test
    public void testUnknownWriter() throws Exception {
        String writer = this.client.createWriter(this.creds, this.tableName, null);
        this.client.update(writer, this.mutation("row0", "cf", "cq", "value"));
        this.client.flush(writer);
        this.client.update(writer, this.mutation("row2", "cf", "cq", "value2"));
        this.client.closeWriter(writer);
        this.client.update(writer, this.mutation("row2", "cf", "cq", "value2"));
        try {
            this.client.flush(writer);
            Assert.fail((String)"exception not thrown");
        }
        catch (UnknownWriter unknownWriter) {
            // empty catch block
        }
        try {
            this.client.flush("99999");
            Assert.fail((String)"exception not thrown");
        }
        catch (UnknownWriter unknownWriter) {
            // empty catch block
        }
        try {
            this.client.flush(UUID.randomUUID().toString());
            Assert.fail((String)"exception not thrown");
        }
        catch (UnknownWriter unknownWriter) {
            // empty catch block
        }
        try {
            this.client.closeWriter("99999");
            Assert.fail((String)"exception not thrown");
        }
        catch (UnknownWriter unknownWriter) {
            // empty catch block
        }
    }

    @Test
    public void testDelete() throws Exception {
        this.client.updateAndFlush(this.creds, this.tableName, this.mutation("row0", "cf", "cq", "value"));
        this.assertScan(new String[][]{{"row0", "cf", "cq", "value"}}, this.tableName);
        ColumnUpdate upd = new ColumnUpdate(this.s2bb("cf"), this.s2bb("cq"));
        upd.setDeleteCell(false);
        Map<ByteBuffer, List<ColumnUpdate>> notDelete = Collections.singletonMap(this.s2bb("row0"), Collections.singletonList(upd));
        this.client.updateAndFlush(this.creds, this.tableName, notDelete);
        String scanner = this.client.createScanner(this.creds, this.tableName, null);
        ScanResult entries = this.client.nextK(scanner, 10);
        this.client.closeScanner(scanner);
        Assert.assertFalse((boolean)entries.more);
        Assert.assertEquals((String)("Results: " + entries.results), (long)1L, (long)entries.results.size());
        upd = new ColumnUpdate(this.s2bb("cf"), this.s2bb("cq"));
        upd.setDeleteCell(true);
        Map<ByteBuffer, List<ColumnUpdate>> delete = Collections.singletonMap(this.s2bb("row0"), Collections.singletonList(upd));
        this.client.updateAndFlush(this.creds, this.tableName, delete);
        this.assertScan(new String[0][], this.tableName);
    }

    @Test
    public void testSystemProperties() throws Exception {
        int i;
        Map cfg = this.client.getSiteConfiguration(this.creds);
        this.client.setProperty(this.creds, "table.split.threshold", "500M");
        for (i = 0; i < 5 && !"500M".equals((cfg = this.client.getSystemConfiguration(this.creds)).get("table.split.threshold")); ++i) {
            UtilWaitThread.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertEquals((Object)"500M", cfg.get("table.split.threshold"));
        this.client.removeProperty(this.creds, "table.split.threshold");
        for (i = 0; i < 5 && "500M".equals((cfg = this.client.getSystemConfiguration(this.creds)).get("table.split.threshold")); ++i) {
            UtilWaitThread.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertNotEquals((Object)"500M", cfg.get("table.split.threshold"));
    }

    @Test
    public void pingTabletServers() throws Exception {
        int tservers = 0;
        for (String tserver : this.client.getTabletServers(this.creds)) {
            this.client.pingTabletServer(this.creds, tserver);
            ++tservers;
        }
        Assert.assertTrue((tservers > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSiteConfiguration() throws Exception {
        MiniAccumuloClusterImpl cluster = SharedMiniClusterBase.getCluster();
        Map cfg = this.client.getSiteConfiguration(this.creds);
        Assert.assertTrue((boolean)((String)cfg.get("instance.dfs.dir")).startsWith(cluster.getConfig().getAccumuloDir().getAbsolutePath()));
    }

    @Test
    public void testClassLoad() throws Exception {
        Assert.assertTrue((boolean)this.client.testClassLoad(this.creds, DevNull.class.getName(), SortedKeyValueIterator.class.getName()));
        Assert.assertFalse((boolean)this.client.testClassLoad(this.creds, "foo.bar", SortedKeyValueIterator.class.getName()));
    }

    @Test
    public void attachIteratorsWithScans() throws Exception {
        if (this.client.tableExists(this.creds, "slow")) {
            this.client.deleteTable(this.creds, "slow");
        }
        this.client.createTable(this.creds, "slow", true, TimeType.MILLIS);
        IteratorSetting setting = new IteratorSetting(100, "slow", SlowIterator.class.getName(), Collections.singletonMap("sleepTime", "250"));
        this.client.attachIterator(this.creds, "slow", setting, EnumSet.allOf(IteratorScope.class));
        for (int i = 0; i < 40; ++i) {
            this.client.updateAndFlush(this.creds, "slow", this.mutation("row" + i, "cf", "cq", "value"));
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                TestProxyClient proxyClient2 = null;
                try {
                    if (SimpleProxyBase.isKerberosEnabled()) {
                        UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
                        proxyClient2 = new TestProxyClient(hostname, proxyPort, factory, proxyPrimary, UserGroupInformation.getCurrentUser());
                    } else {
                        proxyClient2 = new TestProxyClient(hostname, proxyPort, factory);
                    }
                    AccumuloProxy.Client client2 = proxyClient2.proxy();
                    String scanner = client2.createScanner(SimpleProxyBase.this.creds, "slow", null);
                    client2.nextK(scanner, 10);
                    client2.closeScanner(scanner);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (null != proxyClient2) {
                        proxyClient2.close();
                    }
                }
            }
        };
        t.start();
        ArrayList<ActiveScan> scans = new ArrayList<ActiveScan>();
        block1: for (int i = 0; i < 100 && scans.isEmpty(); ++i) {
            for (String tserver : this.client.getTabletServers(this.creds)) {
                List scansForServer = this.client.getActiveScans(this.creds, tserver);
                for (ActiveScan scan : scansForServer) {
                    if (!clientPrincipal.equals(scan.getUser())) continue;
                    scans.add(scan);
                }
                if (!scans.isEmpty()) continue block1;
                UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        t.join();
        Assert.assertFalse((String)"Expected to find scans, but found none", (boolean)scans.isEmpty());
        boolean found = false;
        Map map = null;
        for (int i = 0; i < scans.size() && !found; ++i) {
            ActiveScan scan = (ActiveScan)scans.get(i);
            if (!clientPrincipal.equals(scan.getUser())) continue;
            Assert.assertTrue((ScanState.RUNNING.equals((Object)scan.getState()) || ScanState.QUEUED.equals((Object)scan.getState()) ? 1 : 0) != 0);
            Assert.assertEquals((Object)ScanType.SINGLE, (Object)scan.getType());
            Assert.assertEquals((Object)"slow", (Object)scan.getTable());
            map = this.client.tableIdMap(this.creds);
            Assert.assertEquals(map.get("slow"), (Object)scan.getExtent().tableId);
            Assert.assertTrue((scan.getExtent().endRow == null ? 1 : 0) != 0);
            Assert.assertTrue((scan.getExtent().prevEndRow == null ? 1 : 0) != 0);
            found = true;
        }
        Assert.assertTrue((String)"Could not find a scan against the 'slow' table", (boolean)found);
    }

    @Test
    public void attachIteratorWithCompactions() throws Exception {
        if (this.client.tableExists(this.creds, "slow")) {
            this.client.deleteTable(this.creds, "slow");
        }
        this.client.createTable(this.creds, "slow", true, TimeType.MILLIS);
        IteratorSetting setting = new IteratorSetting(100, "slow", SlowIterator.class.getName(), Collections.singletonMap("sleepTime", "250"));
        this.client.attachIterator(this.creds, "slow", setting, EnumSet.allOf(IteratorScope.class));
        for (int i = 0; i < 40; ++i) {
            this.client.updateAndFlush(this.creds, "slow", this.mutation("row" + i, "cf", "cq", "value"));
        }
        Map map = this.client.tableIdMap(this.creds);
        Thread t = new Thread(){

            @Override
            public void run() {
                TestProxyClient proxyClient2 = null;
                try {
                    if (SimpleProxyBase.isKerberosEnabled()) {
                        UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
                        proxyClient2 = new TestProxyClient(hostname, proxyPort, factory, proxyPrimary, UserGroupInformation.getCurrentUser());
                    } else {
                        proxyClient2 = new TestProxyClient(hostname, proxyPort, factory);
                    }
                    AccumuloProxy.Client client2 = proxyClient2.proxy();
                    client2.compactTable(SimpleProxyBase.this.creds, "slow", null, null, null, true, true, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (null != proxyClient2) {
                        proxyClient2.close();
                    }
                }
            }
        };
        t.start();
        String desiredTableId = (String)map.get("slow");
        Assert.assertNotNull((Object)desiredTableId);
        ArrayList<ActiveCompaction> compactions = new ArrayList<ActiveCompaction>();
        for (int i = 0; i < 100 && compactions.isEmpty(); ++i) {
            for (String tserver : this.client.getTabletServers(this.creds)) {
                List compactionsOnServer = this.client.getActiveCompactions(this.creds, tserver);
                for (ActiveCompaction compact : compactionsOnServer) {
                    if (!desiredTableId.equals(compact.getExtent().tableId)) continue;
                    compactions.add(compact);
                }
                if (compactions.isEmpty()) continue;
                break;
            }
            UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        t.join();
        Assert.assertFalse((boolean)compactions.isEmpty());
        for (ActiveCompaction c : compactions) {
            if (!desiredTableId.equals(c.getExtent().tableId)) continue;
            Assert.assertTrue((boolean)c.inputFiles.isEmpty());
            Assert.assertEquals((Object)CompactionType.MINOR, (Object)c.getType());
            Assert.assertEquals((Object)CompactionReason.USER, (Object)c.getReason());
            Assert.assertEquals((Object)"", (Object)c.localityGroup);
            Assert.assertTrue((boolean)c.outputFile.contains("default_tablet"));
            return;
        }
        Assert.fail((String)"Expection to find running compaction for table 'slow' but did not find one");
    }

    @Test
    public void userAuthentication() throws Exception {
        if (SimpleProxyBase.isKerberosEnabled()) {
            Assert.assertTrue((boolean)this.client.authenticateUser(this.creds, clientPrincipal, Collections.emptyMap()));
        } else {
            Assert.assertTrue((boolean)this.client.authenticateUser(this.creds, "root", this.s2pp(SharedMiniClusterBase.getRootPassword())));
            Assert.assertFalse((boolean)this.client.authenticateUser(this.creds, "root", this.s2pp("")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void userManagement() throws Exception {
        String user;
        ClusterUser otherClient = null;
        ByteBuffer password = this.s2bb("password");
        if (SimpleProxyBase.isKerberosEnabled()) {
            otherClient = SimpleProxyBase.getKdc().getClientPrincipal(1);
            user = otherClient.getPrincipal();
        } else {
            user = this.getUniqueNames(1)[0];
        }
        this.client.createLocalUser(this.creds, user, password);
        Set users = this.client.listLocalUsers(this.creds);
        HashSet<String> expectedUsers = new HashSet<String>(Arrays.asList(clientPrincipal, user));
        Assert.assertTrue((String)("Did not find all expected users: " + expectedUsers), (boolean)users.containsAll(expectedUsers));
        HashSet<ByteBuffer> auths = new HashSet<ByteBuffer>(Arrays.asList(this.s2bb("A"), this.s2bb("B")));
        this.client.changeUserAuthorizations(this.creds, user, auths);
        List update = this.client.getUserAuthorizations(this.creds, user);
        Assert.assertEquals(auths, new HashSet(update));
        if (!SimpleProxyBase.isKerberosEnabled()) {
            password = this.s2bb("");
            this.client.changeLocalUserPassword(this.creds, user, password);
            Assert.assertTrue((boolean)this.client.authenticateUser(this.creds, user, this.s2pp(ByteBufferUtil.toString((ByteBuffer)password))));
        }
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)otherClient.getPrincipal(), (String)otherClient.getKeytab().getAbsolutePath());
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            TestProxyClient otherProxyClient = null;
            try {
                otherProxyClient = new TestProxyClient(hostname, proxyPort, factory, proxyPrimary, ugi);
                otherProxyClient.proxy().login(user, Collections.emptyMap());
            }
            finally {
                if (null != otherProxyClient) {
                    otherProxyClient.close();
                }
            }
        } else {
            this.client.login(user, this.s2pp(ByteBufferUtil.toString((ByteBuffer)password)));
        }
    }

    @Test
    public void userPermissions() throws Exception {
        String scanner2;
        ByteBuffer user;
        String userName = this.getUniqueNames(1)[0];
        ClusterUser otherClient = null;
        ByteBuffer password = this.s2bb("password");
        TestProxyClient origProxyClient = null;
        AccumuloProxy.Client origClient = null;
        TestProxyClient userProxyClient = null;
        AccumuloProxy.Client userClient = null;
        if (SimpleProxyBase.isKerberosEnabled()) {
            otherClient = SimpleProxyBase.getKdc().getClientPrincipal(1);
            userName = otherClient.getPrincipal();
            UserGroupInformation.loginUserFromKeytab((String)otherClient.getPrincipal(), (String)otherClient.getKeytab().getAbsolutePath());
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            userProxyClient = new TestProxyClient(hostname, proxyPort, factory, proxyPrimary, ugi);
            origProxyClient = this.proxyClient;
            origClient = this.client;
            userClient = this.client = userProxyClient.proxy();
            user = this.client.login(userName, Collections.emptyMap());
        } else {
            userName = this.getUniqueNames(1)[0];
            this.client.createLocalUser(this.creds, userName, password);
            user = this.client.login(userName, this.s2pp(ByteBufferUtil.toString((ByteBuffer)password)));
        }
        try {
            this.client.createTable(user, "fail", true, TimeType.MILLIS);
            Assert.fail((String)"should not create the table");
        }
        catch (AccumuloSecurityException ex) {
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
                this.client = origClient;
            }
            Assert.assertFalse((boolean)this.client.listTables(this.creds).contains("fail"));
        }
        Assert.assertFalse((boolean)this.client.hasSystemPermission(this.creds, userName, SystemPermission.CREATE_TABLE));
        this.client.grantSystemPermission(this.creds, userName, SystemPermission.CREATE_TABLE);
        Assert.assertTrue((boolean)this.client.hasSystemPermission(this.creds, userName, SystemPermission.CREATE_TABLE));
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)otherClient.getPrincipal(), (String)otherClient.getKeytab().getAbsolutePath());
            this.client = userClient;
        }
        this.client.createTable(user, "success", true, TimeType.MILLIS);
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
            this.client = origClient;
        }
        Assert.assertTrue((boolean)this.client.listTables(this.creds).contains("success"));
        this.client.revokeSystemPermission(this.creds, userName, SystemPermission.CREATE_TABLE);
        Assert.assertFalse((boolean)this.client.hasSystemPermission(this.creds, userName, SystemPermission.CREATE_TABLE));
        try {
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)otherClient.getPrincipal(), (String)otherClient.getKeytab().getAbsolutePath());
                this.client = userClient;
            }
            this.client.createTable(user, "fail", true, TimeType.MILLIS);
            Assert.fail((String)"should not create the table");
        }
        catch (AccumuloSecurityException ex) {
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
                this.client = origClient;
            }
            Assert.assertFalse((boolean)this.client.listTables(this.creds).contains("fail"));
        }
        try {
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)otherClient.getPrincipal(), (String)otherClient.getKeytab().getAbsolutePath());
                this.client = userClient;
            }
            scanner2 = this.client.createScanner(user, this.tableName, null);
            this.client.nextK(scanner2, 100);
            Assert.fail((String)"stooge should not read table test");
        }
        catch (AccumuloSecurityException scanner2) {
            // empty catch block
        }
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
            this.client = origClient;
        }
        Assert.assertFalse((boolean)this.client.hasTablePermission(this.creds, userName, this.tableName, TablePermission.READ));
        this.client.grantTablePermission(this.creds, userName, this.tableName, TablePermission.READ);
        Assert.assertTrue((boolean)this.client.hasTablePermission(this.creds, userName, this.tableName, TablePermission.READ));
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)otherClient.getPrincipal(), (String)otherClient.getKeytab().getAbsolutePath());
            this.client = userClient;
        }
        scanner2 = this.client.createScanner(user, this.tableName, null);
        this.client.nextK(scanner2, 10);
        this.client.closeScanner(scanner2);
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
            this.client = origClient;
        }
        this.client.revokeTablePermission(this.creds, userName, this.tableName, TablePermission.READ);
        Assert.assertFalse((boolean)this.client.hasTablePermission(this.creds, userName, this.tableName, TablePermission.READ));
        try {
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)otherClient.getPrincipal(), (String)otherClient.getKeytab().getAbsolutePath());
                this.client = userClient;
            }
            scanner2 = this.client.createScanner(user, this.tableName, null);
            this.client.nextK(scanner2, 100);
            Assert.fail((String)"stooge should not read table test");
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
            this.client = origClient;
        }
        this.client.dropLocalUser(this.creds, userName);
        Set users = this.client.listLocalUsers(this.creds);
        Assert.assertFalse((String)"Should not see user after they are deleted", (boolean)users.contains(userName));
        if (SimpleProxyBase.isKerberosEnabled()) {
            userProxyClient.close();
            this.proxyClient = origProxyClient;
            this.client = origClient;
        }
    }

    @Test
    public void namespacePermissions() throws Exception {
        ByteBuffer user;
        String userName;
        ClusterUser otherClient = null;
        ByteBuffer password = this.s2bb("password");
        TestProxyClient origProxyClient = null;
        AccumuloProxy.Client origClient = null;
        TestProxyClient userProxyClient = null;
        AccumuloProxy.Client userClient = null;
        if (SimpleProxyBase.isKerberosEnabled()) {
            otherClient = SimpleProxyBase.getKdc().getClientPrincipal(1);
            userName = otherClient.getPrincipal();
            UserGroupInformation.loginUserFromKeytab((String)otherClient.getPrincipal(), (String)otherClient.getKeytab().getAbsolutePath());
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            userProxyClient = new TestProxyClient(hostname, proxyPort, factory, proxyPrimary, ugi);
            origProxyClient = this.proxyClient;
            origClient = this.client;
            userClient = this.client = userProxyClient.proxy();
            user = this.client.login(userName, Collections.emptyMap());
        } else {
            userName = this.getUniqueNames(1)[0];
            this.client.createLocalUser(this.creds, userName, password);
            user = this.client.login(userName, this.s2pp(ByteBufferUtil.toString((ByteBuffer)password)));
        }
        try {
            this.client.createTable(user, this.namespaceName + ".fail", true, TimeType.MILLIS);
            Assert.fail((String)"should not create the table");
        }
        catch (AccumuloSecurityException ex) {
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
                this.client = origClient;
            }
            Assert.assertFalse((boolean)this.client.listTables(this.creds).contains(this.namespaceName + ".fail"));
        }
        Assert.assertFalse((boolean)this.client.hasNamespacePermission(this.creds, userName, this.namespaceName, NamespacePermission.CREATE_TABLE));
        this.client.grantNamespacePermission(this.creds, userName, this.namespaceName, NamespacePermission.CREATE_TABLE);
        Assert.assertTrue((boolean)this.client.hasNamespacePermission(this.creds, userName, this.namespaceName, NamespacePermission.CREATE_TABLE));
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)otherClient.getPrincipal(), (String)otherClient.getKeytab().getAbsolutePath());
            this.client = userClient;
        }
        this.client.createTable(user, this.namespaceName + ".success", true, TimeType.MILLIS);
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
            this.client = origClient;
        }
        Assert.assertTrue((boolean)this.client.listTables(this.creds).contains(this.namespaceName + ".success"));
        this.client.revokeNamespacePermission(this.creds, userName, this.namespaceName, NamespacePermission.CREATE_TABLE);
        Assert.assertFalse((boolean)this.client.hasNamespacePermission(this.creds, userName, this.namespaceName, NamespacePermission.CREATE_TABLE));
        try {
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)otherClient.getPrincipal(), (String)otherClient.getKeytab().getAbsolutePath());
                this.client = userClient;
            }
            this.client.createTable(user, this.namespaceName + ".fail", true, TimeType.MILLIS);
            Assert.fail((String)"should not create the table");
        }
        catch (AccumuloSecurityException ex) {
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
                this.client = origClient;
            }
            Assert.assertFalse((boolean)this.client.listTables(this.creds).contains(this.namespaceName + ".fail"));
        }
        this.client.dropLocalUser(this.creds, userName);
        Set users = this.client.listLocalUsers(this.creds);
        Assert.assertFalse((String)"Should not see user after they are deleted", (boolean)users.contains(userName));
        if (SimpleProxyBase.isKerberosEnabled()) {
            userProxyClient.close();
            this.proxyClient = origProxyClient;
            this.client = origClient;
        }
        this.client.deleteTable(this.creds, this.namespaceName + ".success");
    }

    @Test
    public void testBatchWriter() throws Exception {
        String batchWriter;
        int i;
        this.client.addConstraint(this.creds, this.tableName, NumericValueConstraint.class.getName());
        UtilWaitThread.sleepUninterruptibly((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.client.offlineTable(this.creds, this.tableName, true);
        this.client.onlineTable(this.creds, this.tableName, true);
        WriterOptions writerOptions = new WriterOptions();
        writerOptions.setLatencyMs(10000L);
        writerOptions.setMaxMemory(2L);
        writerOptions.setThreads(1);
        writerOptions.setTimeoutMs(100000L);
        Map constraints = this.client.listConstraints(this.creds, this.tableName);
        while (!constraints.containsKey(NumericValueConstraint.class.getName())) {
            log.info("Constraints don't contain NumericValueConstraint");
            Thread.sleep(2000L);
            constraints = this.client.listConstraints(this.creds, this.tableName);
        }
        boolean success = false;
        for (i = 0; i < 15; ++i) {
            batchWriter = this.client.createWriter(this.creds, this.tableName, writerOptions);
            this.client.update(batchWriter, this.mutation("row1", "cf", "cq", "x"));
            this.client.update(batchWriter, this.mutation("row1", "cf", "cq", "x"));
            try {
                this.client.flush(batchWriter);
                log.debug("Constraint failed to fire. Waiting and retrying");
                Thread.sleep(5000L);
                continue;
            }
            catch (MutationsRejectedException mutationsRejectedException) {
                try {
                    this.client.closeWriter(batchWriter);
                    log.debug("Constraint failed to fire. Waiting and retrying");
                    Thread.sleep(5000L);
                    continue;
                }
                catch (MutationsRejectedException mutationsRejectedException2) {
                    success = true;
                    break;
                }
            }
        }
        if (!success) {
            Assert.fail((String)"constraint did not fire");
        }
        this.client.removeConstraint(this.creds, this.tableName, 2);
        this.client.offlineTable(this.creds, this.tableName, true);
        this.client.onlineTable(this.creds, this.tableName, true);
        constraints = this.client.listConstraints(this.creds, this.tableName);
        while (constraints.containsKey(NumericValueConstraint.class.getName())) {
            log.info("Constraints still contains NumericValueConstraint");
            Thread.sleep(2000L);
            constraints = this.client.listConstraints(this.creds, this.tableName);
        }
        this.assertScan(new String[0][], this.tableName);
        UtilWaitThread.sleepUninterruptibly((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
        writerOptions = new WriterOptions();
        writerOptions.setLatencyMs(10000L);
        writerOptions.setMaxMemory(3000L);
        writerOptions.setThreads(1);
        writerOptions.setTimeoutMs(100000L);
        success = false;
        for (i = 0; i < 15; ++i) {
            try {
                batchWriter = this.client.createWriter(this.creds, this.tableName, writerOptions);
                this.client.update(batchWriter, this.mutation("row1", "cf", "cq", "x"));
                this.client.flush(batchWriter);
                this.client.closeWriter(batchWriter);
                success = true;
                break;
            }
            catch (MutationsRejectedException e) {
                log.info("Mutations were rejected, assuming constraint is still active", (Throwable)e);
                Thread.sleep(5000L);
                continue;
            }
        }
        if (!success) {
            Assert.fail((String)"Failed to successfully write data after constraint was removed");
        }
        this.assertScan(new String[][]{{"row1", "cf", "cq", "x"}}, this.tableName);
        this.client.deleteTable(this.creds, this.tableName);
    }

    @Test
    public void testTableConstraints() throws Exception {
        log.debug("Setting NumericValueConstraint on " + this.tableName);
        this.client.addConstraint(this.creds, this.tableName, NumericValueConstraint.class.getName());
        Thread.sleep(10000L);
        this.client.offlineTable(this.creds, this.tableName, true);
        this.client.onlineTable(this.creds, this.tableName, true);
        log.debug("Attempting to verify client-side that constraints are observed");
        Map constraints = this.client.listConstraints(this.creds, this.tableName);
        while (!constraints.containsKey(NumericValueConstraint.class.getName())) {
            log.debug("Constraints don't contain NumericValueConstraint");
            Thread.sleep(2000L);
            constraints = this.client.listConstraints(this.creds, this.tableName);
        }
        Assert.assertEquals((long)2L, (long)this.client.listConstraints(this.creds, this.tableName).size());
        log.debug("Verified client-side that constraints exist");
        this.client.updateAndFlush(this.creds, this.tableName, this.mutation("row1", "cf", "cq", "123"));
        log.debug("Successfully wrote data that satisfies the constraint");
        log.debug("Trying to write data that the constraint should reject");
        try {
            while (true) {
                this.client.updateAndFlush(this.creds, this.tableName, this.mutation("row1", "cf", "cq", "x"));
                log.debug("Expected mutation to be rejected, but was not. Waiting and retrying");
                Thread.sleep(5000L);
            }
        }
        catch (MutationsRejectedException ex) {
            log.debug("Saw expected failure on data which fails the constraint");
            log.debug("Removing constraint from table");
            this.client.removeConstraint(this.creds, this.tableName, 2);
            UtilWaitThread.sleepUninterruptibly((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.client.offlineTable(this.creds, this.tableName, true);
            this.client.onlineTable(this.creds, this.tableName, true);
            constraints = this.client.listConstraints(this.creds, this.tableName);
            while (constraints.containsKey(NumericValueConstraint.class.getName())) {
                log.debug("Constraints contains NumericValueConstraint");
                Thread.sleep(2000L);
                constraints = this.client.listConstraints(this.creds, this.tableName);
            }
            Assert.assertEquals((long)1L, (long)this.client.listConstraints(this.creds, this.tableName).size());
            log.debug("Verified client-side that the constraint was removed");
            log.debug("Attempting to write mutation that should succeed after constraints was removed");
            while (true) {
                try {
                    this.client.updateAndFlush(this.creds, this.tableName, this.mutation("row1", "cf", "cq", "x"));
                }
                catch (MutationsRejectedException ex2) {
                    log.debug("Expected mutation accepted, but was not. Waiting and retrying");
                    Thread.sleep(5000L);
                    continue;
                }
                break;
            }
            log.debug("Verifying that record can be read from the table");
            this.assertScan(new String[][]{{"row1", "cf", "cq", "x"}}, this.tableName);
            return;
        }
    }

    @Test
    public void tableMergesAndSplits() throws Exception {
        this.client.addSplits(this.creds, this.tableName, new HashSet<ByteBuffer>(Arrays.asList(this.s2bb("a"), this.s2bb("m"), this.s2bb("z"))));
        List splits = this.client.listSplits(this.creds, this.tableName, 1);
        Assert.assertEquals(Arrays.asList(this.s2bb("m")), (Object)splits);
        this.client.mergeTablets(this.creds, this.tableName, null, this.s2bb("m"));
        splits = this.client.listSplits(this.creds, this.tableName, 10);
        Assert.assertEquals(Arrays.asList(this.s2bb("m"), this.s2bb("z")), (Object)splits);
        this.client.mergeTablets(this.creds, this.tableName, null, null);
        splits = this.client.listSplits(this.creds, this.tableName, 10);
        List empty = Collections.emptyList();
        Assert.assertEquals(empty, (Object)splits);
    }

    @Test
    public void iteratorFunctionality() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("type", "STRING");
        options.put("columns", "cf");
        IteratorSetting setting = new IteratorSetting(10, this.tableName, SummingCombiner.class.getName(), options);
        this.client.attachIterator(this.creds, this.tableName, setting, EnumSet.allOf(IteratorScope.class));
        for (int i = 0; i < 10; ++i) {
            this.client.updateAndFlush(this.creds, this.tableName, this.mutation("row1", "cf", "cq", "1"));
        }
        this.assertScan(new String[][]{{"row1", "cf", "cq", "10"}}, this.tableName);
        try {
            this.client.checkIteratorConflicts(this.creds, this.tableName, setting, EnumSet.allOf(IteratorScope.class));
            Assert.fail((String)"checkIteratorConflicts did not throw an exception");
        }
        catch (Exception i) {
            // empty catch block
        }
        this.client.deleteRows(this.creds, this.tableName, null, null);
        this.client.removeIterator(this.creds, this.tableName, "test", EnumSet.allOf(IteratorScope.class));
        String[][] expected = new String[10][];
        for (int i = 0; i < 10; ++i) {
            this.client.updateAndFlush(this.creds, this.tableName, this.mutation("row" + i, "cf", "cq", "" + i));
            expected[i] = new String[]{"row" + i, "cf", "cq", "" + i};
            this.client.flushTable(this.creds, this.tableName, null, null, true);
        }
        this.assertScan(expected, this.tableName);
    }

    @Test
    public void cloneTable() throws Exception {
        String TABLE_TEST2 = this.getUniqueNames(2)[1];
        String[][] expected = new String[10][];
        for (int i = 0; i < 10; ++i) {
            this.client.updateAndFlush(this.creds, this.tableName, this.mutation("row" + i, "cf", "cq", "" + i));
            expected[i] = new String[]{"row" + i, "cf", "cq", "" + i};
            this.client.flushTable(this.creds, this.tableName, null, null, true);
        }
        this.assertScan(expected, this.tableName);
        this.client.cloneTable(this.creds, this.tableName, TABLE_TEST2, true, null, null);
        this.assertScan(expected, TABLE_TEST2);
        this.client.deleteTable(this.creds, TABLE_TEST2);
    }

    @Test
    public void clearLocatorCache() throws Exception {
        this.client.clearLocatorCache(this.creds, this.tableName);
    }

    @Test
    public void compactTable() throws Exception {
        String[][] expected = new String[10][];
        for (int i = 0; i < 10; ++i) {
            this.client.updateAndFlush(this.creds, this.tableName, this.mutation("row" + i, "cf", "cq", "" + i));
            expected[i] = new String[]{"row" + i, "cf", "cq", "" + i};
            this.client.flushTable(this.creds, this.tableName, null, null, true);
        }
        this.assertScan(expected, this.tableName);
        this.client.compactTable(this.creds, this.tableName, null, null, null, true, true, null);
        Assert.assertEquals((long)1L, (long)this.countFiles(this.tableName));
        this.assertScan(expected, this.tableName);
    }

    @Test
    public void diskUsage() throws Exception {
        String TABLE_TEST2 = this.getUniqueNames(2)[1];
        String[][] expected = new String[10][];
        for (int i = 0; i < 10; ++i) {
            this.client.updateAndFlush(this.creds, this.tableName, this.mutation("row" + i, "cf", "cq", "" + i));
            expected[i] = new String[]{"row" + i, "cf", "cq", "" + i};
            this.client.flushTable(this.creds, this.tableName, null, null, true);
        }
        this.assertScan(expected, this.tableName);
        this.client.compactTable(this.creds, this.tableName, null, null, null, true, true, null);
        Assert.assertEquals((long)1L, (long)this.countFiles(this.tableName));
        this.assertScan(expected, this.tableName);
        this.client.cloneTable(this.creds, this.tableName, TABLE_TEST2, true, null, null);
        HashSet<String> tablesToScan = new HashSet<String>();
        tablesToScan.add(this.tableName);
        tablesToScan.add(TABLE_TEST2);
        tablesToScan.add("foo");
        this.client.createTable(this.creds, "foo", true, TimeType.MILLIS);
        List diskUsage = this.client.getDiskUsage(this.creds, tablesToScan);
        Assert.assertEquals((long)2L, (long)diskUsage.size());
        Assert.assertEquals((long)2L, (long)((DiskUsage)diskUsage.get(0)).getTables().size());
        Assert.assertEquals((long)1L, (long)((DiskUsage)diskUsage.get(1)).getTables().size());
        this.client.compactTable(this.creds, TABLE_TEST2, null, null, null, true, true, null);
        diskUsage = this.client.getDiskUsage(this.creds, tablesToScan);
        Assert.assertEquals((long)3L, (long)diskUsage.size());
        Assert.assertEquals((long)1L, (long)((DiskUsage)diskUsage.get(0)).getTables().size());
        Assert.assertEquals((long)1L, (long)((DiskUsage)diskUsage.get(1)).getTables().size());
        Assert.assertEquals((long)1L, (long)((DiskUsage)diskUsage.get(2)).getTables().size());
        this.client.deleteTable(this.creds, "foo");
        this.client.deleteTable(this.creds, TABLE_TEST2);
    }

    @Test
    public void importExportTable() throws Exception {
        String[][] expected = new String[10][];
        for (int i = 0; i < 10; ++i) {
            this.client.updateAndFlush(this.creds, this.tableName, this.mutation("row" + i, "cf", "cq", "" + i));
            expected[i] = new String[]{"row" + i, "cf", "cq", "" + i};
            this.client.flushTable(this.creds, this.tableName, null, null, true);
        }
        this.assertScan(expected, this.tableName);
        MiniAccumuloClusterImpl cluster = SharedMiniClusterBase.getCluster();
        FileSystem fs = cluster.getFileSystem();
        Path base = cluster.getTemporaryPath();
        Path dir = new Path(base, "test");
        Assert.assertTrue((boolean)fs.mkdirs(dir));
        Path destDir = new Path(base, "test_dest");
        Assert.assertTrue((boolean)fs.mkdirs(destDir));
        this.client.offlineTable(this.creds, this.tableName, false);
        this.client.exportTable(this.creds, this.tableName, dir.toString());
        FSDataInputStream is = fs.open(new Path(dir, "distcp.txt"));
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                Path srcPath = new Path(line);
                FileUtil.copy((FileSystem)fs, (Path)srcPath, (FileSystem)fs, (Path)destDir, (boolean)false, (Configuration)fs.getConf());
            }
        }
        this.client.deleteTable(this.creds, this.tableName);
        this.client.importTable(this.creds, "testify", destDir.toString());
        this.assertScan(expected, "testify");
        this.client.deleteTable(this.creds, "testify");
        try {
            this.client.importTable(this.creds, "testify2", destDir.toString());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.client.listTables(this.creds).contains("testify2"));
    }

    @Test
    public void localityGroups() throws Exception {
        HashMap<String, Set<String>> groups = new HashMap<String, Set<String>>();
        groups.put("group1", Collections.singleton("cf1"));
        groups.put("group2", Collections.singleton("cf2"));
        this.client.setLocalityGroups(this.creds, this.tableName, groups);
        Assert.assertEquals(groups, (Object)this.client.getLocalityGroups(this.creds, this.tableName));
    }

    @Test
    public void tableProperties() throws Exception {
        Map systemProps = this.client.getSystemConfiguration(this.creds);
        String systemTableSplitThreshold = (String)systemProps.get("table.split.threshold");
        Map orig = this.client.getTableProperties(this.creds, this.tableName);
        this.client.setTableProperty(this.creds, this.tableName, "table.split.threshold", "500M");
        Map update = this.client.getTableProperties(this.creds, this.tableName);
        Assert.assertEquals(update.get("table.split.threshold"), (Object)"500M");
        Assert.assertEquals((Object)systemTableSplitThreshold, this.client.getSystemConfiguration(this.creds).get("table.split.threshold"));
        this.client.removeTableProperty(this.creds, this.tableName, "table.split.threshold");
        update = this.client.getTableProperties(this.creds, this.tableName);
        Assert.assertEquals((Object)orig, (Object)update);
    }

    @Test
    public void tableRenames() throws Exception {
        Map tables = this.client.tableIdMap(this.creds);
        this.client.renameTable(this.creds, this.tableName, "bar");
        Map tables2 = this.client.tableIdMap(this.creds);
        Assert.assertEquals(tables.get(this.tableName), tables2.get("bar"));
        Assert.assertTrue((boolean)this.client.tableExists(this.creds, "bar"));
        Assert.assertFalse((boolean)this.client.tableExists(this.creds, this.tableName));
        this.client.renameTable(this.creds, "bar", this.tableName);
    }

    @Test
    public void bulkImport() throws Exception {
        MiniAccumuloClusterImpl cluster = SharedMiniClusterBase.getCluster();
        FileSystem fs = cluster.getFileSystem();
        Path base = cluster.getTemporaryPath();
        Path dir = new Path(base, "test");
        Assert.assertTrue((boolean)fs.mkdirs(dir));
        String filename = dir + "/bulk/import/rfile.rf";
        FileSKVWriter writer = ((FileOperations.OpenWriterOperationBuilder)FileOperations.getInstance().newWriterBuilder().forFile(filename, fs, fs.getConf()).withTableConfiguration((AccumuloConfiguration)DefaultConfiguration.getInstance())).build();
        writer.startDefaultLocalityGroup();
        writer.append(new org.apache.accumulo.core.data.Key(new Text("a"), new Text("b"), new Text("c")), new Value("value".getBytes(StandardCharsets.UTF_8)));
        writer.close();
        fs.mkdirs(new Path(dir + "/bulk/fail"));
        this.client.importDirectory(this.creds, this.tableName, dir + "/bulk/import", dir + "/bulk/fail", true);
        String scanner = this.client.createScanner(this.creds, this.tableName, null);
        ScanResult more = this.client.nextK(scanner, 100);
        this.client.closeScanner(scanner);
        Assert.assertEquals((long)1L, (long)more.results.size());
        ByteBuffer maxRow = this.client.getMaxRow(this.creds, this.tableName, null, null, false, null, false);
        Assert.assertEquals((Object)this.s2bb("a"), (Object)maxRow);
    }

    @Test
    public void testTableClassLoad() throws Exception {
        Assert.assertFalse((boolean)this.client.testTableClassLoad(this.creds, this.tableName, "abc123", SortedKeyValueIterator.class.getName()));
        Assert.assertTrue((boolean)this.client.testTableClassLoad(this.creds, this.tableName, VersioningIterator.class.getName(), SortedKeyValueIterator.class.getName()));
    }

    private Condition newCondition(String cf, String cq) {
        return new Condition(new Column(this.s2bb(cf), this.s2bb(cq), this.s2bb("")));
    }

    private Condition newCondition(String cf, String cq, String val) {
        return this.newCondition(cf, cq).setValue(this.s2bb(val));
    }

    private Condition newCondition(String cf, String cq, long ts, String val) {
        return this.newCondition(cf, cq).setValue(this.s2bb(val)).setTimestamp(ts);
    }

    private ColumnUpdate newColUpdate(String cf, String cq, String val) {
        return new ColumnUpdate(this.s2bb(cf), this.s2bb(cq)).setValue(this.s2bb(val));
    }

    private ColumnUpdate newColUpdate(String cf, String cq, long ts, String val) {
        return new ColumnUpdate(this.s2bb(cf), this.s2bb(cq)).setTimestamp(ts).setValue(this.s2bb(val));
    }

    private void assertScan(String[][] expected, String table) throws Exception {
        String scid = this.client.createScanner(this.creds, table, new ScanOptions());
        ScanResult keyValues = this.client.nextK(scid, expected.length + 1);
        Assert.assertEquals((String)("Saw " + keyValues.results), (long)expected.length, (long)keyValues.results.size());
        Assert.assertFalse((boolean)keyValues.more);
        for (int i = 0; i < keyValues.results.size(); ++i) {
            this.checkKey(expected[i][0], expected[i][1], expected[i][2], expected[i][3], (KeyValue)keyValues.results.get(i));
        }
        this.client.closeScanner(scid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConditionalWriter() throws Exception {
        Map<String, String> cwProperties;
        String principal;
        log.debug("Adding constraint {} to {}", (Object)this.tableName, (Object)NumericValueConstraint.class.getName());
        this.client.addConstraint(this.creds, this.tableName, NumericValueConstraint.class.getName());
        UtilWaitThread.sleepUninterruptibly((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.client.offlineTable(this.creds, this.tableName, true);
        this.client.onlineTable(this.creds, this.tableName, true);
        while (!this.client.listConstraints(this.creds, this.tableName).containsKey(NumericValueConstraint.class.getName())) {
            log.info("Failed to see constraint");
            Thread.sleep(1000L);
        }
        String cwid = this.client.createConditionalWriter(this.creds, this.tableName, new ConditionalWriterOptions());
        HashMap<ByteBuffer, ConditionalUpdates> updates = new HashMap<ByteBuffer, ConditionalUpdates>();
        updates.put(this.s2bb("00345"), new ConditionalUpdates(Arrays.asList(this.newCondition("meta", "seq")), Arrays.asList(this.newColUpdate("meta", "seq", 10L, "1"), this.newColUpdate("data", "img", "73435435"))));
        Map results = this.client.updateRowsConditionally(cwid, updates);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ConditionalStatus.ACCEPTED, results.get(this.s2bb("00345")));
        this.assertScan(new String[][]{{"00345", "data", "img", "73435435"}, {"00345", "meta", "seq", "1"}}, this.tableName);
        updates.clear();
        updates.put(this.s2bb("00345"), new ConditionalUpdates(Arrays.asList(this.newCondition("meta", "seq")), Arrays.asList(this.newColUpdate("meta", "seq", "2"))));
        updates.put(this.s2bb("00346"), new ConditionalUpdates(Arrays.asList(this.newCondition("meta", "seq")), Arrays.asList(this.newColUpdate("meta", "seq", "1"))));
        results = this.client.updateRowsConditionally(cwid, updates);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)ConditionalStatus.REJECTED, results.get(this.s2bb("00345")));
        Assert.assertEquals((Object)ConditionalStatus.ACCEPTED, results.get(this.s2bb("00346")));
        this.assertScan(new String[][]{{"00345", "data", "img", "73435435"}, {"00345", "meta", "seq", "1"}, {"00346", "meta", "seq", "1"}}, this.tableName);
        updates.clear();
        updates.put(this.s2bb("00345"), new ConditionalUpdates(Arrays.asList(this.newCondition("meta", "seq", "1")), Arrays.asList(this.newColUpdate("meta", "seq", 20L, "2"), this.newColUpdate("data", "img", "567890"))));
        updates.put(this.s2bb("00346"), new ConditionalUpdates(Arrays.asList(this.newCondition("meta", "seq", "2")), Arrays.asList(this.newColUpdate("meta", "seq", "3"))));
        results = this.client.updateRowsConditionally(cwid, updates);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)ConditionalStatus.ACCEPTED, results.get(this.s2bb("00345")));
        Assert.assertEquals((Object)ConditionalStatus.REJECTED, results.get(this.s2bb("00346")));
        this.assertScan(new String[][]{{"00345", "data", "img", "567890"}, {"00345", "meta", "seq", "2"}, {"00346", "meta", "seq", "1"}}, this.tableName);
        updates.clear();
        updates.put(this.s2bb("00345"), new ConditionalUpdates(Arrays.asList(this.newCondition("meta", "seq", 10L, "2")), Arrays.asList(this.newColUpdate("meta", "seq", 30L, "3"), this.newColUpdate("data", "img", "1234567890"))));
        results = this.client.updateRowsConditionally(cwid, updates);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ConditionalStatus.REJECTED, results.get(this.s2bb("00345")));
        this.assertScan(new String[][]{{"00345", "data", "img", "567890"}, {"00345", "meta", "seq", "2"}, {"00346", "meta", "seq", "1"}}, this.tableName);
        updates.clear();
        updates.put(this.s2bb("00345"), new ConditionalUpdates(Arrays.asList(this.newCondition("meta", "seq", 20L, "2")), Arrays.asList(this.newColUpdate("meta", "seq", 30L, "3"), this.newColUpdate("data", "img", "1234567890"))));
        results = this.client.updateRowsConditionally(cwid, updates);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ConditionalStatus.ACCEPTED, results.get(this.s2bb("00345")));
        this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}}, this.tableName);
        this.client.updateAndFlush(this.creds, this.tableName, Collections.singletonMap(this.s2bb("00347"), Arrays.asList(this.newColUpdate("data", "count", "1"))));
        this.client.updateAndFlush(this.creds, this.tableName, Collections.singletonMap(this.s2bb("00347"), Arrays.asList(this.newColUpdate("data", "count", "1"))));
        this.client.updateAndFlush(this.creds, this.tableName, Collections.singletonMap(this.s2bb("00347"), Arrays.asList(this.newColUpdate("data", "count", "1"))));
        updates.clear();
        updates.put(this.s2bb("00347"), new ConditionalUpdates(Arrays.asList(this.newCondition("data", "count", "3")), Arrays.asList(this.newColUpdate("data", "img", "1234567890"))));
        results = this.client.updateRowsConditionally(cwid, updates);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ConditionalStatus.REJECTED, results.get(this.s2bb("00347")));
        this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}, {"00347", "data", "count", "1"}}, this.tableName);
        Condition iterCond = this.newCondition("data", "count", "3");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", "STRING");
        props.put("columns", "data:count");
        IteratorSetting is = new IteratorSetting(1, "sumc", SummingCombiner.class.getName(), props);
        iterCond.setIterators(Arrays.asList(is));
        updates.clear();
        updates.put(this.s2bb("00347"), new ConditionalUpdates(Arrays.asList(iterCond), Arrays.asList(this.newColUpdate("data", "img", "1234567890"))));
        results = this.client.updateRowsConditionally(cwid, updates);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ConditionalStatus.ACCEPTED, results.get(this.s2bb("00347")));
        this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}, {"00347", "data", "count", "1"}, {"00347", "data", "img", "1234567890"}}, this.tableName);
        ConditionalStatus status = null;
        for (int i = 0; i < 30; ++i) {
            updates.clear();
            updates.put(this.s2bb("00347"), new ConditionalUpdates(Arrays.asList(this.newCondition("data", "img", "1234567890")), Arrays.asList(this.newColUpdate("data", "count", "A"))));
            results = this.client.updateRowsConditionally(cwid, updates);
            Assert.assertEquals((long)1L, (long)results.size());
            status = (ConditionalStatus)results.get(this.s2bb("00347"));
            if (ConditionalStatus.VIOLATED == status) {
                Assert.assertEquals((Object)ConditionalStatus.VIOLATED, (Object)status);
                break;
            }
            log.info("ConditionalUpdate was not rejected by server due to table constraint. Sleeping and retrying");
            Thread.sleep(5000L);
        }
        Assert.assertEquals((Object)ConditionalStatus.VIOLATED, status);
        this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}, {"00347", "data", "count", "1"}, {"00347", "data", "img", "1234567890"}}, this.tableName);
        updates.clear();
        updates.put(this.s2bb("00347"), new ConditionalUpdates(Arrays.asList(this.newCondition("data", "img", "565"), this.newCondition("data", "count", "2")), Arrays.asList(this.newColUpdate("data", "count", "3"), this.newColUpdate("data", "img", "0987654321"))));
        results = this.client.updateRowsConditionally(cwid, updates);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ConditionalStatus.REJECTED, results.get(this.s2bb("00347")));
        this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}, {"00347", "data", "count", "1"}, {"00347", "data", "img", "1234567890"}}, this.tableName);
        updates.clear();
        updates.put(this.s2bb("00347"), new ConditionalUpdates(Arrays.asList(this.newCondition("data", "img", "1234567890"), this.newCondition("data", "count", "2")), Arrays.asList(this.newColUpdate("data", "count", "3"), this.newColUpdate("data", "img", "0987654321"))));
        results = this.client.updateRowsConditionally(cwid, updates);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ConditionalStatus.REJECTED, results.get(this.s2bb("00347")));
        this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}, {"00347", "data", "count", "1"}, {"00347", "data", "img", "1234567890"}}, this.tableName);
        updates.clear();
        updates.put(this.s2bb("00347"), new ConditionalUpdates(Arrays.asList(this.newCondition("data", "img", "565"), this.newCondition("data", "count", "1")), Arrays.asList(this.newColUpdate("data", "count", "3"), this.newColUpdate("data", "img", "0987654321"))));
        results = this.client.updateRowsConditionally(cwid, updates);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)ConditionalStatus.REJECTED, results.get(this.s2bb("00347")));
        this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}, {"00347", "data", "count", "1"}, {"00347", "data", "img", "1234567890"}}, this.tableName);
        ConditionalStatus result = this.client.updateRowConditionally(this.creds, this.tableName, this.s2bb("00347"), new ConditionalUpdates(Arrays.asList(this.newCondition("data", "img", "1234567890"), this.newCondition("data", "count", "1")), Arrays.asList(this.newColUpdate("data", "count", "3"), this.newColUpdate("data", "img", "0987654321"))));
        Assert.assertEquals((Object)ConditionalStatus.ACCEPTED, (Object)result);
        this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}, {"00347", "data", "count", "3"}, {"00347", "data", "img", "0987654321"}}, this.tableName);
        this.client.closeConditionalWriter(cwid);
        try {
            this.client.updateRowsConditionally(cwid, updates);
            Assert.fail((String)"conditional writer not closed");
        }
        catch (UnknownWriter unknownWriter) {
            // empty catch block
        }
        ClusterUser cwuser = null;
        if (SimpleProxyBase.isKerberosEnabled()) {
            cwuser = SimpleProxyBase.getKdc().getClientPrincipal(1);
            principal = cwuser.getPrincipal();
            this.client.createLocalUser(this.creds, principal, this.s2bb("unused"));
        } else {
            principal = "cwuser";
            this.client.createLocalUser(this.creds, principal, this.s2bb("bestpasswordever"));
        }
        this.client.changeUserAuthorizations(this.creds, principal, Collections.singleton(this.s2bb("A")));
        this.client.grantTablePermission(this.creds, principal, this.tableName, TablePermission.WRITE);
        this.client.grantTablePermission(this.creds, principal, this.tableName, TablePermission.READ);
        TestProxyClient cwuserProxyClient = null;
        AccumuloProxy.Client origClient = null;
        if (SimpleProxyBase.isKerberosEnabled()) {
            UserGroupInformation.loginUserFromKeytab((String)cwuser.getPrincipal(), (String)cwuser.getKeytab().getAbsolutePath());
            UserGroupInformation cwuserUgi = UserGroupInformation.getCurrentUser();
            cwuserProxyClient = new TestProxyClient(hostname, proxyPort, factory, proxyPrimary, cwuserUgi);
            origClient = this.client;
            this.client = cwuserProxyClient.proxy();
            cwProperties = Collections.emptyMap();
        } else {
            cwProperties = Collections.singletonMap("password", "bestpasswordever");
        }
        try {
            ByteBuffer cwCreds = this.client.login(principal, cwProperties);
            cwid = this.client.createConditionalWriter(cwCreds, this.tableName, new ConditionalWriterOptions().setAuthorizations(Collections.singleton(this.s2bb("A"))));
            updates.clear();
            updates.put(this.s2bb("00348"), new ConditionalUpdates(Arrays.asList(new Condition(new Column(this.s2bb("data"), this.s2bb("c"), this.s2bb("A")))), Arrays.asList(this.newColUpdate("data", "seq", "1"), this.newColUpdate("data", "c", "1").setColVisibility(this.s2bb("A")))));
            updates.put(this.s2bb("00349"), new ConditionalUpdates(Arrays.asList(new Condition(new Column(this.s2bb("data"), this.s2bb("c"), this.s2bb("B")))), Arrays.asList(this.newColUpdate("data", "seq", "1"))));
            results = this.client.updateRowsConditionally(cwid, updates);
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((Object)ConditionalStatus.ACCEPTED, results.get(this.s2bb("00348")));
            Assert.assertEquals((Object)ConditionalStatus.INVISIBLE_VISIBILITY, results.get(this.s2bb("00349")));
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
                this.client = origClient;
            }
            this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}, {"00347", "data", "count", "3"}, {"00347", "data", "img", "0987654321"}, {"00348", "data", "seq", "1"}}, this.tableName);
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)cwuser.getPrincipal(), (String)cwuser.getKeytab().getAbsolutePath());
                this.client = cwuserProxyClient.proxy();
            }
            updates.clear();
            updates.clear();
            updates.put(this.s2bb("00348"), new ConditionalUpdates(Arrays.asList(new Condition(new Column(this.s2bb("data"), this.s2bb("c"), this.s2bb("A"))).setValue(this.s2bb("0"))), Arrays.asList(this.newColUpdate("data", "seq", "2"), this.newColUpdate("data", "c", "2").setColVisibility(this.s2bb("A")))));
            results = this.client.updateRowsConditionally(cwid, updates);
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)ConditionalStatus.REJECTED, results.get(this.s2bb("00348")));
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
                this.client = origClient;
            }
            this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}, {"00347", "data", "count", "3"}, {"00347", "data", "img", "0987654321"}, {"00348", "data", "seq", "1"}}, this.tableName);
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)cwuser.getPrincipal(), (String)cwuser.getKeytab().getAbsolutePath());
                this.client = cwuserProxyClient.proxy();
            }
            updates.clear();
            updates.put(this.s2bb("00348"), new ConditionalUpdates(Arrays.asList(new Condition(new Column(this.s2bb("data"), this.s2bb("c"), this.s2bb("A"))).setValue(this.s2bb("1"))), Arrays.asList(this.newColUpdate("data", "seq", "2"), this.newColUpdate("data", "c", "2").setColVisibility(this.s2bb("A")))));
            results = this.client.updateRowsConditionally(cwid, updates);
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)ConditionalStatus.ACCEPTED, results.get(this.s2bb("00348")));
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
                this.client = origClient;
            }
            this.assertScan(new String[][]{{"00345", "data", "img", "1234567890"}, {"00345", "meta", "seq", "3"}, {"00346", "meta", "seq", "1"}, {"00347", "data", "count", "3"}, {"00347", "data", "img", "0987654321"}, {"00348", "data", "seq", "2"}}, this.tableName);
            if (SimpleProxyBase.isKerberosEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)cwuser.getPrincipal(), (String)cwuser.getKeytab().getAbsolutePath());
                this.client = cwuserProxyClient.proxy();
            }
            this.client.closeConditionalWriter(cwid);
            try {
                this.client.updateRowsConditionally(cwid, updates);
                Assert.fail((String)"conditional writer not closed");
            }
            catch (UnknownWriter unknownWriter) {
                // empty catch block
            }
        }
        finally {
            if (SimpleProxyBase.isKerberosEnabled()) {
                if (null != cwuserProxyClient) {
                    cwuserProxyClient.close();
                }
                UserGroupInformation.loginUserFromKeytab((String)clientPrincipal, (String)clientKeytab.getAbsolutePath());
                this.client = origClient;
            }
            this.client.dropLocalUser(this.creds, principal);
        }
    }

    private void checkKey(String row, String cf, String cq, String val, KeyValue keyValue) {
        Assert.assertEquals((Object)row, (Object)ByteBufferUtil.toString((ByteBuffer)keyValue.key.row));
        Assert.assertEquals((Object)cf, (Object)ByteBufferUtil.toString((ByteBuffer)keyValue.key.colFamily));
        Assert.assertEquals((Object)cq, (Object)ByteBufferUtil.toString((ByteBuffer)keyValue.key.colQualifier));
        Assert.assertEquals((Object)"", (Object)ByteBufferUtil.toString((ByteBuffer)keyValue.key.colVisibility));
        Assert.assertEquals((Object)val, (Object)ByteBufferUtil.toString((ByteBuffer)keyValue.value));
    }

    private int countFiles(String table) throws Exception {
        ScanResult more;
        Map tableIdMap = this.client.tableIdMap(this.creds);
        String tableId = (String)tableIdMap.get(table);
        Key start = new Key();
        start.row = this.s2bb(tableId + ";");
        Key end = new Key();
        end.row = this.s2bb(tableId + "<");
        end = this.client.getFollowing(end, PartialKey.ROW);
        ScanOptions opt = new ScanOptions();
        opt.range = new org.apache.accumulo.proxy.thrift.Range(start, true, end, false);
        opt.columns = Collections.singletonList(new ScanColumn(this.s2bb("file")));
        String scanner = this.client.createScanner(this.creds, "accumulo.metadata", opt);
        int result = 0;
        do {
            more = this.client.nextK(scanner, 100);
            result += more.getResults().size();
        } while (more.more);
        return result;
    }

    private Map<ByteBuffer, List<ColumnUpdate>> mutation(String row, String cf, String cq, String value) {
        ColumnUpdate upd = new ColumnUpdate(this.s2bb(cf), this.s2bb(cq));
        upd.setValue(value.getBytes(StandardCharsets.UTF_8));
        return Collections.singletonMap(this.s2bb(row), Collections.singletonList(upd));
    }

    private ByteBuffer s2bb(String cf) {
        return ByteBuffer.wrap(cf.getBytes(StandardCharsets.UTF_8));
    }

    private Map<String, String> s2pp(String cf) {
        TreeMap<String, String> toRet = new TreeMap<String, String>();
        toRet.put("password", cf);
        return toRet;
    }

    private static ByteBuffer t2bb(Text t) {
        return ByteBuffer.wrap(t.getBytes());
    }

    @Test
    public void testGetRowRange() throws Exception {
        org.apache.accumulo.proxy.thrift.Range range = this.client.getRowRange(this.s2bb("xyzzy"));
        Range range2 = new Range(new Text("xyzzy"));
        Assert.assertEquals((long)0L, (long)range.start.row.compareTo(SimpleProxyBase.t2bb(range2.getStartKey().getRow())));
        Assert.assertEquals((long)0L, (long)range.stop.row.compareTo(SimpleProxyBase.t2bb(range2.getEndKey().getRow())));
        Assert.assertEquals((Object)range.startInclusive, (Object)range2.isStartKeyInclusive());
        Assert.assertEquals((Object)range.stopInclusive, (Object)range2.isEndKeyInclusive());
        Assert.assertEquals((long)0L, (long)range.start.colFamily.compareTo(SimpleProxyBase.t2bb(range2.getStartKey().getColumnFamily())));
        Assert.assertEquals((long)0L, (long)range.start.colQualifier.compareTo(SimpleProxyBase.t2bb(range2.getStartKey().getColumnQualifier())));
        Assert.assertEquals((long)0L, (long)range.stop.colFamily.compareTo(SimpleProxyBase.t2bb(range2.getEndKey().getColumnFamily())));
        Assert.assertEquals((long)0L, (long)range.stop.colQualifier.compareTo(SimpleProxyBase.t2bb(range2.getEndKey().getColumnQualifier())));
        Assert.assertEquals((long)range.start.timestamp, (long)range.start.timestamp);
        Assert.assertEquals((long)range.stop.timestamp, (long)range.stop.timestamp);
    }

    @Test
    public void testCompactionStrategy() throws Exception {
        File jarDir = new File(System.getProperty("user.dir"), "target");
        Assert.assertTrue((jarDir.mkdirs() || jarDir.isDirectory() ? 1 : 0) != 0);
        File jarFile = new File(jarDir, "TestCompactionStrat.jar");
        FileUtils.copyInputStreamToFile((InputStream)SimpleProxyBase.class.getResourceAsStream("/TestCompactionStrat.jar"), (File)jarFile);
        this.client.setProperty(this.creds, Property.VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + "context1", jarFile.toString());
        this.client.setTableProperty(this.creds, this.tableName, Property.TABLE_CLASSPATH.getKey(), "context1");
        this.client.addSplits(this.creds, this.tableName, Collections.singleton(this.s2bb("efg")));
        this.client.updateAndFlush(this.creds, this.tableName, this.mutation("a", "cf", "cq", "v1"));
        this.client.flushTable(this.creds, this.tableName, null, null, true);
        this.client.updateAndFlush(this.creds, this.tableName, this.mutation("b", "cf", "cq", "v2"));
        this.client.flushTable(this.creds, this.tableName, null, null, true);
        this.client.updateAndFlush(this.creds, this.tableName, this.mutation("y", "cf", "cq", "v1"));
        this.client.flushTable(this.creds, this.tableName, null, null, true);
        this.client.updateAndFlush(this.creds, this.tableName, this.mutation("z", "cf", "cq", "v2"));
        this.client.flushTable(this.creds, this.tableName, null, null, true);
        Assert.assertEquals((long)4L, (long)this.countFiles(this.tableName));
        CompactionStrategyConfig csc = new CompactionStrategyConfig();
        csc.setClassName("org.apache.accumulo.test.EfgCompactionStrat");
        this.client.compactTable(this.creds, this.tableName, null, null, null, true, true, csc);
        Assert.assertEquals((long)3L, (long)this.countFiles(this.tableName));
    }

    @Test
    public void namespaceOperations() throws Exception {
        int i;
        Assert.assertEquals((String)"System namespace is wrong", (Object)this.client.systemNamespace(), (Object)"accumulo");
        Assert.assertEquals((String)"Default namespace is wrong", (Object)this.client.defaultNamespace(), (Object)"");
        Assert.assertTrue((String)"Namespace created during setup should exist", (boolean)this.client.namespaceExists(this.creds, this.namespaceName));
        Assert.assertTrue((String)"Namespace listing should contain namespace created during setup", (boolean)this.client.listNamespaces(this.creds).contains(this.namespaceName));
        String newNamespace = "foobar";
        this.client.createNamespace(this.creds, newNamespace);
        Assert.assertTrue((String)"Namespace just created should exist", (boolean)this.client.namespaceExists(this.creds, newNamespace));
        Assert.assertTrue((String)"Namespace listing should contain just created", (boolean)this.client.listNamespaces(this.creds).contains(newNamespace));
        String renamedNamespace = "foobar_renamed";
        this.client.renameNamespace(this.creds, newNamespace, renamedNamespace);
        Assert.assertTrue((String)"Renamed namespace should exist", (boolean)this.client.namespaceExists(this.creds, renamedNamespace));
        Assert.assertTrue((String)"Namespace listing should contain renamed namespace", (boolean)this.client.listNamespaces(this.creds).contains(renamedNamespace));
        Assert.assertFalse((String)"Original namespace should no longer exist", (boolean)this.client.namespaceExists(this.creds, newNamespace));
        Assert.assertFalse((String)"Namespace listing should no longer contain original namespace", (boolean)this.client.listNamespaces(this.creds).contains(newNamespace));
        this.client.deleteNamespace(this.creds, renamedNamespace);
        Assert.assertFalse((String)"Renamed namespace should no longer exist", (boolean)this.client.namespaceExists(this.creds, renamedNamespace));
        Assert.assertFalse((String)"Namespace listing should no longer contain renamed namespace", (boolean)this.client.listNamespaces(this.creds).contains(renamedNamespace));
        Map cfg = this.client.getNamespaceProperties(this.creds, this.namespaceName);
        String defaultProp = (String)cfg.get("table.compaction.major.ratio");
        Assert.assertNotEquals((Object)defaultProp, (Object)"10");
        this.client.setNamespaceProperty(this.creds, this.namespaceName, "table.compaction.major.ratio", "10");
        for (i = 0; i < 5 && !"10".equals((cfg = this.client.getNamespaceProperties(this.creds, this.namespaceName)).get("table.compaction.major.ratio")); ++i) {
            UtilWaitThread.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertTrue((String)"Namespace should contain table.compaction.major.ratio property", (boolean)this.client.getNamespaceProperties(this.creds, this.namespaceName).containsKey("table.compaction.major.ratio"));
        Assert.assertEquals((String)"Namespace property table.compaction.major.ratio property should equal 10", this.client.getNamespaceProperties(this.creds, this.namespaceName).get("table.compaction.major.ratio"), (Object)"10");
        this.client.removeNamespaceProperty(this.creds, this.namespaceName, "table.compaction.major.ratio");
        for (i = 0; i < 5 && defaultProp.equals((cfg = this.client.getNamespaceProperties(this.creds, this.namespaceName)).get("table.compaction.major.ratio")); ++i) {
            UtilWaitThread.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Assert.assertEquals((String)"Namespace should have default value for table.compaction.major.ratio", (Object)defaultProp, cfg.get("table.compaction.major.ratio"));
        Assert.assertTrue((String)"Namespace ID map should contain accumulo", (boolean)this.client.namespaceIdMap(this.creds).containsKey("accumulo"));
        Assert.assertTrue((String)"Namespace ID map should contain namespace created during setup", (boolean)this.client.namespaceIdMap(this.creds).containsKey(this.namespaceName));
        IteratorSetting setting = new IteratorSetting(100, "DebugTheThings", DebugIterator.class.getName(), Collections.emptyMap());
        this.client.attachNamespaceIterator(this.creds, this.namespaceName, setting, EnumSet.of(IteratorScope.SCAN));
        Assert.assertEquals((String)"Wrong iterator setting returned", (Object)setting, (Object)this.client.getNamespaceIteratorSetting(this.creds, this.namespaceName, "DebugTheThings", IteratorScope.SCAN));
        Assert.assertTrue((String)"Namespace iterator settings should contain iterator just added", (boolean)this.client.listNamespaceIterators(this.creds, this.namespaceName).containsKey("DebugTheThings"));
        Assert.assertEquals((String)"Namespace iterator listing should contain iterator scope just added", EnumSet.of(IteratorScope.SCAN), this.client.listNamespaceIterators(this.creds, this.namespaceName).get("DebugTheThings"));
        this.client.checkNamespaceIteratorConflicts(this.creds, this.namespaceName, setting, EnumSet.of(IteratorScope.MAJC));
        this.client.removeNamespaceIterator(this.creds, this.namespaceName, "DebugTheThings", EnumSet.of(IteratorScope.SCAN));
        Assert.assertFalse((String)"Namespace iterator settings should contain iterator just added", (boolean)this.client.listNamespaceIterators(this.creds, this.namespaceName).containsKey("DebugTheThings"));
        int id = this.client.addNamespaceConstraint(this.creds, this.namespaceName, MaxMutationSize.class.getName());
        Assert.assertTrue((String)"Namespace should contain max mutation size constraint", (boolean)this.client.listNamespaceConstraints(this.creds, this.namespaceName).containsKey(MaxMutationSize.class.getName()));
        Assert.assertEquals((String)"Namespace max mutation size constraint id is wrong", (long)id, (long)((Integer)this.client.listNamespaceConstraints(this.creds, this.namespaceName).get(MaxMutationSize.class.getName())).intValue());
        this.client.removeNamespaceConstraint(this.creds, this.namespaceName, id);
        Assert.assertFalse((String)"Namespace should no longer contain max mutation size constraint", (boolean)this.client.listNamespaceConstraints(this.creds, this.namespaceName).containsKey(MaxMutationSize.class.getName()));
        Assert.assertTrue((String)"Namespace class load should work", (boolean)this.client.testNamespaceClassLoad(this.creds, this.namespaceName, DebugIterator.class.getName(), SortedKeyValueIterator.class.getName()));
        Assert.assertFalse((String)"Namespace class load should not work", (boolean)this.client.testNamespaceClassLoad(this.creds, this.namespaceName, "foo.bar", SortedKeyValueIterator.class.getName()));
    }

    static {
        properties = new HashMap<String, String>();
        factory = null;
    }
}

