/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.examples.simple.mapreduce.RowHash;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class MapReduceIT
extends ConfigurableMacBase {
    public static final String hadoopTmpDirArg = "-Dhadoop.tmp.dir=" + System.getProperty("user.dir") + "/target/hadoop-tmp";
    static final String tablename = "mapredf";
    static final String input_cf = "cf-HASHTYPE";
    static final String input_cq = "cq-NOTHASHED";
    static final String input_cfcq = "cf-HASHTYPE:cq-NOTHASHED";
    static final String output_cq = "cq-MD4BASE64";
    static final String output_cfcq = "cf-HASHTYPE:cq-MD4BASE64";

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void test() throws Exception {
        MapReduceIT.runTest(this.getConnector(), this.getCluster());
    }

    static void runTest(Connector c, MiniAccumuloClusterImpl cluster) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, MutationsRejectedException, IOException, InterruptedException, NoSuchAlgorithmException {
        c.tableOperations().create(tablename);
        BatchWriter bw = c.createBatchWriter(tablename, new BatchWriterConfig());
        for (int i = 0; i < 10; ++i) {
            Mutation m = new Mutation((CharSequence)("" + i));
            m.put((CharSequence)input_cf, (CharSequence)input_cq, (CharSequence)("row" + i));
            bw.addMutation(m);
        }
        bw.close();
        Process hash = cluster.exec(RowHash.class, Collections.singletonList(hadoopTmpDirArg), new String[]{"-i", c.getInstance().getInstanceName(), "-z", c.getInstance().getZooKeepers(), "-u", "root", "-p", "testRootPassword1", "-t", tablename, "--column", input_cfcq});
        Assert.assertEquals((long)0L, (long)hash.waitFor());
        Scanner s = c.createScanner(tablename, Authorizations.EMPTY);
        s.fetchColumn(new Text(input_cf), new Text(output_cq));
        int i = 0;
        for (Map.Entry entry : s) {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] check = Base64.getEncoder().encode(md.digest(("row" + i).getBytes()));
            Assert.assertEquals((Object)((Value)entry.getValue()).toString(), (Object)new String(check));
            ++i;
        }
    }
}

