/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tracer.TraceDump;
import org.apache.accumulo.tracer.TraceServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TracerRecoversAfterOfflineTableIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
        cfg.setNumTservers(1);
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        Process tracer = null;
        Connector conn = this.getConnector();
        if (!conn.tableOperations().exists("trace")) {
            MiniAccumuloClusterImpl mac = this.cluster;
            tracer = mac.exec(TraceServer.class, new String[0]);
            while (!conn.tableOperations().exists("trace")) {
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        log.info("Taking table offline");
        conn.tableOperations().offline("trace", true);
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        log.info("Start a distributed trace span");
        DistributedTrace.enable((String)"localhost", (String)"testTrace", (ClientConfiguration)this.getClientConfig());
        Span root = Trace.on((String)"traceTest");
        BatchWriter bw = conn.createBatchWriter(tableName, null);
        Mutation m = new Mutation((CharSequence)"m");
        m.put((CharSequence)"a", (CharSequence)"b", (CharSequence)"c");
        bw.addMutation(m);
        bw.close();
        root.stop();
        log.info("Bringing trace table back online");
        conn.tableOperations().online("trace", true);
        log.info("Trace table is online, should be able to find trace");
        Scanner scanner = conn.createScanner("trace", Authorizations.EMPTY);
        scanner.setRange(new Range(new Text(Long.toHexString(root.traceId()))));
        while (true) {
            final StringBuilder finalBuffer = new StringBuilder();
            int traceCount = TraceDump.printTrace((Scanner)scanner, (TraceDump.Printer)new TraceDump.Printer(){

                public void print(String line) {
                    try {
                        finalBuffer.append(line).append("\n");
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            String traceOutput = finalBuffer.toString();
            log.info("Trace output:" + traceOutput);
            if (traceCount > 0) {
                int lastPos = 0;
                for (String part : "traceTest,close,binMutations".split(",")) {
                    log.info("Looking in trace output for '" + part + "'");
                    int pos = traceOutput.indexOf(part);
                    Assert.assertTrue((String)("Did not find '" + part + "' in output"), (pos > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)("'" + part + "' occurred earlier than the previous element unexpectedly"), (pos > lastPos ? 1 : 0) != 0);
                    lastPos = pos;
                }
                break;
            }
            log.info("Ignoring trace output as traceCount not greater than zero: " + traceCount);
            Thread.sleep(1000L);
        }
        if (tracer != null) {
            tracer.destroy();
        }
    }
}

