/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.ActiveScan;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class InterruptibleScannersIT
extends AccumuloClusterHarness {
    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        final String tableName = this.getUniqueNames(1)[0];
        final Connector conn = this.getConnector();
        conn.tableOperations().create(tableName);
        Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
        IteratorSetting cfg = new IteratorSetting(100, SlowIterator.class);
        SlowIterator.setSeekSleepTime(cfg, 60000L);
        scanner.addScanIterator(cfg);
        final Thread scanThread = Thread.currentThread();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ArrayList scans;
                    String tserver = (String)conn.instanceOperations().getTabletServers().iterator().next();
                    do {
                        scans = new ArrayList(conn.instanceOperations().getActiveScans(tserver));
                        Iterator iter = scans.iterator();
                        while (iter.hasNext()) {
                            ActiveScan scan = (ActiveScan)iter.next();
                            if (AccumuloClusterHarness.getAdminPrincipal().equals(scan.getUser()) && tableName.equals(scan.getTable())) continue;
                            iter.remove();
                        }
                    } while (scans.isEmpty());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                scanThread.interrupt();
            }
        };
        thread.start();
        try {
            Iterators.size((Iterator)scanner.iterator());
            Assert.fail((String)"Scan should not succeed");
        }
        catch (Exception exception) {
        }
        finally {
            thread.join();
        }
    }
}

