/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.celltypes;

import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.monitor.util.celltypes.CellType;

public class TServerLinkType
extends CellType<TabletServerStatus> {
    private static final long serialVersionUID = 1L;

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "-";
        }
        TabletServerStatus status = (TabletServerStatus)obj;
        return String.format("<a href='/tservers?s=%s'>%s</a>", status.name, TServerLinkType.displayName(status));
    }

    public static String displayName(TabletServerStatus status) {
        return TServerLinkType.displayName(status == null ? null : status.name);
    }

    public static String displayName(String address) {
        if (address == null) {
            return "--Unknown--";
        }
        return address;
    }

    @Override
    public int compare(TabletServerStatus o1, TabletServerStatus o2) {
        return TServerLinkType.displayName(o1).compareTo(TServerLinkType.displayName(o2));
    }

    @Override
    public String alignment() {
        return "left";
    }
}

