/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.shard;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.sample.RowColumnSampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.IntersectingIterator;

public class CutoffIntersectingIterator
extends IntersectingIterator {
    private IntersectingIterator sampleII;
    private int sampleMax;
    private boolean hasTop;

    public static void setCutoff(IteratorSetting iterCfg, int cutoff) {
        Preconditions.checkArgument((cutoff >= 0 ? 1 : 0) != 0);
        iterCfg.addOption("cutoff", cutoff + "");
    }

    public boolean hasTop() {
        return this.hasTop && super.hasTop();
    }

    public void seek(Range range, Collection<ByteSequence> seekColumnFamilies, boolean inclusive) throws IOException {
        int count;
        this.sampleII.seek(range, seekColumnFamilies, inclusive);
        for (count = 0; count <= this.sampleMax && this.sampleII.hasTop(); ++count) {
            this.sampleII.next();
        }
        if (count > this.sampleMax) {
            this.hasTop = false;
        } else {
            this.hasTop = true;
            super.seek(range, seekColumnFamilies, inclusive);
        }
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        IteratorEnvironment sampleEnv = env.cloneWithSamplingEnabled();
        this.setMax(sampleEnv, options);
        SortedKeyValueIterator sampleDC = source.deepCopy(sampleEnv);
        this.sampleII = new IntersectingIterator();
        this.sampleII.init(sampleDC, options, env);
    }

    static void validateSamplerConfig(SamplerConfiguration sampleConfig) {
        Objects.requireNonNull(sampleConfig);
        Preconditions.checkArgument((boolean)sampleConfig.getSamplerClassName().equals(RowColumnSampler.class.getName()), (Object)("Unexpected Sampler " + sampleConfig.getSamplerClassName()));
        Preconditions.checkArgument((boolean)((String)sampleConfig.getOptions().get("qualifier")).equals("true"), (Object)"Expected sample on column qualifier");
        Preconditions.checkArgument((boolean)CutoffIntersectingIterator.isNullOrFalse(sampleConfig.getOptions(), "row", "family", "visibility"), (Object)"Expected sample on column qualifier only");
    }

    private void setMax(IteratorEnvironment sampleEnv, Map<String, String> options) {
        String cutoffValue = options.get("cutoff");
        SamplerConfiguration sampleConfig = sampleEnv.getSamplerConfiguration();
        Objects.requireNonNull(cutoffValue, "Expected cutoff option is missing");
        CutoffIntersectingIterator.validateSamplerConfig(sampleConfig);
        int modulus = Integer.parseInt((String)sampleConfig.getOptions().get("modulus"));
        this.sampleMax = Math.round(Float.parseFloat(cutoffValue) / (float)modulus);
    }

    private static boolean isNullOrFalse(Map<String, String> options, String ... keys) {
        for (String key : keys) {
            String val = options.get(key);
            if (val == null || !val.equals("true")) continue;
            return false;
        }
        return true;
    }
}

