/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.AttributeMap;

public class CssContentHeaderItem
extends CssHeaderItem {
    private static final long serialVersionUID = 1L;
    private final CharSequence css;

    public CssContentHeaderItem(CharSequence css, String id) {
        this.css = css;
        this.setId(id);
    }

    public CharSequence getCss() {
        return this.css;
    }

    @Override
    public void render(Response response) {
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute("id", this.getId());
        attributes.putAttribute("nonce", this.getNonce());
        CssUtils.writeInlineStyle(response, this.getCss(), attributes);
    }

    @Override
    public Iterable<?> getRenderTokens() {
        if (Strings.isEmpty(this.getId())) {
            return Collections.singletonList(this.getCss());
        }
        return Arrays.asList(this.getId(), this.getCss());
    }

    public String toString() {
        return "CSSHeaderItem(" + String.valueOf(this.getCss()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssContentHeaderItem that = (CssContentHeaderItem)o;
        return Objects.equals(this.css, that.css);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.css);
    }
}

